/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jcmd {
    private static final String HELPTEXT = "Usage : jcmd <vmid | display name | 0> <arguments>%n%n   -J : supply arguments to the Java VM running jcmd%n   -l : list JVM processes on the local machine%n   -h : print this help message%n%n   <vmid> : Attach API VM ID as shown in jcmd or other Attach API-based tools%n   <display name> : this argument is used to match (either fully or partially) the display name as shown in jcmd or other Attach API-based tools%n   <0> : the jcmd command will be sent to all Java processes detected by this utility%n%n   arguments:%n      help : print the list of diagnostic commands%n      help <command> : print help for the specific command%n      <command> [command arguments] : command from the list returned by \"help\"%n%nlist JVM processes on the local machine. Default behavior when no options are specified.%n%nNOTE: this utility might significantly affect the performance of the target JVM.%n    The available diagnostic commands are determined by%n    the target VM and may vary between VMs.%n";
    private static final String[] HELP_OPTIONS = new String[]{"-h", "help", "-help", "--help"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String firstArgument;
        List<AttachProvider> providers;
        if (args.length == 1) {
            if (Arrays.stream(HELP_OPTIONS).anyMatch(args[0]::equals)) {
                IPC.logMessage("Jcmd exits with HELPTEXT and args[0] = " + args[0]);
                System.out.printf(HELPTEXT, new Object[0]);
                return;
            }
        }
        if ((providers = AttachProvider.providers()) == null || providers.isEmpty()) {
            IPC.logMessage("Jcmd exits when no attach providers available");
            System.err.println("no attach providers available");
            return;
        }
        AttachProvider openj9Provider = providers.get(0);
        List<VirtualMachineDescriptor> vmds = openj9Provider.listVirtualMachines();
        if (vmds == null || vmds.isEmpty()) {
            IPC.logMessage("Jcmd exits when no VMs found");
            System.err.println("no VMs found");
            return;
        }
        String string = firstArgument = 0 == args.length ? "-l" : args[0];
        if ("-l".equals(firstArgument)) {
            IPC.logMessage("Jcmd -l run");
            for (VirtualMachineDescriptor vmd : vmds) {
                StringBuilder outputBuffer = new StringBuilder(vmd.id());
                Util.getTargetInformation(openj9Provider, vmd, false, false, true, outputBuffer);
                System.out.println(outputBuffer.toString());
            }
        } else {
            String command = DiagnosticUtils.makeJcmdCommand(args, 1);
            if (command.isEmpty()) {
                IPC.logMessage("Jcmd exits when there is no jcmd command");
                System.err.printf("There is no jcmd command.%n", new Object[0]);
                System.out.printf(HELPTEXT, new Object[0]);
            } else {
                AttacherDiagnosticsProvider diagProvider = new AttacherDiagnosticsProvider();
                List<String> vmids = Util.findMatchVMIDs(vmds, firstArgument);
                boolean exceptionThrown = false;
                int retry = 0;
                block13: for (String vmid : vmids) {
                    if (!vmid.equals(firstArgument)) {
                        System.out.println(vmid + ":");
                    }
                    do {
                        try {
                            IPC.logMessage("attaching vmid = " + vmid + ", retry = " + retry);
                            diagProvider.attach(vmid);
                            try {
                                Util.runCommandAndPrintResult(diagProvider, command, command);
                                continue block13;
                            }
                            finally {
                                try {
                                    diagProvider.detach();
                                }
                                catch (SocketException se) {
                                    IPC.logMessage("SocketException thrown at diagProvider.detach() vmid = " + vmid, se);
                                }
                                continue block13;
                            }
                        }
                        catch (SocketException se) {
                            IPC.logMessage("SocketException thrown while attaching vmid = " + vmid, se);
                        }
                        catch (IOException e) {
                            IPC.logMessage("IOException thrown while attaching vmid = " + vmid, e);
                            Util.handleCommandException(vmid, e);
                            exceptionThrown = true;
                            continue block13;
                        }
                        if (!IPC.isWindows) {
                            IPC.logMessage("Only retry on Windows platform, vmid = " + vmid);
                            continue block13;
                        }
                        ++retry;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            IPC.logMessage("Ignore Thread.sleep() InterruptedException, vmid = " + vmid);
                        }
                    } while (retry < Util.retry);
                }
                if (exceptionThrown) {
                    System.out.printf(HELPTEXT, new Object[0]);
                }
            }
        }
    }
}

