/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.IOException;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;

public final class TargetDirectory {
    private static final int VARIANT_LIMIT = 100;
    static final int ADVERTISEMENT_FILE_PERMISSIONS = 384;
    static final String ATTACH_NOTIFICATION_SYNC_FILENAME = "attachNotificationSync";
    public static final int SYNC_FILE_PERMISSIONS = 438;
    private static final int TARGET_DIRECTORY_PERMISSIONS = 969;
    private static volatile File targetDirectoryFileObject;
    private static volatile File syncFileObject;
    private static volatile File advertisementFileObject;

    static String createMyDirectory(String myVmId, boolean preserveId) throws IOException {
        int count;
        String newId = myVmId;
        File tgtDir = new File(TargetDirectory.getTargetDirectoryPath(newId));
        if (tgtDir.exists()) {
            IPC.logMessage("target directory file conflict: ", tgtDir.getAbsolutePath());
            if (preserveId) {
                TargetDirectory.deleteMyDirectory(false, newId);
            }
            CommonDirectory.deleteStaleDirectories(null);
        }
        String advertFilename = Advertisement.getFilename();
        if (!preserveId) {
            for (count = 0; tgtDir.exists() && count < 100; ++count) {
                newId = myVmId + '_' + count;
                IPC.logMessage("try VMID ", newId);
                tgtDir = new File(TargetDirectory.getTargetDirectoryPath(newId));
            }
        }
        if (!tgtDir.exists() && count <= 100) {
            String targetDirectoryPath = tgtDir.getAbsolutePath();
            IPC.mkdirWithPermissions(targetDirectoryPath, 969);
            IPC.checkOwnerAccessOnly(targetDirectoryPath);
        } else {
            if (!preserveId) {
                IPC.logMessage("Attach API target directory already exists but is unusable for VMID ", myVmId);
                throw new IOException(Msg.getString("K0547", myVmId));
            }
            IPC.logMessage("Attach API target directory already exists and reused for VMID: ", myVmId);
        }
        File replyFile = new File(tgtDir, "replyInfo");
        if (replyFile.exists()) {
            String absolutePath = replyFile.getAbsolutePath();
            IPC.logMessage("Illegal file in target directory: ", absolutePath);
            throw new IOException(Msg.getString("K0804", absolutePath));
        }
        targetDirectoryFileObject = tgtDir;
        syncFileObject = TargetDirectory.createSyncFileObject(newId);
        if (null == syncFileObject) {
            newId = null;
            IPC.logMessage("createSyncFileObject failed");
        } else {
            TargetDirectory.createMySyncFile();
            advertisementFileObject = new File(targetDirectoryFileObject, advertFilename);
            if (advertisementFileObject.exists() && !advertisementFileObject.delete()) {
                String absolutePath = advertisementFileObject.getAbsolutePath();
                IPC.logMessage("Illegal file found in target directory:", absolutePath);
                throw new IOException(Msg.getString("K0804", absolutePath));
            }
        }
        return newId;
    }

    static boolean deleteMyFiles() {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleting my files: attachInfo files and attachNotificationSync files.");
        }
        if (null == advertisementFileObject || !advertisementFileObject.delete()) {
            return false;
        }
        IPC.logMessage("deleted ", advertisementFileObject.getAbsolutePath());
        advertisementFileObject = null;
        if (null == syncFileObject || !syncFileObject.delete()) {
            return false;
        }
        IPC.logMessage("deleted ", syncFileObject.getAbsolutePath());
        syncFileObject = null;
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleted my files with success.");
        }
        return true;
    }

    private static boolean isHeavyweightRequiredAfterFastpathDeletion(boolean directoryEmpty) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleting my directory ");
        }
        return !directoryEmpty && !TargetDirectory.deleteMyFiles() || null == targetDirectoryFileObject || !targetDirectoryFileObject.delete();
    }

    static void deleteMyDirectory(boolean directoryEmpty) {
        if (TargetDirectory.isHeavyweightRequiredAfterFastpathDeletion(directoryEmpty)) {
            TargetDirectory.deleteTargetDirectory(AttachHandler.getVmId());
        }
    }

    static void deleteMyDirectory(boolean directoryEmpty, String vmId) {
        if (TargetDirectory.isHeavyweightRequiredAfterFastpathDeletion(directoryEmpty)) {
            IPC.logMessage("fast path for deleting files and dirs fail, trying the heavyweight path for vmId: ", vmId);
            TargetDirectory.deleteTargetDirectory(vmId);
        }
    }

    public static void deleteTargetDirectory(String vmId) {
        if (null != vmId && 0 != vmId.length()) {
            File tgtDir = new File(TargetDirectory.getTargetDirectoryPath(vmId));
            File[] vmFiles = tgtDir.listFiles();
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("deleting target directory ", tgtDir.getAbsolutePath());
            }
            if (null != vmFiles) {
                for (File f : vmFiles) {
                    if (!f.delete()) {
                        IPC.logMessage("error deleting directory ", f.getAbsolutePath());
                        continue;
                    }
                    if (1 == IPC.loggingStatus) continue;
                    IPC.logMessage("deleted file ", f.getAbsolutePath());
                }
            }
            if (!tgtDir.delete()) {
                IPC.logMessage("error deleting directory ", tgtDir.getAbsolutePath());
            } else if (1 != IPC.loggingStatus) {
                IPC.logMessage("deleted directory ", tgtDir.getAbsolutePath());
            }
        } else {
            IPC.logMessage("skip deleteTargetDirectory since the vmid was never set - we didn't create the directory");
        }
    }

    static boolean ensureMyAdvertisementExists(String myVmId) {
        if (!AttachHandler.isAttachApiInitialized()) {
            IPC.logMessage("ensureTargetDirectoryExists: attach API not initialized");
            return false;
        }
        if (!advertisementFileObject.exists()) {
            IPC.logMessage("ensureTargetDirectoryExists: advertisement file missing");
            try {
                if (null == TargetDirectory.createMyDirectory(myVmId, true)) {
                    IPC.logMessage("ensureTargetDirectoryExists: error creating target directory");
                    return false;
                }
                Advertisement.createAdvertisementFile(myVmId, AttachHandler.getMainHandler().getDisplayName());
            }
            catch (IOException e) {
                IPC.logMessage("ensureTargetDirectoryExists: IOException creating advertisement file");
                return false;
            }
        }
        return true;
    }

    static void createMySyncFile() throws IOException {
        if (!AttachHandler.isAttachApiTerminated()) {
            File syncFileCopy = syncFileObject;
            if (null == syncFileCopy) {
                IPC.logMessage("createMySyncFile aborted due to null syncFileObject");
            } else if (!syncFileCopy.exists()) {
                if (!syncFileCopy.createNewFile()) {
                    IPC.logMessage(syncFileCopy.getName(), " already exists");
                }
                IPC.chmod(syncFileCopy.getAbsolutePath(), 438);
            }
        }
    }

    public static File createSyncFileObject(String targetVmId) {
        String tdp = TargetDirectory.getTargetDirectoryPath(targetVmId);
        if (null == tdp) {
            return null;
        }
        File syncFile = new File(tdp, ATTACH_NOTIFICATION_SYNC_FILENAME);
        return syncFile;
    }

    public static String getTargetDirectoryPath(String vmId) {
        File cd = CommonDirectory.getCommonDirFileObject();
        if (null == vmId || null == cd) {
            return null;
        }
        return new File(cd, vmId).getPath();
    }

    static File getTargetDirectoryFileObject() {
        return targetDirectoryFileObject;
    }

    static File getSyncFileObject() {
        return syncFileObject;
    }

    static File getAdvertisementFileObject() {
        return advertisementFileObject;
    }
}

