/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Comparator;
import java.util.Properties;

public class DiagnosticProperties {
    private final Properties baseProperties;
    public static final String OPENJ9_DIAGNOSTICS_PREFIX = "openj9_diagnostics.";
    public static final String DIAGNOSTICS_STRING_RESULT = "openj9_diagnostics.string_result";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String DEBUG_PROPERTY = "openj9.tools.attach.diagnostics.debug";
    public static boolean isDebug;

    public DiagnosticProperties(Properties props) {
        this.baseProperties = props;
    }

    public DiagnosticProperties() {
        this.baseProperties = new Properties();
    }

    public void put(String key, int value) {
        this.baseProperties.setProperty(key, Integer.toString(value));
    }

    public void put(String key, String value) {
        this.baseProperties.setProperty(key, value);
    }

    public void put(String key, long value) {
        this.baseProperties.setProperty(key, Long.toString(value));
    }

    public void put(String key, boolean value) {
        this.baseProperties.setProperty(key, Boolean.toString(value));
    }

    private void checkExists(String key) throws IOException {
        if (!this.containsField(key)) {
            throw new IOException("key " + key + " not found");
        }
    }

    public boolean containsField(String key) {
        return this.baseProperties.containsKey(key);
    }

    public int getInt(String key) throws NumberFormatException, IOException {
        this.checkExists(key);
        return Integer.parseInt(this.baseProperties.getProperty(key));
    }

    public long getLong(String key) throws NumberFormatException, IOException {
        this.checkExists(key);
        return Long.parseLong(this.baseProperties.getProperty(key));
    }

    public boolean getBoolean(String key) throws IOException {
        this.checkExists(key);
        return Boolean.parseBoolean(this.baseProperties.getProperty(key));
    }

    public String getString(String key) throws IOException {
        this.checkExists(key);
        return this.baseProperties.getProperty(key);
    }

    public String getPropertyOrNull(String key) {
        return this.baseProperties.getProperty(key);
    }

    public Object getSimple(String typeName, String key) throws NumberFormatException {
        Object value = null;
        String valueString = this.baseProperties.getProperty(key);
        if (null != valueString && (JAVA_LANG_STRING.equals(typeName) || !valueString.isEmpty())) {
            switch (typeName) {
                case "java.lang.Boolean": {
                    value = Boolean.valueOf(valueString);
                    break;
                }
                case "java.lang.Character": {
                    value = Character.valueOf(valueString.charAt(0));
                    break;
                }
                case "java.lang.Byte": {
                    value = Byte.valueOf(valueString);
                    break;
                }
                case "java.lang.Short": {
                    value = Short.valueOf(valueString);
                    break;
                }
                case "java.lang.Integer": {
                    value = Integer.valueOf(valueString);
                    break;
                }
                case "java.lang.Long": {
                    value = Long.valueOf(valueString);
                    break;
                }
                case "java.lang.Float": {
                    value = Float.valueOf(valueString);
                    break;
                }
                case "java.lang.Double": {
                    value = Double.valueOf(valueString);
                    break;
                }
                case "java.lang.String": {
                    value = valueString;
                    break;
                }
            }
        }
        return value;
    }

    public static void dumpPropertiesIfDebug(String msg, DiagnosticProperties props) {
        DiagnosticProperties.dumpPropertiesIfDebug(msg, props.baseProperties);
    }

    public static void dumpPropertiesIfDebug(String msg, Properties props) {
        if (isDebug) {
            if (null != msg) {
                System.err.println(msg);
            }
            if (null != props) {
                String result = DiagnosticProperties.printProperties(props);
                System.err.print(result);
            }
        }
    }

    public static String printProperties(Properties props) {
        StringWriter buff = new StringWriter(1000);
        try (PrintWriter buffWriter = new PrintWriter(buff);){
            props.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString())).forEach(theEntry -> {
                buffWriter.print(theEntry.getKey());
                buffWriter.print("=");
                buffWriter.println((String)theEntry.getValue());
            });
        }
        return buff.toString();
    }

    public String printStringResult() {
        StringWriter buff = new StringWriter(1000);
        try (PrintWriter buffWriter = new PrintWriter(buff);){
            if (Boolean.parseBoolean(this.getPropertyOrNull("openj9_diagnostics.error"))) {
                String errorType = this.getPropertyOrNull("openj9_diagnostics.errortype");
                if (null == errorType) {
                    errorType = "No error type available";
                }
                buffWriter.printf("Error: %s%n", errorType);
                String msg = this.getPropertyOrNull("openj9_diagnostics.errormsg");
                if (null != msg) {
                    buffWriter.println(msg);
                }
            } else {
                buffWriter.println(this.getString(DIAGNOSTICS_STRING_RESULT));
            }
        }
        catch (IOException e) {
            buff = new StringWriter();
            buff.append("Error parsing properties: ");
            buff.append(e.toString());
            buff.append(System.lineSeparator());
        }
        return buff.toString();
    }

    public static DiagnosticProperties makeStringResult(String text) {
        DiagnosticProperties props = DiagnosticProperties.makeCommandSucceeded();
        props.put(DIAGNOSTICS_STRING_RESULT, text);
        return props;
    }

    public Properties toProperties() {
        return this.baseProperties;
    }

    public static DiagnosticProperties makeCommandSucceeded() {
        DiagnosticProperties props = DiagnosticProperties.makeStatusProperties(false, null);
        props.put(DIAGNOSTICS_STRING_RESULT, "Command succeeded");
        return props;
    }

    public static DiagnosticProperties makeErrorProperties(String message) {
        return DiagnosticProperties.makeStatusProperties(true, message);
    }

    public static DiagnosticProperties makeExceptionProperties(Exception e) {
        DiagnosticProperties props = new DiagnosticProperties();
        props.put("openj9_diagnostics.error", Boolean.toString(true));
        props.put("openj9_diagnostics.errortype", e.getClass().getName());
        String msg = e.getMessage();
        if (null == msg) {
            msg = String.format("Error at %s", e.getStackTrace()[0].toString());
        }
        props.put("openj9_diagnostics.errormsg", msg);
        return props;
    }

    public static DiagnosticProperties makeStatusProperties(boolean error, String msg) {
        DiagnosticProperties props = new DiagnosticProperties();
        props.put("openj9_diagnostics.error", Boolean.toString(error));
        props.put("openj9_diagnostics.errortype", "Error in command");
        if (null != msg) {
            props.put("openj9_diagnostics.errormsg", msg);
        }
        return props;
    }

    static {
        AccessController.doPrivileged(() -> {
            isDebug = Boolean.getBoolean(DEBUG_PROPERTY);
            return null;
        });
    }
}

