/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FieldHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleResolver;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Field;

final class StaticFieldSetterHandle
extends FieldHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    StaticFieldSetterHandle(Class<?> referenceClass, String fieldName, Class<?> fieldClass, Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(StaticFieldSetterHandle.fieldMethodType(fieldClass), referenceClass, fieldName, fieldClass, (byte)4, accessClass);
    }

    StaticFieldSetterHandle(Field field) throws IllegalAccessException {
        super(StaticFieldSetterHandle.fieldMethodType(field.getType()), field, (byte)4, true);
    }

    StaticFieldSetterHandle(StaticFieldSetterHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType fieldMethodType(Class<?> fieldClass) {
        return MethodType.methodType(Void.TYPE, fieldClass);
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(int newValue, int argPlaceholder) {
        this.initializeClassIfRequired();
        if (this.isVolatile) {
            MethodHandleResolver.UNSAFE.putIntVolatile(this.defc, this.vmSlot, newValue);
        } else {
            MethodHandleResolver.UNSAFE.putInt(this.defc, this.vmSlot, newValue);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(long newValue, int argPlaceholder) {
        this.initializeClassIfRequired();
        if (this.isVolatile) {
            MethodHandleResolver.UNSAFE.putLongVolatile(this.defc, this.vmSlot, newValue);
        } else {
            MethodHandleResolver.UNSAFE.putLong(this.defc, this.vmSlot, newValue);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(float newValue, int argPlaceholder) {
        this.initializeClassIfRequired();
        if (this.isVolatile) {
            MethodHandleResolver.UNSAFE.putFloatVolatile(this.defc, this.vmSlot, newValue);
        } else {
            MethodHandleResolver.UNSAFE.putFloat(this.defc, this.vmSlot, newValue);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(double newValue, int argPlaceholder) {
        this.initializeClassIfRequired();
        if (this.isVolatile) {
            MethodHandleResolver.UNSAFE.putDoubleVolatile(this.defc, this.vmSlot, newValue);
        } else {
            MethodHandleResolver.UNSAFE.putDouble(this.defc, this.vmSlot, newValue);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(Object newValue, int argPlaceholder) {
        this.initializeClassIfRequired();
        if (this.isVolatile) {
            MethodHandleResolver.UNSAFE.putObjectVolatile(this.defc, this.vmSlot, newValue);
        } else {
            MethodHandleResolver.UNSAFE.putObject(this.defc, this.vmSlot, newValue);
        }
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new StaticFieldSetterHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof StaticFieldSetterHandle) {
            ((StaticFieldSetterHandle)right).compareWithStaticFieldSetter(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithStaticFieldSetter(StaticFieldSetterHandle left, Comparator c) {
        this.compareWithField(left, c);
    }
}

