/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FieldHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleResolver;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Field;

final class FieldGetterHandle
extends FieldHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    FieldGetterHandle(Class<?> referenceClass, String fieldName, Class<?> fieldClass, Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(FieldGetterHandle.fieldMethodType(fieldClass, referenceClass), referenceClass, fieldName, fieldClass, (byte)1, accessClass);
    }

    FieldGetterHandle(Field field) throws IllegalAccessException {
        super(FieldGetterHandle.fieldMethodType(field.getType(), field.getDeclaringClass()), field, (byte)1, false);
    }

    FieldGetterHandle(FieldGetterHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType fieldMethodType(Class<?> returnType, Class<?> argument) {
        return MethodType.methodType(returnType, argument);
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        if (this.isVolatile) {
            return MethodHandleResolver.UNSAFE.getIntVolatile(receiver, this.vmSlot + (long)HEADER_SIZE);
        }
        return MethodHandleResolver.UNSAFE.getInt(receiver, this.vmSlot + (long)HEADER_SIZE);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        if (this.isVolatile) {
            return MethodHandleResolver.UNSAFE.getLongVolatile(receiver, this.vmSlot + (long)HEADER_SIZE);
        }
        return MethodHandleResolver.UNSAFE.getLong(receiver, this.vmSlot + (long)HEADER_SIZE);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        if (this.isVolatile) {
            return MethodHandleResolver.UNSAFE.getFloatVolatile(receiver, this.vmSlot + (long)HEADER_SIZE);
        }
        return MethodHandleResolver.UNSAFE.getFloat(receiver, this.vmSlot + (long)HEADER_SIZE);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        if (this.isVolatile) {
            return MethodHandleResolver.UNSAFE.getDoubleVolatile(receiver, this.vmSlot + (long)HEADER_SIZE);
        }
        return MethodHandleResolver.UNSAFE.getDouble(receiver, this.vmSlot + (long)HEADER_SIZE);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        if (this.isVolatile) {
            return MethodHandleResolver.UNSAFE.getObjectVolatile(receiver, this.vmSlot + (long)HEADER_SIZE);
        }
        return MethodHandleResolver.UNSAFE.getObject(receiver, this.vmSlot + (long)HEADER_SIZE);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new FieldGetterHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof FieldGetterHandle) {
            ((FieldGetterHandle)right).compareWithFieldGetter(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithFieldGetter(FieldGetterHandle left, Comparator c) {
        this.compareWithField(left, c);
    }
}

