/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    private String name;
    private int maxPriority = 10;
    ThreadGroup parent;
    int numThreads;
    private Thread[] childrenThreads = new Thread[5];
    int numGroups;
    private ThreadGroup[] childrenGroups = new ThreadGroup[3];
    private Object childrenGroupsLock = new ChildrenGroupsLock();
    private Object childrenThreadsLock = new ChildrenThreadsLock();
    private boolean isDaemon;
    private boolean isDestroyed;
    private int addedNotStartedThreads;

    private ThreadGroup() {
        this.name = "system";
    }

    public ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        if (Thread.currentThread() != null) {
            parent.checkAccess();
        }
        this.name = name;
        this.setParent(parent);
        if (parent != null) {
            this.setMaxPriority(parent.getMaxPriority());
            if (parent.isDaemon()) {
                this.setDaemon(true);
            }
        }
    }

    ThreadGroup(ThreadGroup parent) {
        this.name = "main";
        this.setParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        int i;
        int count = 0;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            i = this.numThreads;
            while (--i >= 0) {
                if (!this.childrenThreads[i].isAlive()) continue;
                ++count;
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (i = 0; i < this.numGroups; ++i) {
                count += this.childrenGroups[i].activeCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        int count = 0;
        Object object = this.childrenGroupsLock;
        synchronized (object) {
            for (int i = 0; i < this.numGroups; ++i) {
                count += 1 + this.childrenGroups[i].activeGroupCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkNewThread(Thread thread) throws IllegalThreadStateException {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (this.isDestroyed) {
                throw new IllegalThreadStateException();
            }
            ++this.addedNotStartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void add(Thread thread) throws IllegalThreadStateException {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (!this.isDestroyed) {
                if (this.childrenThreads.length == this.numThreads) {
                    Thread[] newThreads = new Thread[this.childrenThreads.length * 2];
                    System.arraycopy((Object)this.childrenThreads, 0, (Object)newThreads, 0, this.numThreads);
                    newThreads[this.numThreads++] = thread;
                    this.childrenThreads = newThreads;
                } else {
                    this.childrenThreads[this.numThreads++] = thread;
                }
                --this.addedNotStartedThreads;
            } else {
                throw new IllegalThreadStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ThreadGroup g) throws IllegalThreadStateException {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            Object object2 = this.childrenGroupsLock;
            synchronized (object2) {
                if (!this.isDestroyed()) {
                    if (this.childrenGroups.length == this.numGroups) {
                        ThreadGroup[] newGroups = new ThreadGroup[this.childrenGroups.length * 2];
                        System.arraycopy((Object)this.childrenGroups, 0, (Object)newGroups, 0, this.numGroups);
                        this.childrenGroups = newGroups;
                    }
                } else {
                    throw new IllegalThreadStateException();
                }
                this.childrenGroups[this.numGroups++] = g;
            }
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean b) {
        return true;
    }

    public final void checkAccess() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkAccess(this);
        }
    }

    public final void destroy() {
        this.destroyImpl();
        this.removeFromParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyImpl() {
        this.checkAccess();
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            Object object2 = this.childrenGroupsLock;
            synchronized (object2) {
                if (this.isDestroyed) {
                    throw new IllegalThreadStateException(Msg.getString("K0056"));
                }
                if (this.numThreads > 0) {
                    throw new IllegalThreadStateException(Msg.getString("K0057"));
                }
                int toDestroy = this.numGroups;
                for (int i = 0; i < toDestroy; ++i) {
                    this.childrenGroups[0].destroy();
                }
            }
            this.isDestroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfEmptyDaemon() {
        boolean shouldRemoveFromParent = false;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (this.isDaemon && !this.isDestroyed && this.addedNotStartedThreads == 0 && this.numThreads == 0) {
                Object object2 = this.childrenGroupsLock;
                synchronized (object2) {
                    if (this.numGroups == 0) {
                        this.destroyImpl();
                        shouldRemoveFromParent = true;
                    }
                }
            }
        }
        if (shouldRemoveFromParent) {
            this.removeFromParent();
        }
    }

    private void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public int enumerate(Thread[] threads) {
        return this.enumerate(threads, true);
    }

    public int enumerate(Thread[] threads, boolean recurse) {
        return this.enumerateGeneric(threads, recurse, 0, true);
    }

    public int enumerate(ThreadGroup[] groups) {
        return this.enumerate(groups, true);
    }

    public int enumerate(ThreadGroup[] groups, boolean recurse) {
        return this.enumerateGeneric(groups, recurse, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerateGeneric(Object[] enumeration, boolean recurse, int enumerationIndex, boolean enumeratingThreads) {
        Object syncLock;
        this.checkAccess();
        Object object = syncLock = enumeratingThreads ? this.childrenThreadsLock : this.childrenGroupsLock;
        synchronized (object) {
            int i;
            Object[] immediateCollection = enumeratingThreads ? (Object[])this.childrenThreads : (Object[])this.childrenGroups;
            int n = i = enumeratingThreads ? this.numThreads : this.numGroups;
            while (--i >= 0) {
                if (enumeratingThreads && !((Thread)immediateCollection[i]).isAlive()) continue;
                if (enumerationIndex >= enumeration.length) {
                    return enumerationIndex;
                }
                enumeration[enumerationIndex++] = immediateCollection[i];
            }
        }
        if (recurse) {
            object = this.childrenGroupsLock;
            synchronized (object) {
                for (int i = 0; i < this.numGroups; ++i) {
                    if (enumerationIndex >= enumeration.length) {
                        return enumerationIndex;
                    }
                    enumerationIndex = this.childrenGroups[i].enumerateGeneric(enumeration, recurse, enumerationIndex, enumeratingThreads);
                }
            }
        }
        return enumerationIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int enumerateDeadThreads(Object[] enumeration, int enumerationIndex) {
        Object syncLock;
        boolean recurse = true;
        boolean enumeratingThreads = true;
        Object object = syncLock = enumeratingThreads ? this.childrenThreadsLock : this.childrenGroupsLock;
        synchronized (object) {
            int i;
            Object[] immediateCollection = enumeratingThreads ? (Object[])this.childrenThreads : (Object[])this.childrenGroups;
            int n = i = enumeratingThreads ? this.numThreads : this.numGroups;
            while (--i >= 0) {
                if (enumeratingThreads && ((Thread)immediateCollection[i]).isAlive()) continue;
                if (enumerationIndex >= enumeration.length) {
                    return enumerationIndex;
                }
                enumeration[enumerationIndex++] = immediateCollection[i];
            }
        }
        if (recurse) {
            object = this.childrenGroupsLock;
            synchronized (object) {
                for (int i = 0; i < this.numGroups; ++i) {
                    if (enumerationIndex >= enumeration.length) {
                        return enumerationIndex;
                    }
                    enumerationIndex = this.childrenGroups[i].enumerateDeadThreads(enumeration, enumerationIndex);
                }
            }
        }
        return enumerationIndex;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        } else if (this.name == null || !this.name.equalsIgnoreCase("system")) {
            throw new SecurityException(Msg.getString("K0550"));
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        int i;
        this.checkAccess();
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            for (i = 0; i < this.numThreads; ++i) {
                this.childrenThreads[i].interrupt();
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (i = 0; i < this.numGroups; ++i) {
                this.childrenGroups[i].interrupt();
            }
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            return this.isDestroyed;
        }
    }

    public void list() {
        System.out.println();
        this.list(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(int levels) {
        int i;
        String spaces = "    ";
        for (int i2 = 0; i2 < levels; ++i2) {
            System.out.print(spaces);
        }
        System.out.println(this.toString());
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            for (i = 0; i < this.numThreads; ++i) {
                for (int j = 0; j <= levels; ++j) {
                    System.out.print(spaces);
                }
                System.out.println(this.childrenThreads[i]);
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (i = 0; i < this.numGroups; ++i) {
                this.childrenGroups[i].list(levels + 1);
            }
        }
    }

    public final boolean parentOf(ThreadGroup g) {
        while (g != null) {
            if (this == g) {
                return true;
            }
            g = g.parent;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(Thread thread) {
        boolean isThreadGroupEmpty = false;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            for (int i = 0; i < this.numThreads; ++i) {
                if (this.childrenThreads[i] != thread) continue;
                --this.numThreads;
                if (this.numThreads == 0) {
                    isThreadGroupEmpty = true;
                } else {
                    System.arraycopy((Object)this.childrenThreads, i + 1, (Object)this.childrenThreads, i, this.numThreads - i);
                }
                this.childrenThreads[this.numThreads] = null;
                break;
            }
        }
        if (isThreadGroupEmpty) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
        this.destroyIfEmptyDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup g) {
        Object object = this.childrenGroupsLock;
        synchronized (object) {
            for (int i = 0; i < this.numGroups; ++i) {
                if (this.childrenGroups[i] != g) continue;
                --this.numGroups;
                System.arraycopy((Object)this.childrenGroups, i + 1, (Object)this.childrenGroups, i, this.numGroups - i);
                this.childrenGroups[this.numGroups] = null;
                break;
            }
        }
        this.destroyIfEmptyDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        int i;
        this.checkAccess();
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            for (i = 0; i < this.numThreads; ++i) {
                this.childrenThreads[i].resume();
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (i = 0; i < this.numGroups; ++i) {
                this.childrenGroups[i].resume();
            }
        }
    }

    public final void setDaemon(boolean isDaemon) {
        this.checkAccess();
        this.isDaemon = isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int newMax) {
        this.checkAccess();
        if (1 <= newMax && newMax <= this.maxPriority) {
            int parentPriority = this.parent == null ? newMax : this.parent.getMaxPriority();
            this.maxPriority = parentPriority <= newMax ? parentPriority : newMax;
            Object object = this.childrenGroupsLock;
            synchronized (object) {
                for (int i = 0; i < this.numGroups; ++i) {
                    this.childrenGroups[i].setMaxPriority(newMax);
                }
            }
        }
    }

    private void setParent(ThreadGroup parent) {
        if (parent != null) {
            parent.add(this);
        }
        this.parent = parent;
    }

    @Deprecated
    public final void stop() {
        if (this.stopHelper()) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final boolean stopHelper() {
        this.checkAccess();
        boolean stopCurrent = false;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            Thread current = Thread.currentThread();
            for (int i = 0; i < this.numThreads; ++i) {
                if (this.childrenThreads[i] == current) {
                    stopCurrent = true;
                    continue;
                }
                this.childrenThreads[i].stop();
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (int i = 0; i < this.numGroups; ++i) {
                stopCurrent |= this.childrenGroups[i].stopHelper();
            }
        }
        return stopCurrent;
    }

    @Deprecated
    public final void suspend() {
        if (this.suspendHelper()) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final boolean suspendHelper() {
        this.checkAccess();
        boolean suspendCurrent = false;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            Thread current = Thread.currentThread();
            for (int i = 0; i < this.numThreads; ++i) {
                if (this.childrenThreads[i] == current) {
                    suspendCurrent = true;
                    continue;
                }
                this.childrenThreads[i].suspend();
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            for (int i = 0; i < this.numGroups; ++i) {
                suspendCurrent |= this.childrenGroups[i].suspendHelper();
            }
        }
        return suspendCurrent;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.getMaxPriority() + "]";
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.parent != null) {
            this.parent.uncaughtException(t, e);
        } else {
            Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
            if (handler != null) {
                handler.uncaughtException(t, e);
            } else if (!(e instanceof ThreadDeath)) {
                System.err.print(Msg.getString("K0319", t.getName()));
                e.printStackTrace(System.err);
            }
        }
    }

    private static final class ChildrenGroupsLock {
        ChildrenGroupsLock() {
        }
    }

    private static final class ChildrenThreadsLock {
        ChildrenThreadsLock() {
        }
    }
}

