/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.internal.GuestOSProcessorUsageUtil;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class GuestOSProcessorUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long cpuTime;
    private long timestamp;
    private float cpuEntitlement;
    private long hostCpuClockSpeed;

    public GuestOSProcessorUsage() {
    }

    private GuestOSProcessorUsage(long cpuTime, long timestamp, float cpuEntitlement, long hostCpuClockSpeed) throws IllegalArgumentException {
        if (cpuTime < -1L || cpuEntitlement < -1.0f || hostCpuClockSpeed < -1L || timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        this.cpuTime = cpuTime;
        this.timestamp = timestamp;
        this.cpuEntitlement = cpuEntitlement;
        this.hostCpuClockSpeed = hostCpuClockSpeed;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getHostCpuClockSpeed() {
        return this.hostCpuClockSpeed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getCpuEntitlement() {
        return this.cpuEntitlement;
    }

    void updateValues(long time, long timestamp, float entitlement, long cpuSpeed) {
        this.cpuTime = time;
        this.timestamp = timestamp;
        this.cpuEntitlement = entitlement;
        this.hostCpuClockSpeed = cpuSpeed;
    }

    public static GuestOSProcessorUsage from(CompositeData cd) {
        GuestOSProcessorUsage result = null;
        if (null != cd) {
            long hostCpuClockSpeed;
            float cpuEntitlement;
            long timestamp;
            long cpuTime;
            if (!GuestOSProcessorUsageUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                cpuTime = (Long)cd.get("cpuTime");
                timestamp = (Long)cd.get("timestamp");
                cpuEntitlement = ((Float)cd.get("cpuEntitlement")).floatValue();
                hostCpuClockSpeed = (Long)cd.get("hostCpuClockSpeed");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            result = new GuestOSProcessorUsage(cpuTime, timestamp, cpuEntitlement, hostCpuClockSpeed);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== ");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ==========\n\n");
        sb.append("timestamp = ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("cpuTime = ");
        sb.append(this.cpuTime);
        sb.append("\n");
        sb.append("cpuEntitlement = ");
        sb.append(this.cpuEntitlement);
        sb.append("\n");
        sb.append("hostCpuClockSpeed = ");
        sb.append(this.hostCpuClockSpeed);
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof GuestOSProcessorUsage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GuestOSProcessorUsage gpu = (GuestOSProcessorUsage)obj;
        if (gpu.getCpuTime() != this.getCpuTime()) {
            return false;
        }
        if (gpu.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        if (gpu.getCpuEntitlement() != this.getCpuEntitlement()) {
            return false;
        }
        return gpu.getHostCpuClockSpeed() == this.getHostCpuClockSpeed();
    }

    public int hashCode() {
        long gpHash = this.getCpuTime() + this.getTimestamp() + this.getHostCpuClockSpeed() + (long)this.getCpuEntitlement();
        return (int)(((gpHash >> 32) + gpHash & 0xFFFFFFFL) * 23L);
    }
}

