/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.management.ObjectName;
import openj9.management.internal.IDCacheInitializer;
import openj9.management.internal.ThreadInfoBase;

public class ThreadMXBeanImpl
implements ThreadMXBean {
    private static final ThreadMXBeanImpl instance;
    private static Boolean isThreadCpuTimeEnabled;
    private static Boolean isThreadCpuTimeSupported;
    private static final MethodHandle threadInfoConstructorHandle;
    private ObjectName objectName;

    protected ThreadMXBeanImpl() {
    }

    public static ThreadMXBean getInstance() {
        return instance;
    }

    private native long[] findMonitorDeadlockedThreadsImpl();

    @Override
    public long[] findMonitorDeadlockedThreads() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findMonitorDeadlockedThreadsImpl();
    }

    private native long[] getAllThreadIdsImpl();

    @Override
    public long[] getAllThreadIds() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.getAllThreadIdsImpl();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public long getCurrentThreadUserTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    private native int getDaemonThreadCountImpl();

    @Override
    public int getDaemonThreadCount() {
        return this.getDaemonThreadCountImpl();
    }

    private native int getPeakThreadCountImpl();

    @Override
    public int getPeakThreadCount() {
        return this.getPeakThreadCountImpl();
    }

    private native int getThreadCountImpl();

    @Override
    public int getThreadCount() {
        return this.getThreadCountImpl();
    }

    private native long getThreadCpuTimeImpl(long var1);

    @Override
    public long getThreadCpuTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public ThreadInfo getThreadInfo(long id) {
        return this.getThreadInfo(id, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long id : ids) {
            if (id > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        ThreadInfoBase[] infoBases = this.getMultiThreadInfoImpl(ids, maxDepth, false, false);
        return ThreadMXBeanImpl.makeThreadInfos(infoBases);
    }

    private static ThreadInfo[] makeThreadInfos(ThreadInfoBase[] infoBases) {
        PrivilegedAction<ThreadInfo[]> action = () -> (ThreadInfo[])Arrays.stream(infoBases).map(ThreadMXBeanImpl::makeThreadInfo).toArray(ThreadInfo[]::new);
        return AccessController.doPrivileged(action);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.getThreadInfoCommon(ids, lockedMonitors, lockedSynchronizers, Integer.MAX_VALUE);
    }

    private ThreadInfo[] getThreadInfoCommon(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers, int maxDepth) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long id : ids) {
            if (id > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        return ThreadMXBeanImpl.makeThreadInfos(this.getMultiThreadInfoImpl(ids, maxDepth, lockedMonitors, lockedSynchronizers));
    }

    @Override
    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        PrivilegedAction<ThreadInfo> action = () -> ThreadMXBeanImpl.makeThreadInfo(this.getThreadInfoImpl(id, maxDepth));
        return AccessController.doPrivileged(action);
    }

    private native ThreadInfoBase getThreadInfoImpl(long var1, int var3);

    private native long getThreadUserTimeImpl(long var1);

    @Override
    public long getThreadUserTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    private native long getTotalStartedThreadCountImpl();

    @Override
    public long getTotalStartedThreadCount() {
        return this.getTotalStartedThreadCountImpl();
    }

    private native boolean isCurrentThreadCpuTimeSupportedImpl();

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.isCurrentThreadCpuTimeSupportedImpl();
    }

    private native boolean isThreadContentionMonitoringEnabledImpl();

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        return this.isThreadContentionMonitoringEnabledImpl();
    }

    private native boolean isThreadContentionMonitoringSupportedImpl();

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.isThreadContentionMonitoringSupportedImpl();
    }

    private native boolean isThreadCpuTimeEnabledImpl();

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        if (isThreadCpuTimeEnabled == null) {
            isThreadCpuTimeEnabled = this.isThreadCpuTimeEnabledImpl();
        }
        return isThreadCpuTimeEnabled;
    }

    private native boolean isThreadCpuTimeSupportedImpl();

    @Override
    public boolean isThreadCpuTimeSupported() {
        if (isThreadCpuTimeSupported == null) {
            isThreadCpuTimeSupported = this.isThreadCpuTimeSupportedImpl();
        }
        return isThreadCpuTimeSupported;
    }

    private native void resetPeakThreadCountImpl();

    @Override
    public void resetPeakThreadCount() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakThreadCountImpl();
    }

    private native void setThreadContentionMonitoringEnabledImpl(boolean var1);

    @Override
    public void setThreadContentionMonitoringEnabled(boolean enable) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadContentionMonitoringEnabledImpl(enable);
    }

    private native void setThreadCpuTimeEnabledImpl(boolean var1);

    @Override
    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadCpuTimeEnabledImpl(enable);
        isThreadCpuTimeEnabled = enable;
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.isObjectMonitorUsageSupportedImpl();
    }

    private native boolean isObjectMonitorUsageSupportedImpl();

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.isSynchronizerUsageSupportedImpl();
    }

    private native boolean isSynchronizerUsageSupportedImpl();

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findDeadlockedThreadsImpl();
    }

    private native long[] findDeadlockedThreadsImpl();

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.dumpAllThreadsCommon(lockedMonitors, lockedSynchronizers, Integer.MAX_VALUE);
    }

    private ThreadInfo[] dumpAllThreadsCommon(boolean lockedMonitors, boolean lockedSynchronizers, int maxDepth) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        ThreadInfoBase[] threadInfoBaseArray = this.dumpAllThreadsImpl(lockedMonitors, lockedSynchronizers, maxDepth);
        return ThreadMXBeanImpl.makeThreadInfos(threadInfoBaseArray);
    }

    private native ThreadInfoBase[] dumpAllThreadsImpl(boolean var1, boolean var2, int var3);

    private native ThreadInfoBase[] getMultiThreadInfoImpl(long[] var1, int var2, boolean var3, boolean var4);

    public long[] getNativeThreadIds(long[] threadIDs) throws IllegalArgumentException, SecurityException {
        long[] localThreadIDs;
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long iter : localThreadIDs = (long[])threadIDs.clone()) {
            if (iter > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05FD", iter));
        }
        long[] nativeIDs = new long[threadIDs.length];
        this.getNativeThreadIdsImpl(localThreadIDs, nativeIDs);
        return nativeIDs;
    }

    public long getNativeThreadId(long threadId) throws IllegalArgumentException, SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (threadId <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FD", threadId));
        }
        return ThreadMXBeanImpl.findNativeThreadIDImpl(threadId);
    }

    private static native long findNativeThreadIDImpl(long var0);

    private native void getNativeThreadIdsImpl(long[] var1, long[] var2);

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.lang:type=Threading");
        }
        return this.objectName;
    }

    private static MethodHandle getThreadInfoConstructorHandle() {
        return AccessController.doPrivileged(new PrivilegedAction<MethodHandle>(){

            @Override
            public MethodHandle run() {
                MethodHandle myHandle;
                try {
                    Constructor threadInfoConstructor = ThreadInfo.class.getDeclaredConstructor(ThreadInfoBase.class);
                    threadInfoConstructor.setAccessible(true);
                    myHandle = MethodHandles.lookup().unreflectConstructor(threadInfoConstructor);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                    throw new RuntimeException(Msg.getString("K0617"), e);
                }
                return myHandle;
            }
        });
    }

    private static ThreadInfo makeThreadInfo(ThreadInfoBase base) {
        ThreadInfo newThreadInfo = null;
        if (null != base && null != threadInfoConstructorHandle) {
            try {
                newThreadInfo = threadInfoConstructorHandle.invoke(base);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException(Msg.getString("K0618"), e);
            }
        }
        return newThreadInfo;
    }

    static {
        IDCacheInitializer.init();
        instance = new ThreadMXBeanImpl();
        isThreadCpuTimeEnabled = null;
        isThreadCpuTimeSupported = null;
        threadInfoConstructorHandle = ThreadMXBeanImpl.getThreadInfoConstructorHandle();
    }
}

