/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaBuffer
implements AutoCloseable {
    private static final ByteOrder DeviceOrder = ByteOrder.LITTLE_ENDIAN;
    private final int deviceId;
    private final AtomicLong devicePtr;
    private final long length;
    private final CudaBuffer parent;

    private static native long allocate(int var0, long var1) throws CudaException;

    private static native ByteBuffer allocateDirectBuffer(long var0);

    private static int chunkBytes(long size) {
        return size <= Integer.MAX_VALUE ? (int)size : 0x7FFFFFF8;
    }

    private static native void copyFromDevice(int var0, long var1, int var3, long var4, long var6) throws CudaException;

    private static native void copyFromHostByte(int var0, long var1, byte[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostChar(int var0, long var1, char[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostDirect(int var0, long var1, Buffer var3, long var4, long var6) throws CudaException;

    private static native void copyFromHostDouble(int var0, long var1, double[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostFloat(int var0, long var1, float[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostInt(int var0, long var1, int[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostLong(int var0, long var1, long[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostShort(int var0, long var1, short[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostByte(int var0, long var1, byte[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostChar(int var0, long var1, char[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostDirect(int var0, long var1, Buffer var3, long var4, long var6) throws CudaException;

    private static native void copyToHostDouble(int var0, long var1, double[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostFloat(int var0, long var1, float[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostInt(int var0, long var1, int[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostLong(int var0, long var1, long[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostShort(int var0, long var1, short[] var3, int var4, int var5) throws CudaException;

    private static native void fill(int var0, long var1, int var3, int var4, long var5) throws CudaException;

    private static native void freeDirectBuffer(Buffer var0);

    private static void rangeCheck(long length, long fromIndex, long toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ')');
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex));
        }
        if (toIndex > length) {
            throw new IndexOutOfBoundsException(String.valueOf(toIndex));
        }
    }

    private static native void release(int var0, long var1) throws CudaException;

    private CudaBuffer(CudaBuffer parent, int deviceId, long devicePtr, long length) {
        this.deviceId = deviceId;
        this.devicePtr = new AtomicLong(devicePtr);
        this.length = length;
        this.parent = parent;
    }

    public CudaBuffer(CudaDevice device, long byteCount) throws CudaException {
        this.deviceId = device.getDeviceId();
        this.devicePtr = new AtomicLong(CudaBuffer.allocate(this.deviceId, byteCount));
        this.length = byteCount;
        this.parent = null;
    }

    public CudaBuffer atOffset(long fromOffset) {
        return this.slice(fromOffset, this.length);
    }

    @Override
    public void close() throws CudaException {
        long address = this.devicePtr.getAndSet(0L);
        if (address != 0L && this.parent == null) {
            CudaBuffer.release(this.deviceId, address);
        }
    }

    public void copyFrom(byte[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(byte[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 0);
        CudaBuffer.copyFromHostByte(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(ByteBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        int byteCount = toIndex - fromIndex;
        this.lengthCheck(byteCount, 0);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, fromIndex, toIndex);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            ByteBuffer tmp = CudaBuffer.allocateDirectBuffer(byteCount).order(DeviceOrder);
            try {
                tmp.put(source);
                CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), tmp, 0L, byteCount);
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(char[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(char[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 1);
        CudaBuffer.copyFromHostChar(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(CharBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 1);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 1, (long)toIndex << 1);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 1;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            CharBuffer slice = source.slice();
            CharBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asCharBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 1));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(CudaBuffer source, long fromOffset, long toOffset) throws CudaException {
        long byteCount = toOffset - fromOffset;
        CudaBuffer.rangeCheck(source.length, fromOffset, toOffset);
        this.lengthCheck(byteCount, 0);
        CudaBuffer.copyFromDevice(this.deviceId, this.getAddress(), source.deviceId, source.getAddress() + fromOffset, byteCount);
    }

    public void copyFrom(double[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(double[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 3);
        CudaBuffer.copyFromHostDouble(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(DoubleBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 3);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 3, (long)toIndex << 3);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 3;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            DoubleBuffer slice = source.slice();
            DoubleBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asDoubleBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 3));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(float[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(float[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 2);
        CudaBuffer.copyFromHostFloat(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(FloatBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 2);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 2, (long)toIndex << 2);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 2;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            FloatBuffer slice = source.slice();
            FloatBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asFloatBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 2));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(int[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(int[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 2);
        CudaBuffer.copyFromHostInt(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(IntBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 2);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 2, (long)toIndex << 2);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 2;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            IntBuffer slice = source.slice();
            IntBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asIntBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 2));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(long[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(long[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 3);
        CudaBuffer.copyFromHostLong(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(LongBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 3);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 3, (long)toIndex << 3);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 3;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            LongBuffer slice = source.slice();
            LongBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asLongBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 3));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyFrom(short[] array) throws CudaException {
        this.copyFrom(array, 0, array.length);
    }

    public void copyFrom(short[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 1);
        CudaBuffer.copyFromHostShort(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(ShortBuffer source) throws CudaException {
        int fromIndex = source.position();
        int toIndex = source.limit();
        this.lengthCheck(toIndex - fromIndex, 1);
        if (source.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), source, (long)fromIndex << 1, (long)toIndex << 1);
        } else if (source.hasArray()) {
            int offset = source.arrayOffset();
            this.copyFrom(source.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 1;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            ShortBuffer slice = source.slice();
            ShortBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asShortBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    long end = Math.min(start + (long)chunkSize, byteCount);
                    slice.limit((int)(end >> 1));
                    tmp.clear();
                    tmp.put(slice);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, end - start);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        source.position(toIndex);
    }

    public void copyTo(byte[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(byte[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 0);
        CudaBuffer.copyToHostByte(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ByteBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        int byteCount = toIndex - fromIndex;
        this.lengthCheck(byteCount, 0);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, fromIndex, toIndex);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            ByteBuffer tmp = CudaBuffer.allocateDirectBuffer(byteCount).order(DeviceOrder);
            try {
                CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), tmp, 0L, byteCount);
                target.put(tmp);
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(char[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(char[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 1);
        CudaBuffer.copyToHostChar(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(CharBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 1);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 1, (long)toIndex << 1);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 1;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            CharBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asCharBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 1);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(double[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(double[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 3);
        CudaBuffer.copyToHostDouble(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(DoubleBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 3);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 3, (long)toIndex << 3);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 3;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            DoubleBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asDoubleBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 3);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(float[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(float[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 2);
        CudaBuffer.copyToHostFloat(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(FloatBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 2);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 2, (long)toIndex << 2);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 2;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            FloatBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asFloatBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 2);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(int[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(int[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 2);
        CudaBuffer.copyToHostInt(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(IntBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 2);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 2, (long)toIndex << 2);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 2;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            IntBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asIntBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 2);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(long[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(long[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 3);
        CudaBuffer.copyToHostLong(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(LongBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 3);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 3, (long)toIndex << 3);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 3;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            LongBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asLongBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 3);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void copyTo(short[] array) throws CudaException {
        this.copyTo(array, 0, array.length);
    }

    public void copyTo(short[] array, int fromIndex, int toIndex) throws CudaException {
        CudaBuffer.rangeCheck(array.length, fromIndex, toIndex);
        this.lengthCheck(toIndex - fromIndex, 1);
        CudaBuffer.copyToHostShort(this.deviceId, this.getAddress(), array, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ShortBuffer target) throws CudaException {
        int fromIndex = target.position();
        int toIndex = target.limit();
        this.lengthCheck(toIndex - fromIndex, 1);
        if (target.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), target, (long)fromIndex << 1, (long)toIndex << 1);
        } else if (target.hasArray()) {
            int offset = target.arrayOffset();
            this.copyTo(target.array(), fromIndex + offset, toIndex + offset);
        } else {
            long byteCount = (long)(toIndex - fromIndex) << 1;
            int chunkSize = CudaBuffer.chunkBytes(byteCount);
            ShortBuffer tmp = CudaBuffer.allocateDirectBuffer(chunkSize).order(DeviceOrder).asShortBuffer();
            try {
                for (long start = 0L; start < byteCount; start += (long)chunkSize) {
                    int chunk = (int)Math.min(byteCount - start, (long)chunkSize);
                    tmp.position(0).limit(chunk >> 1);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + start, tmp, 0L, chunk);
                    target.put(tmp);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(tmp);
            }
        }
        target.position(toIndex);
    }

    public void fillByte(byte value, long count) throws CudaException {
        this.lengthCheck(count, 0);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 1, value, count);
    }

    public void fillChar(char value, long count) throws CudaException {
        this.lengthCheck(count, 1);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 2, value, count);
    }

    public void fillFloat(float value, long count) throws CudaException {
        this.fillInt(Float.floatToRawIntBits(value), count);
    }

    public void fillInt(int value, long count) throws CudaException {
        this.lengthCheck(count, 2);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 4, value, count);
    }

    public void fillShort(short value, long count) throws CudaException {
        this.lengthCheck(count, 1);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 2, value, count);
    }

    long getAddress() {
        long address = this.devicePtr.get();
        if (address != 0L) {
            if (this.parent == null || this.parent.devicePtr.get() != 0L) {
                return address;
            }
            this.devicePtr.set(0L);
        }
        throw new IllegalStateException();
    }

    public long getLength() {
        return this.length;
    }

    private void lengthCheck(long elementCount, int logUnitSize) {
        if (0L > elementCount || elementCount > this.length >> logUnitSize) {
            throw new IndexOutOfBoundsException(String.valueOf(elementCount));
        }
    }

    public CudaBuffer slice(long fromOffset, long toOffset) {
        if (fromOffset == 0L && toOffset == this.length) {
            return this;
        }
        CudaBuffer.rangeCheck(this.length, fromOffset, toOffset);
        return new CudaBuffer(this.parent != null ? this.parent : this, this.deviceId, this.getAddress() + fromOffset, toOffset - fromOffset);
    }
}

