/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECParameters;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKey
extends X509Key
implements java.security.interfaces.ECPublicKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962694L;
    private ECPoint w;
    private ECParameterSpec params;
    private static final String[] z;

    public ECPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.w = eCPoint;
        this.params = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        this.key = ECParameters.encodePoint(eCPoint, this.params.getCurve());
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                throw new InvalidKeyException(z[2]);
            }
            this.params = ECUtils.getPrimeParameterSpec(algorithmParameters.getParameterSpec(ECParameterSpec.class));
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1], iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[0], invalidParameterSpecException);
        }
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public void zeroize() {
        this.w = new ECPoint(BigInteger.ZERO, BigInteger.ZERO);
        this.params = null;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "'3cC\u0001\u000795g.N6p[";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 110;
                                break;
                            }
                            case 1: {
                                n9 = 93;
                                break;
                            }
                            case 2: {
                                n9 = 21;
                                break;
                            }
                            case 3: {
                                n9 = 34;
                                break;
                            }
                            default: {
                                n9 = 109;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "'3cC\u0001\u000795g.N6p[";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "+\u001e5F\u0002\u0003<|LM\u001e<gC\u0000\u000b)pP\u001eN0`Q\u0019N?p\u0002\b\u0000>zF\b\n}|LM\u001a5p\u0002\f\u0002:zP\u0004\u001a5x\u0002\u0004\n8{V\u0004\b4pP";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

