/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECPrivateKey;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static final String[] z;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey a(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            return new ECPrivateKey(byArray);
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
            BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
            return new ECPrivateKey(bigInteger, eCParameterSpec);
        }
        if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
            return new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
        }
        try {
            throw new InvalidKeySpecException(z[13]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey b(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey eCPrivateKey = new ECPrivateKey(byArray);
                return eCPrivateKey.getPublicKey();
            }
            if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
                ECPrivateKey eCPrivateKey = new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
                return eCPrivateKey.getPublicKey();
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T extends KeySpec> T a(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            Class<T> clazz2;
            if (key instanceof java.security.interfaces.ECPrivateKey) {
                clazz2 = Class.forName(z[11]);
                Class<T> clazz3 = Class.forName(z[7]);
                Class<T> clazz4 = Class.forName(z[5]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                }
                if (!clazz4.isAssignableFrom(clazz)) {
                    throw new InvalidKeySpecException(z[4]);
                }
                if (key instanceof ECPrivateKey) {
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(((ECPrivateKey)key).getEncoded(z[12]))));
                }
                try {
                    ECPrivateKey eCPrivateKey = new ECPrivateKey(key.getEncoded());
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(eCPrivateKey.getEncoded(z[2]))));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage());
                }
            }
            if (key instanceof java.security.interfaces.ECPublicKey) {
                clazz2 = Class.forName(z[8]);
                Class<T> clazz5 = Class.forName(z[9]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException(z[3]);
            }
            throw new InvalidKeySpecException(z[10]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[6] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key);
        }
        throw new FIPSRuntimeException();
    }

    protected Key a(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException(z[0]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "PN Y\u0018Pt5Q\u0018FL&D\u0013~E>\u0010\u001fF\u00002^\u0005@P7_\u0004AE#\u0010\u0010ZRgu5~E>v\u0017VT(B\u000f";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 53;
                                break;
                            }
                            case 1: {
                                n9 = 32;
                                break;
                            }
                            case 2: {
                                n9 = 71;
                                break;
                            }
                            case 3: {
                                n9 = 48;
                                break;
                            }
                            default: {
                                n9 = 118;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "`N4E\u0006EO5D\u0013Q\u0000,U\u000f\u0015S7U\u0015\\F.S\u0017AI(^";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "gf\u0004\u0005O\u0004\u0015";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "|N&@\u0006GO7B\u001fTT\"\u0010\u001dPYgC\u0006PC.V\u001fVA3Y\u0019[";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "|N&@\u0006GO7B\u001fTT\"\u0010\u001dPYgC\u0006PC.V\u001fVA3Y\u0019[";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\\B*\u001e\u0005PC2B\u001fAYiY\u0018AE5^\u0017Y\u000e4@\u0013V\u000e\u0015v5\u0000\u0019v\u00053vp5Y\u0000TT\"{\u0013Le)S\u0019QE#{\u0013Ls7U\u0015";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "`N4E\u0006EO5D\u0013Q\u0000,U\u000f\u0015S7U\u0015\\F.S\u0017AI(^L\u0015";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "_A1QXFE$E\u0004\\T>\u001e\u0005EE$\u001e&~c\u0014\b3[C(T\u0013Qk\"I%EE$";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "_A1QXFE$E\u0004\\T>\u001e\u0005EE$\u001e3vp2R\u001a\\C\fU\u000ffP\"S";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "_A1QXFE$E\u0004\\T>\u001e\u0005EE$\u001e.\u0000\u0010~u\u0018VO#U\u0012~E>c\u0006PC";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "|N&@\u0006GO7B\u001fTT\"\u0010\u001dPYgD\u000fEE";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "_A1QXFE$E\u0004\\T>\u001e\u0005EE$\u001e3vp5Y\u0000TT\"{\u0013Ls7U\u0015";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "gf\u0004\u0005O\u0004\u0015";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "`N4E\u0006EO5D\u0013Q\u0000,U\u000f\u0015S7U\u0015\\F.S\u0017AI(^";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

