/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertTemplate;
import com.ibm.security.crmf.RegistrationControl;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public final class CertRequest
extends CMPDerObject {
    private BigInteger certReqId;
    private CertTemplate certTemplate;
    private RegistrationControl[] controls;

    public CertRequest(BigInteger bigInteger, CertTemplate certTemplate, RegistrationControl[] registrationControlArray) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("CertRequest error, cert req id not specified");
        }
        if (certTemplate == null) {
            throw new IllegalArgumentException("CertRequest error, cert template not specified");
        }
        this.certReqId = bigInteger;
        this.certTemplate = certTemplate;
        this.controls = registrationControlArray;
    }

    public CertRequest(byte[] byArray) throws IOException {
        super(byArray);
    }

    public CertRequest addControl(RegistrationControl[] registrationControlArray) throws IOException {
        CertRequest certRequest = (CertRequest)this.clone();
        if (registrationControlArray == null) {
            return certRequest;
        }
        if (certRequest.controls == null) {
            certRequest.controls = registrationControlArray;
        } else {
            int n = certRequest.controls.length + registrationControlArray.length;
            RegistrationControl[] registrationControlArray2 = new RegistrationControl[n];
            int n2 = 0;
            while (n2 < certRequest.controls.length) {
                registrationControlArray2[n2] = certRequest.controls[n2];
                ++n2;
            }
            int n3 = n2;
            int n4 = 0;
            while (n3 < n) {
                registrationControlArray2[n3] = registrationControlArray[n4];
                ++n3;
                ++n4;
            }
            certRequest.controls = registrationControlArray2;
        }
        return certRequest;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new CertRequest(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        block8: {
            block7: {
                if (var1_1.getTag() != 48) {
                    throw new IOException("CertRequest parsing error, not a SEQUENCE");
                }
                this.certReqId = null;
                this.certTemplate = null;
                this.controls = null;
                if (var1_1.getData().available() == 0) {
                    throw new IOException("CertRequest parsing error, not encough data");
                }
                this.certReqId = var1_1.getData().getInteger();
                if (var1_1.getData().available() == 0) {
                    throw new IOException("CertRequest parsing error, missing data");
                }
                this.certTemplate = new CertTemplate(var1_1.getData().getDerValue().toByteArray());
                if (var1_1.getData().available() == 0) break block7;
                var2_2 = var1_1.getData().getDerValue();
                var3_3 = new Vector<RegistrationControl>();
                if (var2_2.getTag() == 48) ** GOTO lbl21
                throw new IOException("CertRequest parsing error");
lbl-1000:
                // 1 sources

                {
                    var4_4 = var2_2.getData().getDerValue();
                    var5_6 = new RegistrationControl(var4_4.toByteArray());
                    var3_3.add(var5_6);
lbl21:
                    // 2 sources

                    ** while (var2_2.getData().available() != 0)
                }
lbl22:
                // 1 sources

                if (var3_3.size() > 0) {
                    this.controls = new RegistrationControl[var3_3.size()];
                    var4_5 = 0;
                    while (var4_5 < var3_3.size()) {
                        this.controls[var4_5] = (RegistrationControl)var3_3.elementAt(var4_5);
                        ++var4_5;
                    }
                }
                break block8;
            }
            this.controls = null;
        }
        if (var1_1.getData().available() != 0) {
            throw new IOException("CertRequest parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certReqId == null) {
            throw new IOException("CertRequest encoding error, certReqId not specified");
        }
        derOutputStream.putInteger(this.certReqId);
        if (this.certTemplate == null) {
            throw new IOException("CertRequest encoding error, cert template not specified");
        }
        this.certTemplate.encode((OutputStream)derOutputStream);
        if (this.controls != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            int n = 0;
            while (n < this.controls.length) {
                this.controls[n].encode((OutputStream)derOutputStream3);
                ++n;
            }
            derOutputStream.write((byte)48, derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertRequest certRequest) {
        DerValue derValue;
        DerValue derValue2;
        if (certRequest == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certRequest.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertRequest) {
            return this.equals((CertRequest)object);
        }
        return false;
    }

    public BigInteger getCertReqId() {
        return this.certReqId;
    }

    public CertTemplate getCertTemplate() {
        return (CertTemplate)this.certTemplate.clone();
    }

    public RegistrationControl[] getControls() {
        if (this.controls == null) {
            return null;
        }
        return (RegistrationControl[])this.controls.clone();
    }

    public String toString() {
        String string = "CertRequest:";
        string = String.valueOf(string) + "\r\n\tcert request id " + this.certReqId.toString();
        string = String.valueOf(string) + "\r\n\tcert template " + this.certTemplate.toString();
        string = this.controls == null ? String.valueOf(string) + "\r\n\tno controls" : String.valueOf(string) + "\r\n\rcontrols: " + this.controls.toString();
        return string;
    }
}

