/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CRMF;
import com.ibm.security.crmf.CertRequest;
import com.ibm.security.crmf.RegInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class CertReqRegInfo
extends CMPDerObject
implements RegInfo,
Cloneable {
    private static final ObjectIdentifier oid = CRMF.id_regInfo_certReq_oid;
    private CertRequest value;
    private byte[] encodedValue;

    public CertReqRegInfo(CertRequest certRequest) throws IOException {
        if (certRequest == null) {
            throw new IllegalArgumentException("CertReqRegInfo error, certReq not specified");
        }
        this.value = certRequest;
        this.setEncodedValue();
    }

    public CertReqRegInfo(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new CertReqRegInfo(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2 == null) {
            throw new IOException("CertReqRegInfo parsing erro, missing data");
        }
        this.value = new CertRequest(derValue2.toByteArray());
        if (derValue.getData().available() != 0) {
            throw new IOException("CertReqRegInfo parsing error, data overrun");
        }
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(CertReqRegInfo certReqRegInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (certReqRegInfo == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certReqRegInfo.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertReqRegInfo) {
            return this.equals((CertReqRegInfo)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "CertReq";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        return this.value.clone();
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode((OutputStream)derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "CertReqRegInfo:";
        string = String.valueOf(string) + "\r\nvalue: ";
        string = String.valueOf(string) + this.value.toString();
        return string;
    }
}

