/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.BatchEnvironment;
import com.ibm.tools.rmic.iiop.CompoundType;
import com.ibm.tools.rmic.iiop.Constants;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.EscapedUnicodeFilterWriter;
import com.ibm.tools.rmic.iiop.IDLNames;
import com.ibm.tools.rmic.iiop.Type;
import com.ibm.tools.rmic.iiop.Util;
import com.ibm.tools.rmic.iiop.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.Identifier;

public abstract class Generator
implements sun.rmi.rmic.Generator,
Constants {
    private static boolean alwaysGenerate = false;
    private static boolean trace = false;
    protected BatchEnvironment env = null;
    protected ContextStack contextStack = null;

    @Override
    public boolean parseArgs(String[] stringArray, Main main) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].equalsIgnoreCase("-always") || stringArray[i].equalsIgnoreCase("-alwaysGenerate")) {
                alwaysGenerate = true;
                stringArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-xtrace")) {
                trace = true;
                stringArray[i] = null;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-version")) continue;
            main.error("rmic.iiop.version", Version.getBuildLevel());
            stringArray[i] = null;
        }
        return true;
    }

    protected abstract boolean parseNonConforming(ContextStack var1);

    protected abstract CompoundType getTopType(ClassDefinition var1, ContextStack var2);

    protected abstract OutputType[] getOutputTypesFor(CompoundType var1, HashSet var2);

    protected abstract String getFileNameExtensionFor(OutputType var1);

    protected abstract void writeOutputFor(OutputType var1, HashSet var2, IndentingWriter var3, boolean var4) throws IOException;

    protected abstract boolean requireNewInstance();

    protected abstract void checkParents(Type var1);

    public boolean requiresGeneration(File file, Type type) {
        boolean bl = alwaysGenerate;
        if (!bl) {
            String string = type.getQualifiedName().replace('.', File.separatorChar);
            ClassFile classFile = this.env.tryToGetClassPath().getFile(string + ".java");
            if (classFile == null) {
                classFile = this.env.tryToGetClassPath().getFile(string + ".class");
            }
            if (classFile != null) {
                long l;
                long l2 = classFile.lastModified();
                String string2 = IDLNames.replace(file.getName(), ".java", ".class");
                String string3 = file.getParent();
                File file2 = new File(string3, string2);
                bl = file2.exists() ? (l = file2.lastModified()) < l2 : true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    protected Generator newInstance() {
        Generator generator = null;
        try {
            generator = (Generator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generator;
    }

    protected Generator() {
    }

    @Override
    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        this.env = (BatchEnvironment)batchEnvironment;
        this.contextStack = new ContextStack(this.env);
        this.contextStack.setTrace(trace);
        this.env.setParseNonConforming(this.parseNonConforming(this.contextStack));
        CompoundType compoundType = this.getTopType(classDefinition, this.contextStack);
        if (compoundType != null) {
            Generator generator = this;
            if (this.requireNewInstance()) {
                generator = this.newInstance();
            }
            generator.generateOutputFiles(compoundType, this.env, file);
        }
    }

    protected void generateOutputFiles(CompoundType compoundType, BatchEnvironment batchEnvironment, File file) {
        int n;
        HashSet hashSet = batchEnvironment.alreadyChecked;
        OutputType[] outputTypeArray = this.getOutputTypesFor(compoundType, hashSet);
        for (n = 0; n < outputTypeArray.length; ++n) {
            this.checkParents(outputTypeArray[n].getType());
        }
        for (n = 0; n < outputTypeArray.length; ++n) {
            OutputType outputType = outputTypeArray[n];
            File file2 = this.getFileFor(outputType, file, false);
            if (file2 == null) continue;
            boolean bl = false;
            if (this.requiresGeneration(file2, outputType.getType())) {
                if (file2.getName().endsWith(".java") && (bl = this.compileJavaSourceFile(outputType))) {
                    batchEnvironment.addGeneratedFile(file2);
                }
                try {
                    this.writeToFile(file2, outputTypeArray[n], batchEnvironment, hashSet, bl, false);
                    if (!this.isBoxedIDL(outputTypeArray[n]) || this.isPrimitive(outputTypeArray[n]) || this.isBoxedRMI(outputTypeArray[n]) || (file2 = this.getFileFor(outputTypeArray[n], file, true)) == null) continue;
                    Identifier identifier = this.getOutputId(outputTypeArray[n]);
                    outputTypeArray[n].getType().forceSetIDLNames(Util.getNonBoxedPackageNames(identifier), Util.getNonBoxedClassName(identifier));
                    this.writeToFile(file2, outputTypeArray[n], batchEnvironment, hashSet, bl, true);
                    continue;
                }
                catch (IOException iOException) {
                    batchEnvironment.error(0L, "cant.write", file2.toString());
                    return;
                }
            }
            if (!batchEnvironment.verbose()) continue;
            batchEnvironment.output(Main.getText("rmic.previously.generated", file2.getPath()));
        }
    }

    private void writeToFile(File file, OutputType outputType, BatchEnvironment batchEnvironment, HashSet hashSet, boolean bl, boolean bl2) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
        IndentingWriter indentingWriter = new IndentingWriter(new EscapedUnicodeFilterWriter(outputStreamWriter), 4, Integer.MAX_VALUE);
        long l = 0L;
        if (batchEnvironment.verbose()) {
            l = System.currentTimeMillis();
        }
        this.writeOutputFor(outputType, hashSet, indentingWriter, bl2);
        indentingWriter.close();
        if (batchEnvironment.verbose()) {
            long l2 = System.currentTimeMillis() - l;
            batchEnvironment.output(Main.getText("rmic.generated", file.getPath(), Long.toString(l2)));
        }
        if (bl) {
            batchEnvironment.parseFile(new ClassFile(file));
        }
    }

    protected File getFileFor(OutputType outputType, File file, boolean bl) {
        Identifier identifier = this.getOutputId(outputType);
        File file2 = Util.getOutputDirectoryFor(identifier, file, this.env, outputType.getName().endsWith("_Stub") && outputType.getType().relocateStubs, bl);
        if (file2 == null) {
            return null;
        }
        String string = outputType.getName() + this.getFileNameExtensionFor(outputType);
        return new File(file2, string);
    }

    protected Identifier getOutputId(OutputType outputType) {
        return outputType.getType().getIdentifier();
    }

    protected boolean compileJavaSourceFile(OutputType outputType) {
        return true;
    }

    private boolean isBoxedIDL(OutputType outputType) {
        Type type = outputType.getType();
        String string = type.getQualifiedIDLName(false);
        return string.indexOf("boxedIDL") > 0;
    }

    private boolean isBoxedRMI(OutputType outputType) {
        Type type = outputType.getType();
        String string = type.getQualifiedIDLName(false);
        return string.indexOf("boxedRMI") > 0;
    }

    private boolean isPrimitive(OutputType outputType) {
        Type type = outputType.getType();
        return type.isPrimitive();
    }

    public class OutputType {
        private String name;
        private Type type;

        public OutputType(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

