/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.CompoundType;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.IDLNames;
import com.ibm.tools.rmic.iiop.Type;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Vector;

public class ArrayType
extends Type {
    private Type type;
    private int arrayDimension;
    private String brackets;
    private String bracketsSig;

    public static ArrayType forArray(sun.tools.java.Type type, ContextStack contextStack) {
        ArrayType arrayType = null;
        sun.tools.java.Type type2 = type;
        if (type2.getTypeCode() == 9) {
            while (type2.getTypeCode() == 9) {
                type2 = type2.getElementType();
            }
            Type type3 = ArrayType.getType(type, contextStack);
            if (type3 != null) {
                if (!(type3 instanceof ArrayType)) {
                    return null;
                }
                return (ArrayType)type3;
            }
            Type type4 = CompoundType.makeType(type2, null, contextStack);
            if (type4 != null) {
                arrayType = new ArrayType(contextStack, type4, type.getArrayDimension());
                ArrayType.putType(type, (Type)arrayType, contextStack);
                contextStack.push(arrayType);
                contextStack.pop(true);
            }
        }
        return arrayType;
    }

    @Override
    public String getSignature() {
        return this.bracketsSig + this.type.getSignature();
    }

    @Override
    public Type getElementType() {
        return this.type;
    }

    @Override
    public int getArrayDimension() {
        return this.arrayDimension;
    }

    @Override
    public String getArrayBrackets() {
        return this.brackets;
    }

    @Override
    public String toString() {
        return this.getQualifiedName() + this.brackets;
    }

    @Override
    public String getTypeDescription() {
        return "Array of " + this.type.getTypeDescription();
    }

    @Override
    public String getTypeName(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return super.getTypeName(bl, bl2, bl3);
        }
        return super.getTypeName(bl, bl2, bl3) + this.brackets;
    }

    @Override
    protected void swapInvalidTypes() {
        if (this.type.getStatus() != 1) {
            this.type = this.getValidType(this.type);
        }
    }

    @Override
    protected boolean addTypes(int n, HashSet hashSet, Vector vector) {
        boolean bl = super.addTypes(n, hashSet, vector);
        if (bl) {
            this.getElementType().addTypes(n, hashSet, vector);
        }
        return bl;
    }

    private ArrayType(ContextStack contextStack, Type type, int n) {
        super(contextStack, 262144);
        this.type = type;
        this.arrayDimension = n;
        this.brackets = "";
        this.bracketsSig = "";
        for (int i = 0; i < n; ++i) {
            this.brackets = this.brackets + "[]";
            this.bracketsSig = this.bracketsSig + "[";
        }
        String string = IDLNames.getArrayName(type, n);
        String[] stringArray = IDLNames.getArrayModuleNames(type);
        this.setNames(type.getIdentifier(), stringArray, string);
        this.setRepositoryID();
    }

    @Override
    protected Class loadClass() {
        Class<?> clazz = null;
        Class clazz2 = this.type.getClassInstance();
        if (clazz2 != null) {
            clazz = Array.newInstance(clazz2, new int[this.arrayDimension]).getClass();
        }
        return clazz;
    }

    @Override
    protected void destroy() {
        super.destroy();
        if (this.type != null) {
            this.type.destroy();
            this.type = null;
        }
        this.brackets = null;
        this.bracketsSig = null;
    }
}

