/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.Arguments;
import com.ibm.idl.toJavaPortable.AuxGen;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.JavaGenerator;
import com.ibm.idl.toJavaPortable.MethodGen;
import com.ibm.idl.toJavaPortable.TCOffsets;
import com.ibm.idl.toJavaPortable.Util;
import java.util.Hashtable;
import java.util.Vector;

public class Helper
implements AuxGen {
    protected Hashtable symbolTable;
    protected SymtabEntry entry;
    protected GenFileStream stream;
    protected String helperClass;
    protected String helperType;

    @Override
    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        if ((((Arguments)Compile.compiler.arguments).suppress & 1) != 0) {
            return;
        }
        this.symbolTable = hashtable;
        this.entry = symtabEntry;
        if (symtabEntry.typeName().equals("native")) {
            return;
        }
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.helperClass = this.entry.name() + "Helper";
        if (this.entry instanceof ValueBoxEntry) {
            ValueBoxEntry valueBoxEntry = (ValueBoxEntry)this.entry;
            TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
            SymtabEntry symtabEntry = typedefEntry.type();
            this.helperType = symtabEntry instanceof PrimitiveEntry ? Util.javaName(this.entry) : Util.javaName(symtabEntry);
        } else {
            this.helperType = Util.javaName(this.entry);
        }
    }

    protected void openStream() {
        this.stream = Util.stream(this.entry, "Helper.java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.entry, (short)2);
        Util.writeProlog(this.stream, this.stream.name());
        if (this.entry.comment() != null) {
            this.entry.comment().generate("", this.stream);
        }
        if (this.entry instanceof ValueBoxEntry) {
            this.stream.print("public final class " + this.helperClass);
            this.stream.println(" implements org.omg.CORBA.portable.BoxedValueHelper");
        } else {
            this.stream.println("abstract public class " + this.helperClass);
        }
        this.stream.println('{');
    }

    protected void writeBody() {
        this.writeInstVars();
        this.writeCtors();
        this.writeInsert();
        this.writeExtract();
        this.writeType();
        this.writeID();
        this.writeRead();
        this.writeWrite();
        if (this.entry instanceof InterfaceEntry && !(this.entry instanceof ValueEntry)) {
            this.writeNarrow(true);
            this.writeNarrow(false);
        }
        this.writeHelperInterface();
        if (this.entry instanceof ValueEntry) {
            this.writeValueHelperInterface();
        }
    }

    protected void writeHelperInterface() {
    }

    protected void writeValueHelperInterface() {
        if (this.entry instanceof ValueBoxEntry) {
            this.writeGetID();
        } else if (this.entry instanceof ValueEntry) {
            this.writeHelperFactories();
        }
    }

    protected void writeClosing() {
        this.stream.println('}');
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeInstVars() {
        this.stream.println("  private static String  _id = \"" + Util.stripLeadingUnderscoresFromID(this.entry.repositoryID().ID()) + "\";");
        if (this.entry instanceof ValueEntry) {
            this.stream.println();
            if (this.entry instanceof ValueBoxEntry) {
                this.stream.println("  private static " + this.helperClass + " _instance = new " + this.helperClass + " ();");
                this.stream.println();
            }
        }
        this.stream.println();
    }

    protected void writeCtors() {
        if (this.entry instanceof ValueBoxEntry) {
            this.stream.println("  public " + this.helperClass + "()");
            this.stream.println("  {");
            this.stream.println("  }");
            this.stream.println();
        }
    }

    protected void writeInsert() {
        this.stream.println("  public static void insert (org.omg.CORBA.Any a, " + this.helperType + " that)");
        this.stream.println("  {");
        if (this.entry.isLocalOnly()) {
            this.stream.println("    throw new org.omg.CORBA.MARSHAL(2,org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
        } else {
            this.stream.println("    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();");
            this.stream.println("    a.type (type ());");
            this.stream.println("    write (out, that);");
            this.stream.println("    a.read_value (out.create_input_stream (), type ());");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeExtract() {
        this.stream.println("  public static " + this.helperType + " extract (org.omg.CORBA.Any a)");
        this.stream.println("  {");
        if (this.entry.isLocalOnly()) {
            this.stream.println("    throw new org.omg.CORBA.MARSHAL(2,org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
        } else {
            this.stream.println("    if (!a.type().equal(type()))");
            this.stream.println("        throw new org.omg.CORBA.BAD_OPERATION(\"extract() failed.Expected a " + this.helperType + " .\");");
            this.stream.println("    return read (a.create_input_stream ());");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeType() {
        boolean bl = this.entry instanceof ValueEntry || this.entry instanceof ValueBoxEntry || this.entry instanceof StructEntry;
        this.stream.println("  private static volatile org.omg.CORBA.TypeCode __typeCode = null;");
        if (bl) {
            this.stream.println("  private static boolean __active = false;");
        }
        this.stream.println("  public static org.omg.CORBA.TypeCode type ()");
        this.stream.println("  {");
        this.stream.println("  org.omg.CORBA.TypeCode __localTc = __typeCode;");
        this.stream.println("    if (__localTc == null)");
        this.stream.println("    {");
        if (bl) {
            this.stream.println("      synchronized (org.omg.CORBA.TypeCode.class)");
            this.stream.println("      {");
            this.stream.println("        __localTc = __typeCode;");
            this.stream.println("        if (__localTc == null)");
            this.stream.println("        {");
            this.stream.println("          if (__active)");
            this.stream.println("          {");
            this.stream.println("            return org.omg.CORBA.ORB.init().create_recursive_tc ( _id );");
            this.stream.println("          }");
            this.stream.println("          __active = true;");
            ((JavaGenerator)((Object)this.entry.generator())).helperType(0, "          ", new TCOffsets(), "__localTc", this.entry, this.stream);
            this.stream.println("          __active = false;");
            this.stream.println("          __typeCode = __localTc;");
            this.stream.println("        }");
            this.stream.println("      }");
        } else {
            ((JavaGenerator)((Object)this.entry.generator())).helperType(0, "      ", new TCOffsets(), "__localTc", this.entry, this.stream);
            this.stream.println("      __typeCode = __localTc;");
        }
        this.stream.println("    }");
        this.stream.println("    return __localTc;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeID() {
        this.stream.println("  public static String id ()");
        this.stream.println("  {");
        this.stream.println("    return _id;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeRead() {
        this.stream.println("  public static " + this.helperType + " read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        if (this.entry.isLocalOnly()) {
            this.stream.println("     throw new org.omg.CORBA.MARSHAL(2,org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
        } else {
            ((JavaGenerator)((Object)this.entry.generator())).helperRead(this.helperType, this.entry, this.stream);
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeWrite() {
        this.stream.println("  public static void write (org.omg.CORBA.portable.OutputStream ostream, " + this.helperType + " value)");
        this.stream.println("  {");
        if (this.entry.isLocalOnly()) {
            this.stream.println("     throw new org.omg.CORBA.MARSHAL(2,org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
        } else {
            ((JavaGenerator)((Object)this.entry.generator())).helperWrite(this.entry, this.stream);
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeNarrow(boolean bl) {
        this.writeRemoteNarrow(bl);
        this.stream.println();
    }

    protected void writeRemoteNarrow(boolean bl) {
        InterfaceEntry interfaceEntry = (InterfaceEntry)this.entry;
        if (interfaceEntry.isAbstract()) {
            this.writeRemoteNarrowForAbstract(false, bl);
            return;
        }
        if (interfaceEntry.isLocalOnly()) {
            this.writeLocalNarrow(bl);
            return;
        }
        for (int i = 0; i < interfaceEntry.derivedFrom().size(); ++i) {
            SymtabEntry symtabEntry = (SymtabEntry)interfaceEntry.derivedFrom().elementAt(i);
            if (!((InterfaceEntry)symtabEntry).isAbstract()) continue;
            this.writeRemoteNarrowForAbstract(true, bl);
            break;
        }
        if (bl) {
            this.stream.println("  public static " + this.helperType + " narrow (org.omg.CORBA.Object obj)");
        } else {
            this.stream.println("  public static " + this.helperType + " unchecked_narrow (org.omg.CORBA.Object obj)");
        }
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        this.stream.println("    else if (obj instanceof " + this.helperType + ')');
        this.stream.println("      return (" + this.helperType + ")obj;");
        if (bl) {
            this.stream.println("    else if (!obj._is_a (id ()))");
            this.stream.println("      throw new org.omg.CORBA.BAD_PARAM ();");
        }
        this.stream.println("    else");
        this.stream.println("    {");
        this.stream.println("      org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate ();");
        this.stream.println("      return new " + this.stubName((InterfaceEntry)this.entry) + " (delegate);");
        this.stream.println("    }");
        this.stream.println("  }");
    }

    private void writeRemoteNarrowForAbstract(boolean bl, boolean bl2) {
        if (bl2) {
            this.stream.print("  public static " + this.helperType + " narrow (java.lang.Object obj)");
        } else {
            this.stream.print("  public static " + this.helperType + " unchecked_narrow (java.lang.Object obj)");
        }
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        if (bl) {
            this.stream.println("    else if (obj instanceof org.omg.CORBA.Object)");
            this.stream.println("      return narrow ((org.omg.CORBA.Object) obj);");
        } else {
            this.stream.println("    else if (obj instanceof " + this.helperType + ')');
            this.stream.println("      return (" + this.helperType + ")obj;");
        }
        if (!bl) {
            if (bl2) {
                this.stream.println("    else if ((obj instanceof org.omg.CORBA.portable.ObjectImpl) &&");
                this.stream.println("             (((org.omg.CORBA.Object)obj)._is_a (id ())))");
            } else {
                this.stream.println("    else if (obj instanceof org.omg.CORBA.portable.ObjectImpl)");
            }
            this.stream.print("      return new " + this.stubName((InterfaceEntry)this.entry));
            this.stream.println(" (((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ());");
        }
        this.stream.println("    throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
    }

    private void writeLocalNarrow(boolean bl) {
        if (bl) {
            this.stream.print("  public static " + this.helperType + " narrow (org.omg.CORBA.Object obj)");
        } else {
            this.stream.print("  public static " + this.helperType + " unchecked_narrow (org.omg.CORBA.Object obj)");
        }
        this.stream.println("  {");
        this.stream.println("     if (obj == null)");
        this.stream.println("        return null;");
        this.stream.println("     else if (obj instanceof " + this.helperType + ")");
        this.stream.println("        return (" + this.helperType + ")obj;");
        this.stream.println("     else");
        this.stream.println("        throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetID() {
        if (!Util.IDLEntity(this.entry)) {
            return;
        }
        this.stream.println("  public String get_id ()");
        this.stream.println("  {");
        this.stream.println("    return _id;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetType() {
        if (!Util.IDLEntity(this.entry)) {
            return;
        }
        this.stream.println("  public org.omg.CORBA.TypeCode get_type ()");
        this.stream.println("  {");
        this.stream.println("    return type ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetClass() {
        this.stream.println("  public Class get_class ()");
        this.stream.println("  {");
        this.stream.println("    return " + this.helperType + ".class;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetInstance() {
        this.stream.println("  public static org.omg.CORBA.portable.ValueHelper get_instance ()");
        this.stream.println("  {");
        this.stream.println("    return helper;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetSafeBaseIds() {
        this.stream.println("  public String[] get_truncatable_base_ids ()");
        this.stream.println("  {");
        this.stream.println("    return _truncatable_ids;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected String stubName(InterfaceEntry interfaceEntry) {
        String string = interfaceEntry.container().name().equals("") ? '_' + interfaceEntry.name() + "Stub" : Util.containerFullName(interfaceEntry.container()) + "._" + interfaceEntry.name() + "Stub";
        return string.replace('/', '.');
    }

    protected void writeHelperFactories() {
        Vector vector = ((ValueEntry)this.entry).initializers();
        if (vector != null) {
            this.stream.println();
            for (int i = 0; i < vector.size(); ++i) {
                MethodEntry methodEntry = (MethodEntry)vector.elementAt(i);
                methodEntry.valueMethod(true);
                ((MethodGen)methodEntry.generator()).helperFactoryMethod(this.symbolTable, methodEntry, this.entry, this.stream);
            }
        }
    }
}

