/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.Comment;
import com.ibm.idl.Util;

class Token {
    static final int Any = 0;
    static final int Attribute = 1;
    static final int Boolean = 2;
    static final int Case = 3;
    static final int Char = 4;
    static final int Const = 5;
    static final int Context = 6;
    static final int Default = 7;
    static final int Double = 8;
    static final int Enum = 9;
    static final int Exception = 10;
    static final int FALSE = 11;
    static final int Float = 12;
    static final int In = 13;
    static final int Inout = 14;
    static final int Interface = 15;
    static final int Long = 16;
    static final int Module = 17;
    static final int Object = 18;
    static final int Octet = 19;
    static final int Oneway = 20;
    static final int Out = 21;
    static final int Raises = 22;
    static final int Readonly = 23;
    static final int Sequence = 24;
    static final int Short = 25;
    static final int String = 26;
    static final int Struct = 27;
    static final int Switch = 28;
    static final int TRUE = 29;
    static final int Typedef = 30;
    static final int Unsigned = 31;
    static final int Union = 32;
    static final int Void = 33;
    static final int Wchar = 34;
    static final int Wstring = 35;
    static final int Abstract = 36;
    static final int Custom = 37;
    static final int Private = 38;
    static final int Public = 39;
    static final int Supports = 40;
    static final int Truncatable = 41;
    static final int ValueBase = 42;
    static final int Valuetype = 43;
    static final int Factory = 44;
    static final int LongDouble = 45;
    static final int Native = 46;
    static final int Fixed = 47;
    static final int Local = 48;
    static final int Identifier = 60;
    static final int MacroIdentifier = 61;
    static final int Semicolon = 100;
    static final int LeftBrace = 101;
    static final int RightBrace = 102;
    static final int Colon = 103;
    static final int Comma = 104;
    static final int Equal = 105;
    static final int Plus = 106;
    static final int Minus = 107;
    static final int LeftParen = 108;
    static final int RightParen = 109;
    static final int LessThan = 110;
    static final int GreaterThan = 111;
    static final int LeftBracket = 112;
    static final int RightBracket = 113;
    static final int Apostrophe = 114;
    static final int Quote = 115;
    static final int Backslash = 116;
    static final int Bar = 117;
    static final int Carat = 118;
    static final int Ampersand = 119;
    static final int Star = 120;
    static final int Slash = 121;
    static final int Percent = 122;
    static final int Tilde = 123;
    static final int DoubleColon = 124;
    static final int ShiftLeft = 125;
    static final int ShiftRight = 126;
    static final int Period = 127;
    static final int Hash = 128;
    static final int Exclamation = 129;
    static final int DoubleEqual = 130;
    static final int NotEqual = 131;
    static final int GreaterEqual = 132;
    static final int LessEqual = 133;
    static final int DoubleBar = 134;
    static final int DoubleAmpersand = 135;
    static final int BooleanLiteral = 200;
    static final int CharacterLiteral = 201;
    static final int IntegerLiteral = 202;
    static final int FloatingPointLiteral = 203;
    static final int StringLiteral = 204;
    static final int Literal = 205;
    static final int WideCharacterLiteral = 206;
    static final int WideStringLiteral = 207;
    static final int Define = 300;
    static final int Undef = 301;
    static final int If = 302;
    static final int Ifdef = 303;
    static final int Ifndef = 304;
    static final int Else = 305;
    static final int Elif = 306;
    static final int Include = 307;
    static final int Endif = 308;
    static final int Line = 309;
    static final int Error = 310;
    static final int Pragma = 311;
    static final int Null = 312;
    static final int Unknown = 313;
    static final int Defined = 400;
    static final int EOF = 999;
    static final String[] Keywords = new String[]{"any", "attribute", "boolean", "case", "char", "const", "context", "default", "double", "enum", "exception", "FALSE", "float", "in", "inout", "interface", "long", "module", "Object", "octet", "oneway", "out", "raises", "readonly", "sequence", "short", "string", "struct", "switch", "TRUE", "typedef", "unsigned", "union", "void", "wchar", "wstring", "abstract", "custom", "private", "public", "supports", "truncatable", "ValueBase", "valuetype", "factory", "long double", "native", "fixed", "local"};
    static final int FirstKeyword = 0;
    static final int LastKeyword = 48;
    static final int First22Keyword = 0;
    static final int Last22Keyword = 35;
    static final int First23Keyword = 36;
    static final int Last23Keyword = 47;
    static final int First24Keyword = 48;
    static final int Last24Keyword = 48;
    static final int FirstSymbol = 100;
    static final int LastSymbol = 199;
    static final String[] Symbols = new String[]{";", "{", "}", ":", ",", "=", "+", "-", "(", ")", "<", ">", "[", "]", "'", "\"", "\\", "|", "^", "&", "*", "/", "%", "~", "::", "<<", ">>", ".", "#", "!", "==", "!=", ">=", "<=", "||", "&&"};
    static final int FirstLiteral = 200;
    static final int LastLiteral = 299;
    static final String[] Literals = new String[]{Util.getMessage("Token.boolLit"), Util.getMessage("Token.charLit"), Util.getMessage("Token.intLit"), Util.getMessage("Token.floatLit"), Util.getMessage("Token.stringLit"), Util.getMessage("Token.literal")};
    static final int FirstDirective = 300;
    static final int LastDirective = 399;
    static final String[] Directives = new String[]{"define", "undef", "if", "ifdef", "ifndef", "else", "elif", "include", "endif", "line", "error", "pragma", ""};
    static final int FirstSpecial = 400;
    static final int LastSpecial = 499;
    static final String[] Special = new String[]{"defined"};
    int type;
    String name = null;
    Comment comment = null;
    boolean isEscaped = false;
    boolean collidesWithKeyword = false;
    boolean isDeprecated = false;
    int lineNumber = 0;

    boolean isKeyword() {
        return this.type >= 0 && this.type <= 48;
    }

    boolean isDirective() {
        return this.type >= 300 && this.type <= 399;
    }

    Token(int n) {
        this.type = n;
        if (n < 60) {
            this.name = Keywords[this.type];
        }
    }

    Token(int n, boolean bl) {
        this(n);
        this.isDeprecated = bl;
    }

    Token(int n, String string) {
        this(n);
        this.name = string;
    }

    Token(int n, String string, boolean bl) {
        this(n, string);
        this.isEscaped = bl;
    }

    Token(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        this(n, string);
        this.isEscaped = bl;
        this.collidesWithKeyword = bl2;
        this.isDeprecated = bl3;
    }

    public String toString() {
        if (this.type == 60) {
            return this.name;
        }
        if (this.type == 61) {
            return this.name + '(';
        }
        return Token.toString(this.type);
    }

    static String toString(int n) {
        if (n <= 48) {
            return Keywords[n];
        }
        if (n == 60 || n == 61) {
            return Util.getMessage("Token.identifier");
        }
        if (n <= 199) {
            return Symbols[n - 100];
        }
        if (n <= 299) {
            return Literals[n - 200];
        }
        if (n <= 399) {
            return Directives[n - 300];
        }
        if (n <= 499) {
            return Special[n - 400];
        }
        if (n == 999) {
            return Util.getMessage("Token.endOfFile");
        }
        return Util.getMessage("Token.unknown");
    }

    boolean equals(Token token) {
        if (this.type == token.type) {
            if (this.name == null) {
                return token.name == null;
            }
            return this.name.equals(token.name);
        }
        return false;
    }

    boolean equals(int n) {
        return this.type == n;
    }

    boolean equals(String string) {
        return this.type == 60 && this.name.equals(string);
    }

    public boolean isEscaped() {
        return this.type == 60 && this.isEscaped;
    }

    public boolean collidesWithKeyword() {
        return this.collidesWithKeyword;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

