/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.Arguments;
import com.ibm.idl.AttributeEntry;
import com.ibm.idl.AttributeGen;
import com.ibm.idl.ConstEntry;
import com.ibm.idl.ConstGen;
import com.ibm.idl.DefaultSymtabFactory;
import com.ibm.idl.DirectiveEntry;
import com.ibm.idl.DirectiveGen;
import com.ibm.idl.EnumEntry;
import com.ibm.idl.EnumGen;
import com.ibm.idl.ExceptionEntry;
import com.ibm.idl.ExceptionGen;
import com.ibm.idl.Factories;
import com.ibm.idl.ForwardEntry;
import com.ibm.idl.ForwardGen;
import com.ibm.idl.ForwardValueEntry;
import com.ibm.idl.ForwardValueGen;
import com.ibm.idl.GenFactory;
import com.ibm.idl.IncludeEntry;
import com.ibm.idl.IncludeGen;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.InterfaceGen;
import com.ibm.idl.InvalidArgument;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.MethodGen;
import com.ibm.idl.ModuleEntry;
import com.ibm.idl.ModuleGen;
import com.ibm.idl.NoPragma;
import com.ibm.idl.Noop;
import com.ibm.idl.ParameterEntry;
import com.ibm.idl.ParameterGen;
import com.ibm.idl.ParseException;
import com.ibm.idl.Parser;
import com.ibm.idl.PragmaEntry;
import com.ibm.idl.PragmaGen;
import com.ibm.idl.PragmaHandler;
import com.ibm.idl.Preprocessor;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.PrimitiveGen;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.SequenceGen;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StringGen;
import com.ibm.idl.StructEntry;
import com.ibm.idl.StructGen;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.SymtabFactory;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.TypedefGen;
import com.ibm.idl.UnionEntry;
import com.ibm.idl.UnionGen;
import com.ibm.idl.Util;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueBoxGen;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.ValueGen;
import com.ibm.idl.constExpr.DefaultExprFactory;
import com.ibm.idl.constExpr.ExprFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Compile {
    public Arguments arguments = null;
    protected Hashtable overrideNames = new Hashtable();
    protected Hashtable symbolTable = new Hashtable();
    protected Vector includes = new Vector();
    protected Vector includeEntries = new Vector();
    static Noop noop = new Noop();
    private GenFactory genFactory = null;
    private SymtabFactory symtabFactory = null;
    private ExprFactory exprFactory = null;
    private Parser parser = null;
    Preprocessor preprocessor = new Preprocessor();
    private NoPragma noPragma = new NoPragma();
    private Enumeration emitList = null;
    private String[] keywords = null;
    private Vector definedSymbols = new Vector();

    public Compile() {
        this.noPragma.init(this.preprocessor);
        this.preprocessor.registerPragma(this.noPragma);
        ParseException.detected = false;
        SymtabEntry.includeStack = new Stack();
        SymtabEntry.setEmit = true;
        Parser.repIDStack = new Stack();
    }

    public static void main(String[] stringArray) {
        new Compile().start(stringArray);
        if (Util.errorsOccurred()) {
            System.exit(Util.errorExitCode());
        }
    }

    protected Factories factories() {
        return new Factories();
    }

    protected void registerPragma(PragmaHandler pragmaHandler) {
        pragmaHandler.init(this.preprocessor);
        this.preprocessor.registerPragma(pragmaHandler);
    }

    protected void init(String[] stringArray) throws InvalidArgument {
        this.initFactories();
        this.arguments.parseArgs(stringArray);
        Enumeration enumeration = this.arguments.definedSymbols.keys();
        while (enumeration.hasMoreElements()) {
            this.definedSymbols.addElement(enumeration.nextElement());
        }
        this.initGenerators();
        this.parser = new Parser(this.preprocessor, this.arguments, this.overrideNames, this.symbolTable, this.symtabFactory, this.exprFactory, this.keywords);
        this.preprocessor.init(this.parser);
        this.parser.includes = this.includes;
        this.parser.includeEntries = this.includeEntries;
    }

    protected Enumeration parse() throws IOException {
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parsing", this.arguments.file));
        }
        this.parser.parse(this.arguments.file);
        if (!ParseException.detected) {
            this.parser.forwardEntryCheck();
        }
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parseDone", this.arguments.file));
        }
        if (ParseException.detected) {
            this.symbolTable = null;
            this.emitList = null;
        } else {
            this.symbolTable = Parser.symbolTable;
            this.emitList = this.parser.emitList.elements();
        }
        return this.emitList;
    }

    public SymtabEntry resolve(String string) {
        SymtabEntry symtabEntry = null;
        if (this.parser != null && this.symbolTable != null) {
            symtabEntry = this.parser.resolve(string, null, true, false, false, true);
        }
        return symtabEntry;
    }

    protected void generate() throws IOException {
        if (ParseException.detected) {
            return;
        }
        this.generate(this.parser.emitList.elements());
    }

    protected void generate(Enumeration enumeration) throws IOException {
        if (enumeration != null) {
            if (this.arguments.verbose) {
                System.out.println();
            }
            while (enumeration.hasMoreElements()) {
                SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
                if (this.arguments.verbose && !(symtabEntry.generator() instanceof Noop)) {
                    if (symtabEntry.module().equals("")) {
                        System.out.println(Util.getMessage("Compile.generating", symtabEntry.name()));
                    } else {
                        System.out.println(Util.getMessage("Compile.generating", symtabEntry.module() + '/' + symtabEntry.name()));
                    }
                }
                symtabEntry.generate(this.symbolTable, null);
                if (!this.arguments.verbose || symtabEntry.generator() instanceof Noop) continue;
                if (symtabEntry.module().equals("")) {
                    System.out.println(Util.getMessage("Compile.genDone", symtabEntry.name()));
                    continue;
                }
                System.out.println(Util.getMessage("Compile.genDone", symtabEntry.module() + '/' + symtabEntry.name()));
            }
        }
    }

    public void start(String[] stringArray) {
        try {
            this.init(stringArray);
            if (this.arguments.versionRequest) {
                this.displayVersion();
            } else {
                this.parse();
                this.generate();
            }
        }
        catch (InvalidArgument invalidArgument) {
            System.err.println(invalidArgument);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private void initFactories() {
        Arguments arguments;
        Factories factories = this.factories();
        if (factories == null) {
            factories = new Factories();
        }
        this.arguments = (arguments = factories.arguments()) == null ? new Arguments() : arguments;
        SymtabFactory symtabFactory = factories.symtabFactory();
        this.symtabFactory = symtabFactory == null ? new DefaultSymtabFactory() : symtabFactory;
        ExprFactory exprFactory = factories.exprFactory();
        this.exprFactory = exprFactory == null ? new DefaultExprFactory() : exprFactory;
        GenFactory genFactory = factories.genFactory();
        this.genFactory = genFactory == null ? noop : genFactory;
        this.keywords = factories.languageKeywords();
        if (this.keywords == null) {
            this.keywords = new String[0];
        }
    }

    private void initGenerators() {
        AttributeGen attributeGen = this.genFactory.createAttributeGen();
        AttributeEntry.attributeGen = attributeGen == null ? noop : attributeGen;
        ConstGen constGen = this.genFactory.createConstGen();
        ConstEntry.constGen = constGen == null ? noop : constGen;
        DirectiveGen directiveGen = this.genFactory.createDirectiveGen();
        DirectiveEntry.directiveGen = directiveGen == null ? noop : directiveGen;
        EnumGen enumGen = this.genFactory.createEnumGen();
        EnumEntry.enumGen = enumGen == null ? noop : enumGen;
        ExceptionGen exceptionGen = this.genFactory.createExceptionGen();
        ExceptionEntry.exceptionGen = exceptionGen == null ? noop : exceptionGen;
        ForwardGen forwardGen = this.genFactory.createForwardGen();
        ForwardEntry.forwardGen = forwardGen == null ? noop : forwardGen;
        ForwardValueGen forwardValueGen = this.genFactory.createForwardValueGen();
        ForwardValueEntry.forwardValueGen = forwardValueGen == null ? noop : forwardValueGen;
        IncludeGen includeGen = this.genFactory.createIncludeGen();
        IncludeEntry.includeGen = includeGen == null ? noop : includeGen;
        InterfaceGen interfaceGen = this.genFactory.createInterfaceGen();
        InterfaceEntry.interfaceGen = interfaceGen == null ? noop : interfaceGen;
        ValueGen valueGen = this.genFactory.createValueGen();
        ValueEntry.valueGen = valueGen == null ? noop : valueGen;
        ValueBoxGen valueBoxGen = this.genFactory.createValueBoxGen();
        ValueBoxEntry.valueBoxGen = valueBoxGen == null ? noop : valueBoxGen;
        MethodGen methodGen = this.genFactory.createMethodGen();
        MethodEntry.methodGen = methodGen == null ? noop : methodGen;
        ModuleGen moduleGen = this.genFactory.createModuleGen();
        ModuleEntry.moduleGen = moduleGen == null ? noop : moduleGen;
        ParameterGen parameterGen = this.genFactory.createParameterGen();
        ParameterEntry.parameterGen = parameterGen == null ? noop : parameterGen;
        PragmaGen pragmaGen = this.genFactory.createPragmaGen();
        PragmaEntry.pragmaGen = pragmaGen == null ? noop : pragmaGen;
        PrimitiveGen primitiveGen = this.genFactory.createPrimitiveGen();
        PrimitiveEntry.primitiveGen = primitiveGen == null ? noop : primitiveGen;
        SequenceGen sequenceGen = this.genFactory.createSequenceGen();
        SequenceEntry.sequenceGen = sequenceGen == null ? noop : sequenceGen;
        StringGen stringGen = this.genFactory.createStringGen();
        StringEntry.stringGen = stringGen == null ? noop : stringGen;
        StructGen structGen = this.genFactory.createStructGen();
        StructEntry.structGen = structGen == null ? noop : structGen;
        TypedefGen typedefGen = this.genFactory.createTypedefGen();
        TypedefEntry.typedefGen = typedefGen == null ? noop : typedefGen;
        UnionGen unionGen = this.genFactory.createUnionGen();
        UnionEntry.unionGen = unionGen == null ? noop : unionGen;
    }

    protected void displayVersion() {
        String string = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        System.out.println(string);
    }

    protected Enumeration getEmitList2() {
        return this.parser.emitList2.elements();
    }

    protected Vector getDefinedSymbols() {
        return this.definedSymbols;
    }
}

