/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

class Logical {
    private Logical() {
    }

    static BigInteger not(BigInteger bigInteger) {
        int n;
        BigInteger bigInteger2 = null;
        if (bigInteger.sign == 0) {
            return BigInteger.MINUS_ONE;
        }
        if (bigInteger.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        int[] nArray = new int[bigInteger.numberLength + 1];
        if (bigInteger.sign > 0) {
            if (bigInteger.digits[bigInteger.numberLength - 1] != -1) {
                n = 0;
                while (bigInteger.digits[n] == -1) {
                    ++n;
                }
            } else {
                for (n = 0; n < bigInteger.numberLength && bigInteger.digits[n] == -1; ++n) {
                }
                if (n == bigInteger.numberLength) {
                    nArray[n] = 1;
                    bigInteger2 = new BigInteger(-bigInteger.sign, n + 1, nArray);
                    bigInteger2.cutOffLeadingZeroes();
                    return bigInteger2;
                }
            }
        } else {
            n = 0;
            while (bigInteger.digits[n] == 0) {
                nArray[n] = -1;
                ++n;
            }
        }
        nArray[n] = bigInteger.digits[n] + bigInteger.sign;
        ++n;
        while (n < bigInteger.numberLength) {
            nArray[n] = bigInteger.digits[n];
            ++n;
        }
        bigInteger2 = new BigInteger(-bigInteger.sign, n, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    static BigInteger and(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.sign == 0 || bigInteger.sign == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger2.equals(BigInteger.MINUS_ONE)) {
            return bigInteger;
        }
        if (bigInteger.equals(BigInteger.MINUS_ONE)) {
            return bigInteger2;
        }
        if (bigInteger.sign > 0) {
            if (bigInteger2.sign > 0) {
                return Logical.andPositive(bigInteger, bigInteger2);
            }
            return Logical.andDiffSigns(bigInteger, bigInteger2);
        }
        if (bigInteger2.sign > 0) {
            return Logical.andDiffSigns(bigInteger2, bigInteger);
        }
        if (bigInteger.numberLength > bigInteger2.numberLength) {
            return Logical.andNegative(bigInteger, bigInteger2);
        }
        return Logical.andNegative(bigInteger2, bigInteger);
    }

    static BigInteger andPositive(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        int n2 = Math.max(bigInteger.getFirstNonzeroDigit(), bigInteger2.getFirstNonzeroDigit());
        if (n2 >= n) {
            return BigInteger.ZERO;
        }
        int[] nArray = new int[n];
        while (n2 < n) {
            nArray[n2] = bigInteger.digits[n2] & bigInteger2.digits[n2];
            ++n2;
        }
        BigInteger bigInteger3 = new BigInteger(1, n, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger andDiffSigns(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.getFirstNonzeroDigit();
        int n2 = bigInteger2.getFirstNonzeroDigit();
        if (n2 >= bigInteger.numberLength) {
            return BigInteger.ZERO;
        }
        int n3 = bigInteger.numberLength;
        int[] nArray = new int[n3];
        int n4 = Math.max(n, n2);
        if (n4 == n2) {
            nArray[n4] = -bigInteger2.digits[n4] & bigInteger.digits[n4];
            ++n4;
        }
        int n5 = Math.min(bigInteger2.numberLength, bigInteger.numberLength);
        while (n4 < n5) {
            nArray[n4] = ~bigInteger2.digits[n4] & bigInteger.digits[n4];
            ++n4;
        }
        if (n4 >= bigInteger2.numberLength) {
            while (n4 < bigInteger.numberLength) {
                nArray[n4] = bigInteger.digits[n4];
                ++n4;
            }
        }
        BigInteger bigInteger3 = new BigInteger(1, n3, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger andNegative(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.getFirstNonzeroDigit();
        int n2 = bigInteger2.getFirstNonzeroDigit();
        if (n >= bigInteger2.numberLength) {
            return bigInteger;
        }
        int n3 = Math.max(n2, n);
        int n4 = n2 > n ? -bigInteger2.digits[n3] & ~bigInteger.digits[n3] : (n2 < n ? ~bigInteger2.digits[n3] & -bigInteger.digits[n3] : -bigInteger2.digits[n3] & -bigInteger.digits[n3]);
        if (n4 == 0) {
            ++n3;
            while (n3 < bigInteger2.numberLength && (n4 = ~(bigInteger.digits[n3] | bigInteger2.digits[n3])) == 0) {
                ++n3;
            }
            if (n4 == 0) {
                while (n3 < bigInteger.numberLength && (n4 = ~bigInteger.digits[n3]) == 0) {
                    ++n3;
                }
                if (n4 == 0) {
                    int n5 = bigInteger.numberLength + 1;
                    int[] nArray = new int[n5];
                    nArray[n5 - 1] = 1;
                    BigInteger bigInteger3 = new BigInteger(-1, n5, nArray);
                    return bigInteger3;
                }
            }
        }
        int n6 = bigInteger.numberLength;
        int[] nArray = new int[n6];
        nArray[n3] = -n4;
        ++n3;
        while (n3 < bigInteger2.numberLength) {
            nArray[n3] = bigInteger.digits[n3] | bigInteger2.digits[n3];
            ++n3;
        }
        while (n3 < bigInteger.numberLength) {
            nArray[n3] = bigInteger.digits[n3];
            ++n3;
        }
        BigInteger bigInteger4 = new BigInteger(-1, n6, nArray);
        return bigInteger4;
    }

    static BigInteger andNot(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.sign == 0) {
            return bigInteger;
        }
        if (bigInteger.sign == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger.equals(BigInteger.MINUS_ONE)) {
            return bigInteger2.not();
        }
        if (bigInteger2.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        if (bigInteger.sign > 0) {
            if (bigInteger2.sign > 0) {
                return Logical.andNotPositive(bigInteger, bigInteger2);
            }
            return Logical.andNotPositiveNegative(bigInteger, bigInteger2);
        }
        if (bigInteger2.sign > 0) {
            return Logical.andNotNegativePositive(bigInteger, bigInteger2);
        }
        return Logical.andNotNegative(bigInteger, bigInteger2);
    }

    static BigInteger andNotPositive(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int[] nArray = new int[bigInteger.numberLength];
        int n2 = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        for (n = bigInteger.getFirstNonzeroDigit(); n < n2; ++n) {
            nArray[n] = bigInteger.digits[n] & ~bigInteger2.digits[n];
        }
        while (n < bigInteger.numberLength) {
            nArray[n] = bigInteger.digits[n];
            ++n;
        }
        BigInteger bigInteger3 = new BigInteger(1, bigInteger.numberLength, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger andNotPositiveNegative(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2 = bigInteger2.getFirstNonzeroDigit();
        int n3 = bigInteger.getFirstNonzeroDigit();
        if (n2 >= bigInteger.numberLength) {
            return bigInteger;
        }
        int n4 = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        int[] nArray = new int[n4];
        for (n = n3; n < n2; ++n) {
            nArray[n] = bigInteger.digits[n];
        }
        if (n == n2) {
            nArray[n] = bigInteger.digits[n] & bigInteger2.digits[n] - 1;
            ++n;
        }
        while (n < n4) {
            nArray[n] = bigInteger.digits[n] & bigInteger2.digits[n];
            ++n;
        }
        BigInteger bigInteger3 = new BigInteger(1, n4, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger andNotNegativePositive(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2;
        int[] nArray;
        int n3 = bigInteger.getFirstNonzeroDigit();
        int n4 = bigInteger2.getFirstNonzeroDigit();
        if (n3 >= bigInteger2.numberLength) {
            return bigInteger;
        }
        int n5 = Math.max(bigInteger.numberLength, bigInteger2.numberLength);
        if (n4 > n3) {
            nArray = new int[n5];
            n2 = Math.min(bigInteger.numberLength, n4);
            for (n = n3; n < n2; ++n) {
                nArray[n] = bigInteger.digits[n];
            }
            if (n == bigInteger.numberLength) {
                for (n = n4; n < bigInteger2.numberLength; ++n) {
                    nArray[n] = bigInteger2.digits[n];
                }
            }
        } else {
            int n6 = -bigInteger.digits[n] & ~bigInteger2.digits[n];
            if (n6 == 0) {
                n2 = Math.min(bigInteger2.numberLength, bigInteger.numberLength);
                ++n;
                while (n < n2 && (n6 = ~(bigInteger.digits[n] | bigInteger2.digits[n])) == 0) {
                    ++n;
                }
                if (n6 == 0) {
                    while (n < bigInteger2.numberLength && (n6 = ~bigInteger2.digits[n]) == 0) {
                        ++n;
                    }
                    while (n < bigInteger.numberLength && (n6 = ~bigInteger.digits[n]) == 0) {
                        ++n;
                    }
                    if (n6 == 0) {
                        int[] nArray2 = new int[++n5];
                        nArray2[n5 - 1] = 1;
                        BigInteger bigInteger3 = new BigInteger(-1, n5, nArray2);
                        return bigInteger3;
                    }
                }
            }
            nArray = new int[n5];
            nArray[n] = -n6;
            ++n;
        }
        n2 = Math.min(bigInteger2.numberLength, bigInteger.numberLength);
        while (n < n2) {
            nArray[n] = bigInteger.digits[n] | bigInteger2.digits[n];
            ++n;
        }
        while (n < bigInteger.numberLength) {
            nArray[n] = bigInteger.digits[n];
            ++n;
        }
        while (n < bigInteger2.numberLength) {
            nArray[n] = bigInteger2.digits[n];
            ++n;
        }
        BigInteger bigInteger4 = new BigInteger(-1, n5, nArray);
        return bigInteger4;
    }

    static BigInteger andNotNegative(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2 = bigInteger.getFirstNonzeroDigit();
        int n3 = bigInteger2.getFirstNonzeroDigit();
        if (n2 >= bigInteger2.numberLength) {
            return BigInteger.ZERO;
        }
        int n4 = bigInteger2.numberLength;
        int[] nArray = new int[n4];
        int n5 = n2;
        if (n2 < n3) {
            nArray[n5] = -bigInteger.digits[n5];
            n = Math.min(bigInteger.numberLength, n3);
            ++n5;
            while (n5 < n) {
                nArray[n5] = ~bigInteger.digits[n5];
                ++n5;
            }
            if (n5 == bigInteger.numberLength) {
                while (n5 < n3) {
                    nArray[n5] = -1;
                    ++n5;
                }
                nArray[n5] = bigInteger2.digits[n5] - 1;
            } else {
                nArray[n5] = ~bigInteger.digits[n5] & bigInteger2.digits[n5] - 1;
            }
        } else {
            nArray[n5] = n3 < n2 ? -bigInteger.digits[n5] & bigInteger2.digits[n5] : -bigInteger.digits[n5] & bigInteger2.digits[n5] - 1;
        }
        n = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        ++n5;
        while (n5 < n) {
            nArray[n5] = ~bigInteger.digits[n5] & bigInteger2.digits[n5];
            ++n5;
        }
        while (n5 < bigInteger2.numberLength) {
            nArray[n5] = bigInteger2.digits[n5];
            ++n5;
        }
        BigInteger bigInteger3 = new BigInteger(1, n4, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger or(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.equals(BigInteger.MINUS_ONE) || bigInteger.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.MINUS_ONE;
        }
        if (bigInteger2.sign == 0) {
            return bigInteger;
        }
        if (bigInteger.sign == 0) {
            return bigInteger2;
        }
        if (bigInteger.sign > 0) {
            if (bigInteger2.sign > 0) {
                if (bigInteger.numberLength > bigInteger2.numberLength) {
                    return Logical.orPositive(bigInteger, bigInteger2);
                }
                return Logical.orPositive(bigInteger2, bigInteger);
            }
            return Logical.orDiffSigns(bigInteger, bigInteger2);
        }
        if (bigInteger2.sign > 0) {
            return Logical.orDiffSigns(bigInteger2, bigInteger);
        }
        if (bigInteger2.getFirstNonzeroDigit() > bigInteger.getFirstNonzeroDigit()) {
            return Logical.orNegative(bigInteger2, bigInteger);
        }
        return Logical.orNegative(bigInteger, bigInteger2);
    }

    static BigInteger orPositive(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.numberLength;
        int[] nArray = new int[n];
        int n2 = Math.min(bigInteger.getFirstNonzeroDigit(), bigInteger2.getFirstNonzeroDigit());
        for (n2 = 0; n2 < bigInteger2.numberLength; ++n2) {
            nArray[n2] = bigInteger.digits[n2] | bigInteger2.digits[n2];
        }
        while (n2 < n) {
            nArray[n2] = bigInteger.digits[n2];
            ++n2;
        }
        BigInteger bigInteger3 = new BigInteger(1, n, nArray);
        return bigInteger3;
    }

    static BigInteger orNegative(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2 = bigInteger2.getFirstNonzeroDigit();
        int n3 = bigInteger.getFirstNonzeroDigit();
        if (n3 >= bigInteger2.numberLength) {
            return bigInteger2;
        }
        if (n2 >= bigInteger.numberLength) {
            return bigInteger;
        }
        int n4 = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        int[] nArray = new int[n4];
        if (n2 == n3) {
            nArray[n3] = -(-bigInteger.digits[n3] | -bigInteger2.digits[n3]);
            n = n3;
        } else {
            for (n = n2; n < n3; ++n) {
                nArray[n] = bigInteger2.digits[n];
            }
            nArray[n] = bigInteger2.digits[n] & bigInteger.digits[n] - 1;
        }
        ++n;
        while (n < n4) {
            nArray[n] = bigInteger.digits[n] & bigInteger2.digits[n];
            ++n;
        }
        BigInteger bigInteger3 = new BigInteger(-1, n4, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger orDiffSigns(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2;
        int n3 = bigInteger2.getFirstNonzeroDigit();
        int n4 = bigInteger.getFirstNonzeroDigit();
        if (n4 >= bigInteger2.numberLength) {
            return bigInteger2;
        }
        int n5 = bigInteger2.numberLength;
        int[] nArray = new int[n5];
        if (n3 < n4) {
            for (n2 = n3; n2 < n4; ++n2) {
                nArray[n2] = bigInteger2.digits[n2];
            }
        } else if (n4 < n3) {
            n2 = n4;
            nArray[n2] = -bigInteger.digits[n2];
            n = Math.min(bigInteger.numberLength, n3);
            ++n2;
            while (n2 < n) {
                nArray[n2] = ~bigInteger.digits[n2];
                ++n2;
            }
            if (n2 != bigInteger.numberLength) {
                nArray[n2] = ~(-bigInteger2.digits[n2] | bigInteger.digits[n2]);
            } else {
                while (n2 < n3) {
                    nArray[n2] = -1;
                    ++n2;
                }
                nArray[n2] = bigInteger2.digits[n2] - 1;
            }
            ++n2;
        } else {
            n2 = n4;
            nArray[n2] = -(-bigInteger2.digits[n2] | bigInteger.digits[n2]);
            ++n2;
        }
        n = Math.min(bigInteger2.numberLength, bigInteger.numberLength);
        while (n2 < n) {
            nArray[n2] = bigInteger2.digits[n2] & ~bigInteger.digits[n2];
            ++n2;
        }
        while (n2 < bigInteger2.numberLength) {
            nArray[n2] = bigInteger2.digits[n2];
            ++n2;
        }
        BigInteger bigInteger3 = new BigInteger(-1, n5, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger xor(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.sign == 0) {
            return bigInteger;
        }
        if (bigInteger.sign == 0) {
            return bigInteger2;
        }
        if (bigInteger2.equals(BigInteger.MINUS_ONE)) {
            return bigInteger.not();
        }
        if (bigInteger.equals(BigInteger.MINUS_ONE)) {
            return bigInteger2.not();
        }
        if (bigInteger.sign > 0) {
            if (bigInteger2.sign > 0) {
                if (bigInteger.numberLength > bigInteger2.numberLength) {
                    return Logical.xorPositive(bigInteger, bigInteger2);
                }
                return Logical.xorPositive(bigInteger2, bigInteger);
            }
            return Logical.xorDiffSigns(bigInteger, bigInteger2);
        }
        if (bigInteger2.sign > 0) {
            return Logical.xorDiffSigns(bigInteger2, bigInteger);
        }
        if (bigInteger2.getFirstNonzeroDigit() > bigInteger.getFirstNonzeroDigit()) {
            return Logical.xorNegative(bigInteger2, bigInteger);
        }
        return Logical.xorNegative(bigInteger, bigInteger2);
    }

    static BigInteger xorPositive(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2 = bigInteger.numberLength;
        int[] nArray = new int[n2];
        for (n = Math.min(bigInteger.getFirstNonzeroDigit(), bigInteger2.getFirstNonzeroDigit()); n < bigInteger2.numberLength; ++n) {
            nArray[n] = bigInteger.digits[n] ^ bigInteger2.digits[n];
        }
        while (n < bigInteger.numberLength) {
            nArray[n] = bigInteger.digits[n];
            ++n;
        }
        BigInteger bigInteger3 = new BigInteger(1, n2, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger xorNegative(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2;
        int n3 = Math.max(bigInteger.numberLength, bigInteger2.numberLength);
        int[] nArray = new int[n3];
        int n4 = bigInteger.getFirstNonzeroDigit();
        int n5 = n2 = bigInteger2.getFirstNonzeroDigit();
        if (n4 == n2) {
            nArray[n5] = -bigInteger.digits[n5] ^ -bigInteger2.digits[n5];
        } else {
            nArray[n5] = -bigInteger2.digits[n5];
            n = Math.min(bigInteger2.numberLength, n4);
            ++n5;
            while (n5 < n) {
                nArray[n5] = ~bigInteger2.digits[n5];
                ++n5;
            }
            if (n5 == bigInteger2.numberLength) {
                while (n5 < n4) {
                    nArray[n5] = -1;
                    ++n5;
                }
                nArray[n5] = bigInteger.digits[n5] - 1;
            } else {
                nArray[n5] = -bigInteger.digits[n5] ^ ~bigInteger2.digits[n5];
            }
        }
        n = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
        ++n5;
        while (n5 < n) {
            nArray[n5] = bigInteger.digits[n5] ^ bigInteger2.digits[n5];
            ++n5;
        }
        while (n5 < bigInteger.numberLength) {
            nArray[n5] = bigInteger.digits[n5];
            ++n5;
        }
        while (n5 < bigInteger2.numberLength) {
            nArray[n5] = bigInteger2.digits[n5];
            ++n5;
        }
        BigInteger bigInteger3 = new BigInteger(1, n3, nArray);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static BigInteger xorDiffSigns(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4 = Math.max(bigInteger2.numberLength, bigInteger.numberLength);
        int n5 = bigInteger2.getFirstNonzeroDigit();
        if (n5 < (n3 = bigInteger.getFirstNonzeroDigit())) {
            nArray = new int[n4];
            n2 = n5;
            nArray[n2] = bigInteger2.digits[n2];
            n = Math.min(bigInteger2.numberLength, n3);
            ++n2;
            while (n2 < n) {
                nArray[n2] = bigInteger2.digits[n2];
                ++n2;
            }
            if (n2 == bigInteger2.numberLength) {
                while (n2 < bigInteger.numberLength) {
                    nArray[n2] = bigInteger.digits[n2];
                    ++n2;
                }
            }
        } else if (n3 < n5) {
            nArray = new int[n4];
            n2 = n3;
            nArray[n2] = -bigInteger.digits[n2];
            n = Math.min(bigInteger.numberLength, n5);
            ++n2;
            while (n2 < n) {
                nArray[n2] = ~bigInteger.digits[n2];
                ++n2;
            }
            if (n2 == n5) {
                if (n5 == bigInteger.numberLength) {
                    nArray[n2] = ~(-bigInteger2.digits[n2]);
                    ++n2;
                } else {
                    nArray[n2] = ~(bigInteger.digits[n2] ^ -bigInteger2.digits[n2]);
                    ++n2;
                }
            } else {
                while (n2 < n5) {
                    nArray[n2] = -1;
                    ++n2;
                }
                while (n2 < bigInteger2.numberLength) {
                    nArray[n2] = n2 == n5 ? ~(-bigInteger2.digits[n2]) : bigInteger2.digits[n2];
                    ++n2;
                }
            }
        } else {
            n2 = n5;
            int n6 = bigInteger.digits[n2] ^ -bigInteger2.digits[n2];
            if (n6 == 0) {
                n = Math.min(bigInteger.numberLength, bigInteger2.numberLength);
                ++n2;
                while (n2 < n && (n6 = bigInteger.digits[n2] ^ ~bigInteger2.digits[n2]) == 0) {
                    ++n2;
                }
                if (n6 == 0) {
                    while (n2 < bigInteger.numberLength && (n6 = ~bigInteger.digits[n2]) == 0) {
                        ++n2;
                    }
                    while (n2 < bigInteger2.numberLength && (n6 = ~bigInteger2.digits[n2]) == 0) {
                        ++n2;
                    }
                    if (n6 == 0) {
                        int[] nArray2 = new int[++n4];
                        nArray2[n4 - 1] = 1;
                        BigInteger bigInteger3 = new BigInteger(-1, n4, nArray2);
                        return bigInteger3;
                    }
                }
            }
            nArray = new int[n4];
            nArray[n2] = -n6;
            ++n2;
        }
        n = Math.min(bigInteger2.numberLength, bigInteger.numberLength);
        while (n2 < n) {
            nArray[n2] = ~(~bigInteger2.digits[n2] ^ bigInteger.digits[n2]);
            ++n2;
        }
        while (n2 < bigInteger.numberLength) {
            nArray[n2] = bigInteger.digits[n2];
            ++n2;
        }
        while (n2 < bigInteger2.numberLength) {
            nArray[n2] = bigInteger2.digits[n2];
            ++n2;
        }
        BigInteger bigInteger4 = new BigInteger(-1, n4, nArray);
        bigInteger4.cutOffLeadingZeroes();
        return bigInteger4;
    }
}

