/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class ExtendedCertificateAttributes
extends PKCS9DerObject
implements Cloneable {
    private PKCSAttributes attributes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ExtendedCertificateAttributes";
    private volatile int cachedHashVal = 0;

    public ExtendedCertificateAttributes(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", (Object)der);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", der, provider);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttribute attribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", attribute);
        }
        PKCSAttribute[] attrs = new PKCSAttribute[]{attribute};
        this.attributes = new PKCSAttributes(attrs);
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttribute attribute, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", attribute, provider);
        }
        PKCSAttribute[] attrs = new PKCSAttribute[]{attribute};
        this.attributes = new PKCSAttributes(attrs, provider);
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttributes attributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", attributes);
        }
        this.attributes = attributes;
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttributes attributes, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", attributes, provider);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
        this.attributes = attributes;
    }

    public ExtendedCertificateAttributes(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", filename, new Boolean(base64));
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", parms);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ExtendedCertificateAttributes result = new ExtendedCertificateAttributes(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof ExtendedCertificateAttributes) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((ExtendedCertificateAttributes)obj)));
            }
            return this.equals((ExtendedCertificateAttributes)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID);
        }
        return PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Attributes not specified.");
            }
            throw new IOException("Attributes not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        this.attributes.encode(tmpout2);
        tmpout.write((byte)49, tmpout2.toByteArray());
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public PKCSAttributes getExtendedCertificateAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtendedCertificateAttributes");
            debug.exit(16384L, (Object)className, "getExtendedCertificateAttributes", this.attributes);
        }
        return this.attributes;
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getExtendedCertificateAttributes());
        }
        return this.getExtendedCertificateAttributes();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 49) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ExtendedCertificateAttributes");
        }
        return "ExtendedCertificateAttributes";
    }

    @Override
    public String toString() {
        String out = "PKCS9 ExtendedCertificateAttributes:\r\n";
        if (this.attributes == null || this.attributes.size() == 0) {
            out = out + "\tNo PKCSAttributes value set.\r\n";
        } else {
            PKCSAttribute[] attrs = this.attributes.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                out = out + "PKCSAttribute[" + i + "]:\r\n";
                out = out + attrs[i].toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        super.decode(encoding);
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.attributes = new PKCSAttributes(new DerInputStream(elems[0].toByteArray()), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(ExtendedCertificateAttributes other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

