/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.OriginatorInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class AuthenticatedData
extends Content
implements Cloneable {
    private static final byte TAG_OINFO = 0;
    private static final byte TAG_DIGESTALG = 1;
    private static final byte TAG_AUTHATTRS = 2;
    private static final byte TAG_UNAUTHATTRS = 3;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.AuthenticatedData";
    private BigInteger version = BigInteger.ZERO;
    private OriginatorInfo originator;
    private RecipientInfo[] recipientInfos;
    private AlgorithmId macAlgorithm;
    private AlgorithmId digestAlgorithm;
    private EncapsulatedContentInfo encapsulatedContent;
    private PKCSAttributes authAttribs;
    private byte[] mac;
    private PKCSAttributes unauthAttribs;
    private SmudgedBytes contentEncryptionKey;

    public AuthenticatedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedData", (Object)der);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedData", der, provider);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originator, RecipientInfo[] recipientInfos, String macAlgorithm, String digestAlgorithm, EncapsulatedContentInfo encapsulatedContent, PKCSAttributes authAttribs, PKCSAttributes unauthAttribs) throws IOException, PKCSException, NoSuchAlgorithmException {
        this(secretKey, originator, recipientInfos, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs, null);
        if (debug != null) {
            Object[] parms = new Object[]{secretKey, originator, recipientInfos, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs};
            debug.entry(16384L, (Object)className, "AuthenticatedData", parms);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originator, RecipientInfo[] recipientInfos, String macAlgorithm, String digestAlgorithm, EncapsulatedContentInfo encapsulatedContent, PKCSAttributes authAttribs, PKCSAttributes unauthAttribs, String provider) throws IOException, PKCSException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{secretKey, originator, recipientInfos, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs, provider};
            debug.entry(16384L, (Object)className, "AuthenticatedData", parms);
        }
        this.originator = originator;
        if (recipientInfos == null || recipientInfos.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  recipientInfos must be specified");
            }
            throw new IOException("error:  recipientInfos must be specified");
        }
        this.recipientInfos = recipientInfos;
        if (macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  macAlgorithm must be specified");
            }
            throw new IOException("error:  macAlgorithm must be specified");
        }
        this.setmacAlgorithm(macAlgorithm);
        if (digestAlgorithm != null) {
            String digestAlg = PKCS7.getDigestAlgorithm(digestAlgorithm);
            this.setdigestAlgorithm(digestAlg);
        } else {
            this.digestAlgorithm = null;
        }
        if (encapsulatedContent == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "encapsulatedContent must be specified");
            }
            throw new IOException("encapsulatedContent must be specified");
        }
        if (secretKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "secretKey must be specified");
            }
            throw new IOException("secretKey must be specified");
        }
        this.setContentEncryptionKey(secretKey.getEncoded());
        this.authAttribs = authAttribs;
        this.unauthAttribs = unauthAttribs;
        this.setEncapsulatedContent(encapsulatedContent);
        this.mac = null;
        this.calculateMac(secretKey);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originator, Certificate[] recipientCerts, String macAlgorithm, String digestAlgorithm, EncapsulatedContentInfo encapsulatedContent, PKCSAttributes authAttribs, PKCSAttributes unauthAttribs) throws IOException, PKCSException, NoSuchAlgorithmException {
        this(secretKey, originator, recipientCerts, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs, null);
        if (debug != null) {
            Object[] parms = new Object[]{secretKey, originator, recipientCerts, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs};
            debug.entry(16384L, (Object)className, "AuthenticatedData", parms);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originator, Certificate[] recipientCerts, String macAlgorithm, String digestAlgorithm, EncapsulatedContentInfo encapsulatedContent, PKCSAttributes authAttribs, PKCSAttributes unauthAttribs, String provider) throws IOException, PKCSException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{secretKey, originator, recipientCerts, macAlgorithm, digestAlgorithm, encapsulatedContent, authAttribs, unauthAttribs, provider};
            debug.entry(16384L, (Object)className, "AuthenticatedData", parms);
        }
        this.originator = originator;
        if (recipientCerts == null || recipientCerts.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  recipientCerts must be specified");
            }
            throw new IOException("error:  recipientCerts must be specified");
        }
        if (macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  macAlgorithm must be specified");
            }
            throw new IOException("error:  macAlgorithm must be specified");
        }
        this.setmacAlgorithm(macAlgorithm);
        if (digestAlgorithm != null) {
            String digestAlg = PKCS7.getDigestAlgorithm(digestAlgorithm);
            this.setdigestAlgorithm(digestAlg);
        } else {
            this.digestAlgorithm = null;
        }
        if (encapsulatedContent == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  encapsulatedContent must be specified");
            }
            throw new IOException("error:  encapsulatedContent must be specified");
        }
        if (secretKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  secretKey must be specified");
            }
            throw new IOException("error:  secretKey must be specified");
        }
        this.setContentEncryptionKey(secretKey.getEncoded());
        this.authAttribs = authAttribs;
        this.unauthAttribs = unauthAttribs;
        this.setEncapsulatedContent(encapsulatedContent);
        this.mac = null;
        this.addRecipient(recipientCerts);
        this.calculateMac(secretKey);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedData", filename, new Boolean(base64));
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "AuthenticatedData", parms);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            AuthenticatedData result = new AuthenticatedData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void addRecipient(Certificate cert) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient");
            }
            return;
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Certificate must be of type X509Certificate.  Instead it is of type " + cert.getClass().getName() + ".");
            }
            throw new IllegalArgumentException("Certificate must be of type X509Certificate.  Instead it is of type " + cert.getClass().getName() + ".");
        }
        if (this.getContentEncryptionKey() == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Digest encryption key is null.");
            }
            throw new PKCSException("Digest encryption key is null.");
        }
        RecipientInfo ri = new RecipientInfo(this.getContentEncryptionKey(), cert, this.provider);
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            this.recipientInfos = new RecipientInfo[1];
            this.recipientInfos[0] = ri;
        } else {
            RecipientInfo[] tmpRecipients = new RecipientInfo[this.recipientInfos.length + 1];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                tmpRecipients[i] = this.recipientInfos[i];
            }
            tmpRecipients[i] = ri;
            this.recipientInfos = tmpRecipients;
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public void addRecipient(Certificate[] certs) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certs);
        }
        if (certs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addRecipient", "certs is null");
            }
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            this.addRecipient(certs[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    private void calculateMac(SecretKey secretKey) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", secretKey);
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "MAC algorithm not specified.");
            }
            throw new IOException("MAC algorithm not specified.");
        }
        String macname = this.macAlgorithm.getName();
        Mac m = null;
        try {
            m = Mac.getInstance(macname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "addRecipient", e);
                debug.text(16384L, className, "addRecipient", "Error trying to retrieve the algorithm for " + macname + ".");
            }
            throw new PKCSException(e, "Error trying to retrieve the algorithm for " + macname + ".");
        }
        try {
            m.init(secretKey);
            byte[] bytes = this.calculatePreMac();
            m.update(bytes);
            this.mac = m.doFinal();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "addRecipient", e);
                debug.text(16384L, className, "addRecipient", "Error calculating mac: " + e.toString());
            }
            throw new PKCSException(e, "Error calculating mac: " + e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public boolean verify(SecretKey secretKey) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", secretKey);
        }
        boolean result = this.verify(secretKey, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(result));
        }
        return result;
    }

    public boolean verify(SecretKey secretKey, byte[] msg) throws IOException, PKCSException {
        byte[] computedmdbytes;
        if (debug != null) {
            debug.entry(16384L, className, "verify", secretKey, msg);
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "MAC algorithm not stored with AuthenticatedData.");
            }
            throw new IOException("MAC algorithm not stored with AuthenticatedData.");
        }
        if (this.mac == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "MAC byte array value not stored with AuthenticatedData.");
            }
            throw new IOException("MAC byte array value not stored with AuthenticatedData.");
        }
        PKCSAttribute attr = this.getAuthAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        if (attr == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message Digest authenticated attribute not stored with AuthenticatedData.");
            }
            throw new IOException("Message Digest authenticated attribute not stored with AuthenticatedData.");
        }
        byte[] bytes = msg;
        if (bytes == null && (bytes = this.getContent()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array not specified and content not stored with AuthenticatedData.");
            }
            throw new PKCSException("Byte array not specified and content not stored with AuthenticatedData.");
        }
        MessageDigest md = (MessageDigest)attr.getPKCS9DerObject();
        byte[] mdbytes = md.getBytes();
        if (mdbytes.length != (computedmdbytes = this.calculateMessageDigest(bytes)).length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < mdbytes.length; ++i) {
            if (mdbytes[i] == computedmdbytes[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        String macname = this.macAlgorithm.getName();
        Mac m = null;
        try {
            m = Mac.getInstance(macname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e);
                debug.text(16384L, className, "verify", "Error trying to retrieve the algorithm for " + macname + ".");
            }
            throw new PKCSException(e, "Error trying to retrieve the algorithm for " + macname + ".");
        }
        byte[] computedmac = null;
        try {
            m.init(secretKey);
            byte[] prebytes = this.calculatePreMac();
            m.update(prebytes);
            computedmac = m.doFinal();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e);
                debug.text(16384L, className, "verify", "Error calculating mac: " + e.toString());
            }
            throw new PKCSException(e, "Error calculating mac: " + e.toString());
        }
        if (this.mac.length != computedmac.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < this.mac.length; ++i) {
            if (this.mac[i] == computedmac[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(true));
        }
        return true;
    }

    public synchronized void removeContent() throws IOException {
        byte[] bytes = null;
        if (debug != null) {
            debug.entry(16384L, className, "removeContent");
        }
        ContentInfo contentInfo = new ContentInfo(this.encapsulatedContent.getContentType(), bytes, this.provider);
        this.encapsulatedContent = new EncapsulatedContentInfo(contentInfo, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "removeContent");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.AUTHENTICATED_DATA_OID);
        }
        return PKCSOID.AUTHENTICATED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public OriginatorInfo getOriginator() {
        if (debug != null) {
            debug.entry(16384L, className, "getOriginator");
        }
        if (this.originator == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOriginator", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOriginator", this.originator.clone());
        }
        return (OriginatorInfo)this.originator.clone();
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        RecipientInfo[] ris = new RecipientInfo[this.recipientInfos.length];
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            ris[i] = (RecipientInfo)this.recipientInfos[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", ris);
        }
        return ris;
    }

    public AlgorithmId getMacAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getMacAlgorithm");
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMacAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.macAlgorithm.getOID(), this.macAlgorithm.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMacAlgorithm", result);
        }
        return result;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
        }
        return result;
    }

    private void setmacAlgorithm(String macAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "setMacAlgorithm");
        }
        this.macAlgorithm = AlgorithmId.get(macAlgorithm);
        if (debug != null) {
            debug.exit(16384L, className, "setMacAlgorithm");
        }
    }

    private void setdigestAlgorithm(String digestAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "setdigestAlgorithm");
        }
        this.digestAlgorithm = AlgorithmId.get(digestAlgorithm);
        if (debug != null) {
            debug.exit(8192L, className, "setdigestAlgorithm");
        }
    }

    public EncapsulatedContentInfo getEncapsulatedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContent");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncapsulatedContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncapsulatedContent", this.encapsulatedContent.clone());
        }
        return (EncapsulatedContentInfo)this.encapsulatedContent.clone();
    }

    public byte[] getMac() {
        if (debug != null) {
            debug.entry(16384L, className, "getMac");
        }
        if (this.mac == null || this.mac.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMac", null);
            }
            return null;
        }
        byte[] mac2 = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, mac2, 0, this.mac.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMac", mac2);
        }
        return mac2;
    }

    public PKCSAttributes getAuthAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAuthAttributes");
        }
        if (this.authAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttributes", this.authAttribs);
        }
        return this.authAttribs;
    }

    public PKCSAttributes getUnauthAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnauthAttributes");
        }
        if (this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttributes", this.unauthAttribs);
        }
        return this.unauthAttribs;
    }

    private byte[] getContent() {
        if (debug != null) {
            debug.entry(8192L, className, "getContent");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContent", this.encapsulatedContent.getContent());
        }
        return this.encapsulatedContent.getContent();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerEncoder[] temps;
        DerOutputStream tmpout;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.checkValues();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.originator != null) {
            tmpout = new DerOutputStream();
            this.originator.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        if (this.recipientInfos != null && this.recipientInfos.length > 0) {
            temps = new DerOutputStream[this.recipientInfos.length];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                temps[i] = new DerOutputStream();
                this.recipientInfos[i].encode((OutputStream)((Object)temps[i]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding RecipientInfos");
            }
            throw new IOException("error encoding RecipientInfos");
        }
        bytes.putOrderedSetOf((byte)49, temps);
        this.macAlgorithm.encode(bytes);
        if (this.digestAlgorithm != null) {
            tmpout = new DerOutputStream();
            this.digestAlgorithm.encode(tmpout);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        DerOutputStream out = new DerOutputStream();
        this.encapsulatedContent.encode(out);
        bytes.putDerValue(new DerValue(out.toByteArray()));
        this.encodeAuthAttributes(bytes);
        if (this.mac == null || this.mac.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding mac");
            }
            throw new IOException("error encoding mac");
        }
        bytes.putOctetString(this.mac);
        if (this.unauthAttribs != null && this.unauthAttribs.size() > 0) {
            DerOutputStream tmpout2 = new DerOutputStream();
            this.unauthAttribs.encode(tmpout2);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)3), tmpout2);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        DerInputStream derin;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue der = null;
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "AuthenticatedData parsing error");
            }
            throw new IOException("AuthenticatedData parsing error");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid AuthenticatedData version = " + this.version + " (must be 0)");
            }
            throw new IOException("Invalid AuthenticatedData version = " + this.version + " (must be 0)");
        }
        if ((byte)encoding.getData().peekByte() == -96) {
            der = encoding.getData().getDerValue();
            der.resetTag((byte)48);
            this.originator = new OriginatorInfo(der.toByteArray(), this.provider);
        } else {
            this.originator = null;
        }
        DerValue[] rInfos = encoding.getData().getSet(1);
        int len = rInfos.length;
        this.recipientInfos = new RecipientInfo[len];
        for (int i = 0; i < len; ++i) {
            this.recipientInfos[i] = new RecipientInfo(rInfos[i].toByteArray(), this.provider);
        }
        this.macAlgorithm = AlgorithmId.parse(encoding.getData().getDerValue());
        boolean gotDigestAlgorithm = false;
        DerValue opt = encoding.getData().getDerValue();
        if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
            DerValue der2 = opt.getData().getDerValue();
            this.digestAlgorithm = AlgorithmId.parse(der2);
            gotDigestAlgorithm = true;
        } else {
            this.digestAlgorithm = null;
        }
        if (gotDigestAlgorithm) {
            der = encoding.getData().getDerValue();
            this.encapsulatedContent = new EncapsulatedContentInfo(der.toByteArray(), this.provider);
        } else {
            this.encapsulatedContent = new EncapsulatedContentInfo(opt.toByteArray(), this.provider);
        }
        boolean gotAuthAttrs = false;
        opt = encoding.getData().getDerValue();
        if (opt.isContextSpecific((byte)2) && opt.isConstructed()) {
            derin = new DerInputStream(opt.toByteArray());
            this.authAttribs = new PKCSAttributes(derin, this.provider);
            gotAuthAttrs = true;
        } else {
            this.authAttribs = null;
        }
        this.mac = gotAuthAttrs ? encoding.getData().getOctetString() : opt.getOctetString();
        if (encoding.getData().available() != 0) {
            opt = encoding.getData().getDerValue();
            if (opt.isContextSpecific((byte)3) && opt.isConstructed()) {
                derin = new DerInputStream(opt.toByteArray());
                this.unauthAttribs = new PKCSAttributes(derin, this.provider);
            } else {
                this.unauthAttribs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof AuthenticatedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((AuthenticatedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "decode", e);
                debug.exit(16384L, (Object)className, "decode_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode_5", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        try {
            DerOutputStream thisOut = new DerOutputStream();
            this.encode(thisOut);
            int HashVal = Arrays.hashCode(thisOut.toByteArray());
            return HashVal;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void addAuthAttribute(PKCSAttributes authAttribs) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addAuthAttribute", authAttribs);
        }
        if (authAttribs == null || authAttribs.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addAuthAttribute_1");
            }
            return;
        }
        this.authAttribs = this.authAttribs == null ? (PKCSAttributes)authAttribs.clone() : this.authAttribs.addAttributes(authAttribs);
        if (debug != null) {
            debug.exit(8192L, className, "addAuthAttribute_2");
        }
    }

    private void addAuthAttribute(PKCSAttribute authAttrib) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addAuthAttribute", authAttrib);
        }
        if (authAttrib == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addAuthAttribute_1");
            }
            return;
        }
        if (this.authAttribs == null) {
            PKCSAttribute[] attribs = new PKCSAttribute[]{authAttrib};
            this.authAttribs = new PKCSAttributes(attribs, this.provider);
        } else {
            this.authAttribs = this.authAttribs.addAttribute(authAttrib);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addAuthAttribute_2");
        }
    }

    private void removeAuthAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeAuthAttribute", oid);
        }
        if (oid == null || this.authAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeAuthAttribute_1");
            }
            return;
        }
        this.authAttribs = this.authAttribs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(8192L, className, "removeAuthAttribute_2");
        }
    }

    private void addUnauthAttribute(PKCSAttributes unauthAttribs) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnauthAttribute", unauthAttribs);
        }
        if (unauthAttribs == null || unauthAttribs.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnauthAttribute_1");
            }
            return;
        }
        this.unauthAttribs = this.unauthAttribs == null ? (PKCSAttributes)unauthAttribs.clone() : this.unauthAttribs.addAttributes(unauthAttribs);
        if (debug != null) {
            debug.exit(8192L, className, "addUnauthAttribute_2");
        }
    }

    private void addUnauthAttribute(PKCSAttribute unauthAttrib) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnauthAttribute", unauthAttrib);
        }
        if (unauthAttrib == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnauthAttribute_1");
            }
            return;
        }
        if (this.unauthAttribs == null) {
            PKCSAttribute[] attribs = new PKCSAttribute[]{unauthAttrib};
            this.unauthAttribs = new PKCSAttributes(attribs, this.provider);
        } else {
            this.unauthAttribs = this.unauthAttribs.addAttribute(unauthAttrib);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnauthAttribute_2");
        }
    }

    private void removeUnauthAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeUnauthAttribute", oid);
        }
        if (oid == null || this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeUnauthAttribute_1");
            }
            return;
        }
        this.unauthAttribs = this.unauthAttribs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(8192L, className, "removeUnauthAttribute_2");
        }
    }

    public PKCSAttribute getAuthAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAuthAttribute", oid);
        }
        if (oid == null || this.authAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attrib = (PKCSAttribute)this.authAttribs.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttribute", attrib);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttribute", attrib);
        }
        return attrib;
    }

    public PKCSAttribute getUnauthAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnauthAttribute", oid);
        }
        if (oid == null || this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attrib = (PKCSAttribute)this.unauthAttribs.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttribute", attrib);
        }
        return attrib;
    }

    public boolean hasAuthenticatedAttribute(ObjectIdentifier oid) {
        PKCSAttribute authAttrib;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasAuthenticatedAttribute", oid);
        }
        if ((authAttrib = this.getAuthAttribute(oid)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttribute", new Boolean(true));
        }
        return true;
    }

    public boolean hasUnauthenticatedAttribute(ObjectIdentifier oid) {
        PKCSAttribute unauthAttrib;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasUnauthenticatedAttribute", oid);
        }
        if ((unauthAttrib = this.getUnauthAttribute(oid)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(true));
        }
        return true;
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 AuthenticatedData:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n\toriginator: " + this.originator;
        out = out + "\r\n\trecipientInfos: \r\n";
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            out = out + "recipientInfos[" + i + "] : " + this.recipientInfos[i];
        }
        out = out + "\r\n\tmacAlgorithm: " + this.macAlgorithm;
        out = this.digestAlgorithm != null ? out + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm : out + "\r\n\tdigestAlgorithm: null";
        out = out + "\r\n\tencapsulatedContent: \r\n" + this.encapsulatedContent;
        if (this.authAttribs != null) {
            out = out + "\r\n\tauthenticatedAttributes (" + this.authAttribs.size() + "): \r\n";
            out = out + this.authAttribs + "\r\n";
        } else {
            out = out + "\tauthenticatedAttributes: null\r\n";
        }
        out = out + "\r\n\tmac:";
        out = this.mac != null ? out + "\r\n" + hexDump.encodeBuffer(this.mac) + "\r\n" : out + "null";
        if (this.unauthAttribs != null) {
            out = out + "\r\n\tunauthenticatedAttributes (" + this.unauthAttribs.size() + "): \r\n";
            out = out + this.unauthAttribs + "\r\n";
        } else {
            out = out + "\tunauthenticatedAttributes: null\r\n";
        }
        return out;
    }

    private void encodeAuthAttributes(DerOutputStream bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeAuthAttributes", bytes);
        }
        if (this.authAttribs != null && this.authAttribs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.authAttribs.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)2), tmpout);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeAuthAttributes");
        }
    }

    private void encodeAuthAttributesExplicit(DerOutputStream bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeAuthAttributesExplicit", bytes);
        }
        if (this.authAttribs != null && this.authAttribs.size() > 0) {
            bytes.write(this.authAttribs.generateDerEncoding());
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeAuthAttributesExplicit");
        }
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing recipientInfos value.");
            }
            throw new IOException("AuthenticatedData missing recipientInfos value.");
        }
        if (this.recipientInfos != null && this.recipientInfos.length == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData must have at least one element in the recipientInfos collection.");
            }
            throw new IOException("AuthenticatedData must have at least one element in the recipientInfos collection.");
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing macAlgorithm value.");
            }
            throw new IOException("AuthenticatedData missing macAlgorithm value.");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing encapsulatedContentInfo value.");
            }
            throw new IOException("AuthenticatedData missing encapsulatedContentInfo value.");
        }
        if (this.mac == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing mac value.");
            }
            throw new IOException("AuthenticatedData missing mac value.");
        }
        if (!this.encapsulatedContent.getContentType().equals(PKCSOID.DATA_OID) && this.authAttribs == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If encapsulatedContentInfo is not of the Data type, authenticatedAttributes must also be specified.");
            }
            throw new IOException("If encapsulatedContentInfo is not of the Data type, authenticatedAttributes must also be specified.");
        }
        if (this.digestAlgorithm != null && this.authAttribs == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If digestAlgorithm is specified for AuthenticatedData, authenticatedAttributes must also be specified.");
            }
            throw new IOException("If digestAlgorithm is specified for AuthenticatedData, authenticatedAttributes must also be specified.");
        }
        if (this.digestAlgorithm == null && this.authAttribs != null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If authenticatedAttributes are specified for AuthenticatedData, digestAlgorithm must also be specified.");
            }
            throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, digestAlgorithm must also be specified.");
        }
        if (this.unauthAttribs != null && this.unauthAttribs.size() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If unauthenticatedAttributes are specified for AuthenticatedData, at least one unauthenticated attribute must be specified.");
            }
            throw new IOException("If unauthenticatedAttributes are specified for AuthenticatedData, at least one unauthenticated attribute must be specified.");
        }
        this.checkAuthAttributeValues();
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void checkAuthAttributeValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkAuthAttributeValues");
        }
        if (this.authAttribs != null && this.authAttribs.size() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, at least one authenticated attribute must be specified.");
            }
            throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, at least one authenticated attribute must be specified.");
        }
        if (this.authAttribs != null) {
            PKCSAttribute attrib = this.getAuthAttribute(PKCSOID.CONTENT_TYPE_OID);
            if (attrib == null) {
                if (debug != null) {
                    debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, the collection must include the ContentType attribute.");
                }
                throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, the collection must include the ContentType attribute.");
            }
            attrib = this.getAuthAttribute(PKCSOID.MESSAGE_DIGEST_OID);
            if (attrib == null) {
                if (debug != null) {
                    debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, the collection must include the MessageDigest attribute.");
                }
                throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, the collection must include the MessageDigest attribute.");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkAuthAttributeValues");
        }
    }

    private byte[] calculatePreMac() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculatePreMac");
        }
        byte[] econtent = null;
        if (this.encapsulatedContent != null) {
            econtent = this.encapsulatedContent.getContent();
        }
        if (this.authAttribs == null && econtent == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculatePreMac", "Cannot calculate the Mac without authenticated attributes  or encapsulated contents.");
            }
            throw new IOException("Cannot calculate the Mac without authenticated attributes  or encapsulated contents.");
        }
        if (this.authAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMac", econtent);
            }
            return econtent;
        }
        this.checkAuthAttributeValues();
        DerOutputStream tmpout = new DerOutputStream();
        this.encodeAuthAttributesExplicit(tmpout);
        byte[] bytes = tmpout.toByteArray();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculatePreMac", bytes);
        }
        return bytes;
    }

    private void setEncapsulatedContent(EncapsulatedContentInfo encapsulatedContent) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncapsulatedContent", encapsulatedContent);
        }
        this.encapsulatedContent = encapsulatedContent;
        this.setAuthenticatedAttributes();
        if (debug != null) {
            debug.exit(8192L, className, "setEncapsulatedContent");
        }
    }

    private void setAuthenticatedAttributes() throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, className, "setAuthenticatedAttributes");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(8192L, className, "setAuthenticatedAttributes_1");
            }
            return;
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "setAuthenticatedAttributes", "encapsulatedContent was not specified.");
            }
            throw new IllegalArgumentException("encapsulatedContent was not specified.");
        }
        ContentType ct = new ContentType(this.encapsulatedContent.getContentType(), this.provider);
        byte[] digest = this.calculateMessageDigest(this.encapsulatedContent);
        MessageDigest md = new MessageDigest(this.provider);
        md.setData(digest);
        this.addAuthAttribute(ct.getPKCSAttribute());
        this.addAuthAttribute(md.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setAuthenticatedAttributes");
        }
    }

    private byte[] calculateMessageDigest(EncapsulatedContentInfo encapsulatedContent) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", encapsulatedContent);
        }
        if (encapsulatedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        byte[] bytesToBeDigested = encapsulatedContent.getContent();
        byte[] result = this.calculateMessageDigest(bytesToBeDigested);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", result);
        }
        return result;
    }

    private byte[] calculateMessageDigest(byte[] bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", (Object)bytes);
        }
        String mdname = this.digestAlgorithm.getName();
        java.security.MessageDigest md = null;
        try {
            md = this.provider != null ? java.security.MessageDigest.getInstance(mdname, this.provider) : java.security.MessageDigest.getInstance(mdname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", e.toString());
            }
            throw new IOException(e.toString());
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "provider " + this.provider + " not found:" + e.toString());
            }
            throw new IOException("provider " + this.provider + " not found:" + e.toString());
        }
        byte[] digest = md.digest(bytes);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", bytes);
        }
        return digest;
    }

    private void setContentEncryptionKey(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)bytes);
        }
        this.contentEncryptionKey = new SmudgedBytes(bytes);
        if (debug != null) {
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "getContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

