/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;

public final class PKCS12Utils {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12Utils";

    private PKCS12Utils() {
    }

    public static byte[] ascii2bmp(char[] chars) {
        byte[] bmpStr = new byte[]{};
        if (debug != null) {
            debug.entry(49152L, (Object)className, "ascii2bmp", (Object)chars);
        }
        if (chars == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "ascii2bmp_1", bmpStr);
            }
            return bmpStr;
        }
        if (chars.length > 0) {
            bmpStr = new byte[(chars.length + 1) * 2];
        }
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            bmpStr[j] = (byte)(chars[i] >>> 8 & 0xFF);
            bmpStr[j + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            j += 2;
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "ascii2bmp_2", bmpStr);
        }
        return bmpStr;
    }

    public static String bmp2string(byte[] bmp) {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "bmp2string", (Object)bmp);
        }
        if (bmp.length % 2 != 0) {
            if (debug != null) {
                debug.text(49152L, className, "bmp2string", "Invalid BMP array.");
            }
            throw new IllegalArgumentException("Invalid BMP array.");
        }
        char[] chars = new char[bmp.length / 2];
        int i = 0;
        int j = 0;
        while (i < bmp.length) {
            byte b1 = bmp[i++];
            byte b2 = bmp[i++];
            chars[j] = (char)((b1 << 8 & 0xFF00) + (b2 & 0xFF));
            ++j;
        }
        String str = new String(chars);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "bmp2string", str.trim());
        }
        return str.trim();
    }
}

