/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

public final class AuthenticatedSafe
extends PKCSDerObject
implements Cloneable {
    private ContentInfo[] cinfos;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.AuthenticatedSafe";
    private volatile int cachedHashVal = 0;

    public AuthenticatedSafe(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(ContentInfo[] info) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", info);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
        this.cinfos = info;
    }

    public AuthenticatedSafe(ContentInfo[] info, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", info, provider);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
        this.cinfos = info;
    }

    public AuthenticatedSafe(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", filename, new Boolean(base64));
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", parms);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.cinfos != null && this.cinfos.length != 0) {
            for (int i = 0; i < this.cinfos.length; ++i) {
                this.cinfos[i].encode(bytes);
            }
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public AuthenticatedSafe addContentInfo(ContentInfo[] contents) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addContentInfo", contents);
        }
        AuthenticatedSafe as = (AuthenticatedSafe)this.clone();
        if (contents == null || contents.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addContentInfo_1", as);
            }
            return as;
        }
        if (as.cinfos == null) {
            as.cinfos = contents;
        } else {
            int i;
            int newLength = as.cinfos.length + contents.length;
            ContentInfo[] newContents = new ContentInfo[newLength];
            for (i = 0; i < as.cinfos.length; ++i) {
                newContents[i] = as.cinfos[i];
            }
            int j = i;
            int k = 0;
            while (j < newLength) {
                newContents[j] = contents[k];
                ++j;
                ++k;
            }
            as.cinfos = newContents;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addContentInfo_2", as);
        }
        return as;
    }

    public ContentInfo[] getContentInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfos");
            debug.exit(16384L, (Object)className, "getContentInfos", (ContentInfo[])this.cinfos.clone());
        }
        if (this.cinfos == null) {
            return null;
        }
        return (ContentInfo[])this.cinfos.clone();
    }

    public ContentInfo toContentInfo() throws IOException {
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "toContentInfo");
        }
        this.encode(derout);
        ContentInfo result = new ContentInfo(PKCSOID.DATA_OID, derout.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toContentInfo", result);
        }
        return result;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            AuthenticatedSafe retval = new AuthenticatedSafe(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retval);
            }
            return retval;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (obj instanceof AuthenticatedSafe) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((AuthenticatedSafe)obj));
            }
            return this.equals((AuthenticatedSafe)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        String out = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + "AuthenticatedSafe:\r\n";
        if (this.cinfos == null || this.cinfos.length == 0) {
            out = out + "No contents";
        } else {
            for (int i = 0; i < this.cinfos.length; ++i) {
                out = out + "ContentInfo[" + i + "]\r\n";
                out = out + this.cinfos[i].toString();
                out = out + "\r\n";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        HexDumpEncoder hd = new HexDumpEncoder();
        Vector<ContentInfo> cinfoV = new Vector<ContentInfo>();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "AuthenticatedSafe parsing error, not a SEQUENCE OF");
            }
            throw new IOException("AuthenticatedSafe parsing error, not a SEQUENCE OF");
        }
        while (encoding.getData().available() != 0) {
            DerValue der = encoding.getData().getDerValue();
            ContentInfo cinfo = new ContentInfo(der.toByteArray(), this.provider);
            cinfoV.add(cinfo);
        }
        if (cinfoV.size() > 0) {
            this.cinfos = new ContentInfo[cinfoV.size()];
            for (int i = 0; i < cinfoV.size(); ++i) {
                this.cinfos[i] = (ContentInfo)cinfoV.elementAt(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(AuthenticatedSafe other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", true);
        }
        return true;
    }
}

