/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs;

import com.ibm.security.util.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class PKCS8Key
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    private static final int V1 = 0;
    private static final int V2 = 1;
    public static final BigInteger version = BigInteger.ZERO;

    public PKCS8Key() {
    }

    private PKCS8Key(AlgorithmId algid, byte[] key) throws InvalidKeyException {
        this.algid = algid;
        this.key = key;
        this.encode();
    }

    protected PKCS8Key(byte[] input) throws InvalidKeyException {
        try {
            this.decode(new DerValue(input));
        }
        catch (IOException e) {
            throw new InvalidKeyException("Unable to decode key", e);
        }
    }

    private void decode(DerValue val) throws InvalidKeyException {
        try {
            if (val.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            int version = val.data.getInteger().intValue();
            if (version != 0 && version != 1) {
                throw new InvalidKeyException("unknown version: " + version);
            }
            this.algid = AlgorithmId.parse(val.data.getDerValue());
            this.key = val.data.getOctetString();
            if (val.data.available() == 0) {
                return;
            }
            DerValue next = val.data.getDerValue();
            if (next.isContextSpecific((byte)0)) {
                if (val.data.available() == 0) {
                    return;
                }
                next = val.data.getDerValue();
            }
            if (next.isContextSpecific((byte)1)) {
                if (version == 0) {
                    throw new InvalidKeyException("publicKey seen in v1");
                }
                if (val.data.available() == 0) {
                    return;
                }
            }
            throw new InvalidKeyException("Extra bytes");
        }
        catch (IOException e) {
            throw new InvalidKeyException("Unable to decode key", e);
        }
    }

    public static PKCS8Key parse(DerValue in) throws IOException {
        PrivateKey key = PKCS8Key.parseKey(in);
        if (key instanceof PKCS8Key) {
            return (PKCS8Key)key;
        }
        throw new IOException("Provider did not return PKCS8Key");
    }

    public static PrivateKey parseKey(DerValue in) throws IOException {
        PrivateKey privKey;
        if (in.tag != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger parsedVersion = in.data.getBigInteger();
        if (!version.equals(parsedVersion)) {
            throw new IOException("version mismatch: (supported: " + Debug.toHexString((BigInteger)version) + ", parsed: " + Debug.toHexString((BigInteger)parsedVersion));
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.data.getDerValue());
        try {
            privKey = PKCS8Key.buildPKCS8Key(algorithm, in.data.getOctetString());
        }
        catch (InvalidKeyException e) {
            throw new IOException("corrupt private key");
        }
        if (in.data.available() != 0) {
            throw new IOException("excess private key");
        }
        return privKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PrivateKey buildPKCS8Key(AlgorithmId algid, byte[] key) throws IOException, InvalidKeyException {
        DerOutputStream pkcs8EncodedKeyStream = new DerOutputStream();
        PKCS8Key.encode(pkcs8EncodedKeyStream, algid, key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pkcs8EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = KeyFactory.getInstance(algid.getName());
            return keyFac.generatePrivate(pkcs8KeySpec);
        }
        catch (NoSuchAlgorithmException keyFac) {
        }
        catch (InvalidKeySpecException keyFac) {
            // empty catch block
        }
        String classname = "";
        try {
            Class<?> keyClass;
            block13: {
                Provider sunProvider = Security.getProvider("SUN");
                if (sunProvider == null) {
                    throw new InstantiationException();
                }
                classname = sunProvider.getProperty("PrivateKey.PKCS#8." + algid.getName());
                if (classname == null) {
                    throw new InstantiationException();
                }
                keyClass = null;
                try {
                    keyClass = Class.forName(classname);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    if (cl == null) break block13;
                    keyClass = cl.loadClass(classname);
                }
            }
            Object inst = null;
            if (keyClass != null) {
                inst = keyClass.newInstance();
            }
            if (inst instanceof PKCS8Key) {
                PKCS8Key result = inst;
                result.algid = algid;
                result.key = key;
                result.parseKeyBits();
                return result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException e) {
            throw new IOException(classname + " [internal error]");
        }
        PKCS8Key result = new PKCS8Key();
        result.algid = algid;
        result.key = key;
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream out) throws IOException {
        PKCS8Key.encode(out, this.algid, this.key);
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result = null;
        try {
            result = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream out = new DerOutputStream();
                this.encode(out);
                this.encodedKey = out.toByteArray();
            }
            catch (IOException e) {
                throw new InvalidKeyException("IOException : " + e.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(InputStream in) throws InvalidKeyException {
        try {
            DerValue val = new DerValue(in);
            if (val.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger version = val.data.getBigInteger();
            if (!version.equals(PKCS8Key.version)) {
                throw new IOException("version mismatch: (supported: " + Debug.toHexString((BigInteger)PKCS8Key.version) + ", parsed: " + Debug.toHexString((BigInteger)version));
            }
            this.algid = AlgorithmId.parse(val.data.getDerValue());
            this.key = val.data.getOctetString();
            this.parseKeyBits();
            if (val.data.available() == 0) return;
        }
        catch (IOException e) {
            throw new InvalidKeyException("IOException : " + e.getMessage());
        }
    }

    public void decode(byte[] encodedKey) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(encodedKey));
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            this.decode(stream);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IOException("deserialized key is invalid: " + e.getMessage());
        }
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(version);
        algid.encode(tmp);
        tmp.putOctetString(key);
        out.write((byte)48, tmp);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            byte[] b1 = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            byte[] b2 = ((Key)object).getEncoded();
            return MessageDigest.isEqual(b1, b2);
        }
        return false;
    }

    public int hashCode() {
        int retval = 0;
        byte[] b1 = this.getEncoded();
        for (int i = 1; i < b1.length; ++i) {
            retval += b1[i] * i;
        }
        return retval;
    }
}

