/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private AlgorithmParameterSpec keyParams;
    private static final String[] z;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.a(this.algid, bigInteger, bigInteger2);
    }

    public RSAPublicKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.a(algorithmId, bigInteger, bigInteger2);
    }

    private void a(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        this.algid = algorithmId;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        try {
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)keyType, (AlgorithmParameterSpec)algorithmParameterSpec);
        return new RSAPublicKey(algorithmId, bigInteger, bigInteger2);
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    public String toString() {
        return z[3] + this.modulus.toString() + z[4] + this.publicExponent.toString() + z[2] + this.keyParams + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            this.modulus = derInputStream2.getPositiveBigInteger();
            this.publicExponent = derInputStream2.getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[6]);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[7] + exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new InvalidObjectException(z[1]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000f}/\u00145L|5\fq(W\bX4\u0002q5\u001c4V2";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                block18: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block18;
                    n5 = n5;
                    if (n5 <= n4) break block19;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 108;
                            break;
                        }
                        case 1: {
                            n6 = 18;
                            break;
                        }
                        case 2: {
                            n6 = 90;
                            break;
                        }
                        case 3: {
                            n6 = 120;
                            break;
                        }
                        default: {
                            n6 = 81;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ">A\u001b($\u000e~3\u001b\u001a\tkz\u00134\u0015az\u0019#\t24\u0017%Lv3\n4\u000ff6\u0001q\bw)\u001d#\u0005s6\u0011+\rp6\u001d";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "fb;\n0\u0001a`";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "%P\u00172\u0012)2\b+\u0010LB/\u001a=\u0005qz34\u0015(P\u0015>\bg6\r\"V\u0018";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "fb/\u001a=\u0005qz\u001d)\u001c}4\u001d?\u0018(P";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\"}.X0LA\u001f)\u0004)\\\u0019=";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ")j.\n0Lv;\f0Ls,\u00198\u0000s8\u00144";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "%|,\u0019=\u0005vz\u00134\u00152,\u0019=\u0019wzr";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

