/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.bf;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[0]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
            this.b = secureRandom;
            this.a = this.c.getCurve().getField().getFieldSize();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[1]);
        }
        this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
        if (this.c == null) {
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.b = secureRandom;
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[3]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c, eCPublicKey);
            return new KeyPair(eCPublicKey, eCPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, bf.a, true);
                Object var2_6 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bf.E.mod(bf.a), bf.c, 1);
                this.c = new ECParameterSpec(primeCurve, bf.f, bf.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, bf.g, true);
                Object var2_7 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bf.E.mod(bf.g), bf.i, 1);
                this.c = new ECParameterSpec(primeCurve, bf.l, bf.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, bf.m, true);
                Object var2_8 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bf.E.mod(bf.m), bf.o, 1);
                this.c = new ECParameterSpec(primeCurve, bf.r, bf.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, bf.s, true);
                Object var2_9 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bf.E.mod(bf.s), bf.u, 1);
                this.c = new ECParameterSpec(primeCurve, bf.x, bf.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, bf.y, true);
                Object var2_10 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, bf.E.mod(bf.y), bf.A, 1);
                this.c = new ECParameterSpec(primeCurve, bf.D, bf.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "V\u0002\u0004~E&\u0003\u0004iE&\u001d\u0018`T&\u0012\b3Oh\u0015M|F<P\\*\u0012*P_!\u0014*P_&\u0016*P^+\u0014*PX!\u0011";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 6;
                            break;
                        }
                        case 1: {
                            n6 = 112;
                            break;
                        }
                        case 2: {
                            n6 = 109;
                            break;
                        }
                        case 3: {
                            n6 = 19;
                            break;
                        }
                        default: {
                            n6 = 32;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "V\u0011\u001frMuP\u0000fSrP\u000fv\u0000o\u001e\u001egAh\u0013\b3O`P(Ppg\u0002\f~Er\u0015\u001f@Pc\u0013M|R&5.TEh \faAk\u0015\u0019vRU\u0000\bp";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "E\u0005\u001feE&\u001e\f~E&\u001e\u0002g\u0000t\u0015\u000e|Gh\u0019\u0017vD&\u001f\u001f3Ni\u0004M`Uv\u0000\u0002aTc\u0014";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "O2 @Ee\u0005\u001fvrg\u001e\t|M";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

