/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReqBody {
    public KDCOptions kdcOptions;
    public PrincipalName cname;
    public PrincipalName sname;
    public KerberosTime from;
    public KerberosTime till;
    public KerberosTime rtime;
    public HostAddresses addresses;
    private int a;
    private int[] eType = null;
    private EncryptedData b;
    private Ticket[] additionalTickets;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n2, int[] nArray, HostAddresses hostAddresses, EncryptedData encryptedData, Ticket[] ticketArray) throws IOException {
        this.kdcOptions = kDCOptions;
        this.cname = principalName;
        this.sname = principalName2;
        this.from = kerberosTime;
        this.till = kerberosTime2;
        this.rtime = kerberosTime3;
        this.a = n2;
        if (nArray != null) {
            this.eType = (int[])nArray.clone();
        }
        this.addresses = hostAddresses;
        this.b = encryptedData;
        if (ticketArray != null) {
            this.additionalTickets = new Ticket[ticketArray.length];
            for (int n3 = 0; n3 < ticketArray.length; ++n3) {
                if (ticketArray[n3] == null) {
                    throw new IOException(z[1]);
                }
                this.additionalTickets[n3] = (Ticket)ticketArray[n3].clone();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KDCReqBody(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbException, IOException {
        this.addresses = null;
        this.b = null;
        this.additionalTickets = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.kdcOptions = KDCOptions.parse(derValue.getData(), (byte)0, false);
        this.cname = PrincipalName.parse(derValue.getData(), (byte)1, true, new Realm(z[0]));
        if (n2 != 10 && this.cname != null) {
            throw new Asn1Exception(906);
        }
        Realm realm = Realm.parse(derValue.getData(), (byte)2, false);
        if (this.cname != null) {
            this.cname = new PrincipalName(this.cname.getNameType(), this.cname.getNameStrings(), realm);
        }
        this.sname = PrincipalName.parse(derValue.getData(), (byte)3, true, realm);
        this.from = KerberosTime.parse(derValue.getData(), (byte)4, true);
        this.till = KerberosTime.parse(derValue.getData(), (byte)5, false);
        this.rtime = KerberosTime.parse(derValue.getData(), (byte)6, true);
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 7) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        Vector<Integer> vector = new Vector<Integer>();
        if ((derValue2.getTag() & 0x1F) != 8) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue3.getData().available() > 0) {
            vector.addElement(derValue3.getData().getBigInteger().intValue());
        }
        this.eType = new int[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.eType[i2] = (Integer)vector.elementAt(i2);
        }
        if (derValue.getData().available() > 0) {
            this.addresses = HostAddresses.parse(derValue.getData(), (byte)9, true);
        }
        if (derValue.getData().available() > 0) {
            this.b = EncryptedData.parse(derValue.getData(), (byte)10, true);
        }
        if (derValue.getData().available() > 0) {
            Vector<Ticket> vector2 = new Vector<Ticket>();
            derValue2 = derValue.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) != 11) {
                throw new Asn1Exception(906);
            }
            derValue3 = derValue2.getData().getDerValue();
            if (derValue3.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            while (derValue3.getData().available() > 0) {
                vector2.addElement(new Ticket(derValue3.getData().getDerValue()));
            }
            if (vector2.size() > 0) {
                this.additionalTickets = new Ticket[vector2.size()];
                vector2.copyInto(this.additionalTickets);
            }
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n2, int[] nArray, HostAddresses hostAddresses, Object object, Object object2) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] asn1Encode(int n2) throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        Vector<DerValue> vector = new Vector<DerValue>();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.kdcOptions.asn1Encode()));
        if (n2 == 10 && this.cname != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.cname.asn1Encode()));
        }
        if (this.sname != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.sname.getRealm().asn1Encode()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.sname.asn1Encode()));
        } else if (this.cname != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.cname.getRealm().asn1Encode()));
        }
        if (this.from != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.from.asn1Encode()));
        }
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.till.asn1Encode()));
        if (this.rtime != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.rtime.asn1Encode()));
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream2.toByteArray()));
        derOutputStream2 = new DerOutputStream();
        for (int i2 = 0; i2 < this.eType.length; ++i2) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.eType[i2]));
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), derOutputStream3.toByteArray()));
        if (this.addresses != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.addresses.asn1Encode()));
        }
        if (this.b != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.b.asn1Encode()));
        }
        if (this.additionalTickets != null && this.additionalTickets.length > 0) {
            derOutputStream2 = new DerOutputStream();
            for (int i3 = 0; i3 < this.additionalTickets.length; ++i3) {
                derOutputStream2.write(this.additionalTickets[i3].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream.toByteArray()));
        }
        derOutputStream = new DerValue[vector.size()];
        vector.copyInto((Object[])derOutputStream);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putSequence((DerValue[])derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getNonce() {
        return this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0018\u0016\u00107F\u0000\u0015\u001d0F\u001a";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 72;
                                break;
                            }
                            case 1: {
                                n9 = 90;
                                break;
                            }
                            case 2: {
                                n9 = 81;
                                break;
                            }
                            case 3: {
                                n9 = 116;
                                break;
                            }
                            default: {
                                n9 = 3;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000b;?\u001al<z2\u0006f).4Tbh\u0011\u00157Q-+\u0013\u001bg1";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

