/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class EncAPRepPart {
    private KerberosTime a;
    private int b;
    private EncryptionKey c;
    private Integer d;

    public EncAPRepPart(KerberosTime kerberosTime, int n2, EncryptionKey encryptionKey, Integer n3) {
        this.a = kerberosTime;
        this.b = n2;
        this.c = encryptionKey;
        this.d = n3;
    }

    public EncAPRepPart(byte[] byArray) throws Asn1Exception, IOException {
        this.a(new DerValue(byArray));
    }

    public EncAPRepPart(DerValue derValue) throws Asn1Exception, IOException {
        this.a(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, IOException {
        if ((derValue.getTag() & 0x1F) != 27 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.a = KerberosTime.parse(derValue3.getData(), (byte)0, true);
        DerValue derValue2 = derValue3.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.b = derValue2.getData().getBigInteger().intValue();
        if (derValue3.getData().available() > 0) {
            this.c = EncryptionKey.parse(derValue3.getData(), (byte)2, true);
        } else {
            this.c = null;
            this.d = null;
        }
        if (derValue3.getData().available() > 0) {
            derValue2 = derValue3.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) != 3) {
                throw new Asn1Exception(906);
            }
            this.d = new Integer(derValue2.getData().getBigInteger().intValue());
        } else {
            this.d = null;
        }
        if (derValue3.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.a.asn1Encode()));
        derOutputStream.putInteger(BigInteger.valueOf(this.b));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream.toByteArray()));
        if (this.c != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.c.asn1Encode()));
        }
        if (this.d != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.d);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream.toByteArray()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)27), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final EncryptionKey getSubKey() {
        return this.c;
    }

    public final Integer getSeqNumber() {
        return this.d;
    }

    public int getCusec() {
        return this.b;
    }

    public KerberosTime getCtime() {
        return this.a;
    }

    public KerberosTime getTime() {
        return this.getCtime();
    }

    public int getMicroSeconds() {
        return this.getCusec();
    }
}

