/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.jgss.i18n.PropertyResource;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbCryptoException;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.Krb5;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.e;
import com.ibm.security.krb5.internal.crypto.s;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Checksum {
    private int a;
    private byte[] b;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3 = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3_KD = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5_ARCFOUR = -138;
    public static int CKSUMTYPE_DEFAULT;
    public static int SAFECKSUMTYPE_DEFAULT;
    private static final int[] c;
    private static final String[] z;

    public static void initStatic() {
        block17: {
            Config config;
            String string;
            block15: {
                string = null;
                config = null;
                try {
                    block14: {
                        config = Config.getInstance();
                        string = config.get(z[27], z[26]);
                        if (string == null) break block14;
                        CKSUMTYPE_DEFAULT = Config.getType(string);
                        break block15;
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
                catch (Exception exception) {
                    if (Krb5.DEBUG) {
                        System.out.println(z[23] + Thread.currentThread().getName() + z[28]);
                        exception.printStackTrace();
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
            }
            try {
                block16: {
                    string = config.get(z[25], z[21]);
                    if (string == null) break block16;
                    SAFECKSUMTYPE_DEFAULT = Config.getType(string);
                    break block17;
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
            catch (Exception exception) {
                if (Krb5.DEBUG) {
                    System.out.println(z[24] + Thread.currentThread().getName() + z[22]);
                    exception.printStackTrace();
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
        }
    }

    public Checksum(byte[] byArray, int n2) {
        this.a = n2;
        this.b = byArray;
    }

    public boolean verifyAnyChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbCryptoException {
        return e.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    public Checksum(int n2, byte[] byArray, EncryptionKey encryptionKey, int n3) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.a = n2 == -1 ? s.a(encryptionKey.getEType()).checksumType() : n2;
        this.b = e.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), n3);
    }

    public boolean verifyKeyedChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        e e2 = e.a(this.a);
        if (!e2.c()) {
            throw new KrbApErrException(50);
        }
        return e2.a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    boolean a(Checksum checksum) throws KdcErrException {
        if (this.a != checksum.a) {
            return false;
        }
        return e.a(this.b, checksum.b);
    }

    public Checksum(DerValue derValue) throws Asn1Exception, IOException {
        block11: {
            block10: {
                DerValue derValue2;
                block9: {
                    block8: {
                        if (derValue.getTag() != 48) {
                            throw new Asn1Exception(906);
                        }
                        derValue2 = derValue.getData().getDerValue();
                        if ((derValue2.getTag() & 0x1F) != 0) break block8;
                        this.a = derValue2.getData().getBigInteger().intValue();
                        break block9;
                    }
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 1) break block10;
                this.b = derValue2.getData().getOctetString();
                break block11;
            }
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Checksum parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Checksum(derValue2);
    }

    public final byte[] getBytes() {
        return this.b;
    }

    public final int getType() {
        return this.a;
    }

    public static boolean isSupportedType(int n2) {
        return Arrays.binarySearch(c, n2) >= 0;
    }

    public static boolean isValidType(int n2) {
        return Checksum.isSupportedType(n2);
    }

    public boolean isCollisionProofType() {
        return Checksum.isCollisionProofType(this.a);
    }

    public static boolean isCollisionProofType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int[] getSupportedTypes() {
        return c;
    }

    public boolean isSafeType() {
        return Checksum.isSafeType(this.a);
    }

    public static boolean isSafeType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int stringToChecksumType(String string) throws Exception {
        if (string == null) {
            I18NException.throwException(z[17]);
        }
        if (string.equalsIgnoreCase(z[19])) {
            return 12;
        }
        if (string.equalsIgnoreCase(z[13])) {
            return 8;
        }
        if (string.equalsIgnoreCase(z[15])) {
            return 7;
        }
        if (string.equalsIgnoreCase(z[10])) {
            return -138;
        }
        if (string.equalsIgnoreCase(z[16])) {
            return 4;
        }
        if (string.equalsIgnoreCase(z[11])) {
            return 5;
        }
        if (string.equalsIgnoreCase(z[14])) {
            return 15;
        }
        if (string.equalsIgnoreCase(z[12])) {
            return 16;
        }
        if (string.equalsIgnoreCase(z[18])) {
            return 1;
        }
        I18NException.throwException(z[20], new String[]{string});
        return -999;
    }

    public static String checksumTypeToString(int n2) {
        switch (n2) {
            case 12: {
                return z[0];
            }
            case 8: {
                return z[9];
            }
            case 7: {
                return z[3];
            }
            case -138: {
                return z[4];
            }
            case 4: {
                return z[2];
            }
            case 5: {
                return z[6];
            }
            case 15: {
                return z[1];
            }
            case 16: {
                return z[8];
            }
            case 1: {
                return z[7];
            }
        }
        PropertyResource propertyResource = PropertyResource.getExceptionInstance();
        return propertyResource.getFormattedString(z[5], new Integer[]{new Integer(n2)});
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[29];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0011P\u0004\r!\nU\u0004_!\u001dX\u0016]";
        int n3 = -1;
        block36: while (true) {
            char[] cArray;
            block41: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block40: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block40;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block41;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 121;
                                break;
                            }
                            case 1: {
                                n9 = 61;
                                break;
                            }
                            case 2: {
                                n9 = 101;
                                break;
                            }
                            case 3: {
                                n9 = 110;
                                break;
                            }
                            default: {
                                n9 = 12;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0011P\u0004\r!\nU\u0004_!@\u000bH\u000fi\n\fWV";
                    n3 = 0;
                    continue block36;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001dX\u0016Ca\u0018^";
                    n3 = 1;
                    continue block36;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000bN\u0004Ca\u001d\b";
                    n3 = 2;
                    continue block36;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0011P\u0004\r!\u0014YP";
                    n3 = 3;
                    continue block36;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ";\\\u0001-g\nH\b:u\tX";
                    n3 = 4;
                    continue block36;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001dX\u0016Ca\u0018^H\u0005";
                    n3 = 5;
                    continue block36;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001aO\u0006]>";
                    n3 = 6;
                    continue block36;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0011P\u0004\r!\nU\u0004_!@\u000bH\u000fi\n\u000fPX";
                    n3 = 7;
                    continue block36;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u000bN\u0004Ca\u001d\bH\ni\n";
                    n3 = 8;
                    continue block36;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0011P\u0004\r!\u0014YP";
                    n3 = 9;
                    continue block36;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001dX\u0016Ca\u0018^H\u0005";
                    n3 = 10;
                    continue block36;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0011P\u0004\r!\nU\u0004_!@\u000bH\u000fi\n\u000fPX";
                    n3 = 11;
                    continue block36;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u000bN\u0004Ca\u001d\bH\ni\n";
                    n3 = 12;
                    continue block36;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0011P\u0004\r!\nU\u0004_!@\u000bH\u000fi\n\fWV";
                    n3 = 13;
                    continue block36;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u000bN\u0004Ca\u001d\b";
                    n3 = 14;
                    continue block36;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u001dX\u0016Ca\u0018^";
                    n3 = 15;
                    continue block36;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "7H\t\u0002O\u0012N\u0010\u0003X\u0000M\u0000=x\u000bT\u000b\t";
                    n3 = 16;
                    continue block36;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = ":o&]>";
                    n3 = 17;
                    continue block36;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0011P\u0004\r!\nU\u0004_!\u001dX\u0016]";
                    n3 = 18;
                    continue block36;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = ";\\\u0001-g\nH\b:u\tX6\u001a~\u0010S\u0002";
                    n3 = 19;
                    continue block36;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\n\\\u0003\u000bS\u001aU\u0000\rg\nH\b1x\u0000M\u0000";
                    n3 = 20;
                    continue block36;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "C\u001d \u0016o\u001cM\u0011\u0007c\u0017\u001d\f\u0000,\u001eX\u0011\u001ae\u0017ZE\u001dm\u001fXE\ni\u001f\\\u0010\u0002xY^\r\u000bo\u0012N\u0010\u0003,\u000f\\\t\u001biY[\u0017\u0001aYI\r\u000b,\u001aR\u000b\be\u001eH\u0017\u000fx\u0010R\u000bN_\u001cI\u0011\u0007b\u001e\u001dE cYN\u0004\biYY\u0000\bm\fQ\u0011No\u0011X\u0006\u0005\u007f\fPE\u001di\r\u0013";
                    n3 = 21;
                    continue block36;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = ":U\u0000\rg\nH\bT";
                    n3 = 22;
                    continue block36;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = ":U\u0000\rg\nH\bT";
                    n3 = 23;
                    continue block36;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "\u0015T\u0007\ni\u001f\\\u0010\u0002x\n";
                    n3 = 24;
                    continue block36;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "\u001dX\u0003\u000fy\u0015I:\rd\u001c^\u000e\u001dy\u0014";
                    n3 = 25;
                    continue block36;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "\u0015T\u0007\ni\u001f\\\u0010\u0002x\n";
                    n3 = 26;
                    continue block36;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "C\u001d \u0016o\u001cM\u0011\u0007c\u0017\u001d\f\u0000,\u001eX\u0011\u001ae\u0017ZE\ni\u001f\\\u0010\u0002xY^\r\u000bo\u0012N\u0010\u0003,\u000f\\\t\u001biY[\u0017\u0001aYI\r\u000b,\u001aR\u000b\be\u001eH\u0017\u000fx\u0010R\u000bNB\u0016\u001d\u0001\u000bj\u0018H\t\u001a,\u001aU\u0000\rg\nH\bN\u007f\u001cIK";
                    n3 = 27;
                    continue block36;
                }
                case 27: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        c = new int[]{7, 8, 4, 5, 1, -138, 12, 15, 16};
        Checksum.initStatic();
    }
}

