/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import com.ibm.xtq.xslt.jaxp.DefaultErrorListener;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private XPath m_xpath = null;
    private PrefixResolver m_prefixResolver = null;
    private boolean m_isSecureProcessing = false;
    private static final String CLASS_NAME = "XPathExpressionImpl";
    private static ErrorListener m_errorL = new DefaultErrorListener();

    protected XPathExpressionImpl(XPath xPath, PrefixResolver prefixResolver, boolean bl) {
        this.m_xpath = xPath;
        this.m_prefixResolver = prefixResolver;
        this.m_isSecureProcessing = bl;
    }

    @Override
    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        XPathContext xPathContext = new XPathContext(false);
        if (this.m_isSecureProcessing) {
            xPathContext.setSecureProcessing(true);
        }
        int n = XPathExpressionImpl.getContextNodeHandle(object, xPathContext);
        try {
            XObject xObject = this.m_xpath.execute(xPathContext, n, this.m_prefixResolver);
            return XPathExpressionImpl.xObjectToObject(xObject, qName);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathExpressionException) {
                throw (XPathExpressionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    @Override
    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (inputSource == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_INPUT_SOURCE", null));
        }
        Document document = null;
        DocumentBuilder documentBuilder = null;
        String string = null;
        try {
            string = System.getProperty("javax.xml.accessExternalDTD");
            documentBuilder = string == null ? XPathExpressionImpl.getDocumentBuilder(this.m_isSecureProcessing) : XPathExpressionImpl.getDocumentBuilder(this.m_isSecureProcessing, string);
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new XPathExpressionException(exception);
        }
        return this.evaluate(document, qName);
    }

    @Override
    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    private static int getContextNodeHandle(Object object, XPathContext xPathContext) throws XPathExpressionException {
        Node node = null;
        if (object == null) {
            try {
                node = XPathExpressionImpl.getDocumentBuilder(xPathContext.isSecureProcessing()).newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XPathExpressionException(parserConfigurationException);
            }
        } else if (object instanceof Node) {
            node = (Node)object;
        } else if (object instanceof NodeList) {
            node = ((NodeList)object).item(0);
        } else if (object instanceof NodeIterator) {
            node = ((NodeIterator)object).nextNode();
        } else {
            throw new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_CONTEXT_ITEM", new Object[]{object}));
        }
        return xPathContext.getDTMHandleFromNode(node);
    }

    private static DocumentBuilder getDocumentBuilder(boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        if (bl) {
            try {
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                try {
                    XPathExpressionImpl.warning(new TransformerConfigurationException(XPATHMessages.createXPATHMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{documentBuilderFactory.getClass(), "http://javax.xml.XMLConstants/feature/secure-processing", true}), parserConfigurationException));
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException);
                }
            }
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    private static DocumentBuilder getDocumentBuilder(boolean bl, String string) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory;
        block11: {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            try {
                if (bl) {
                    documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                try {
                    documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().contains("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
                        if ("".equals(string)) {
                            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        } else if (!"all".equalsIgnoreCase(string)) {
                            String string2 = XSLMessages.createXPATHMessage("ERR_PROPERTY_UNKNOWN_VALUE", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", CLASS_NAME, string});
                            throw new IllegalArgumentException(string2);
                        }
                        break block11;
                    }
                    throw illegalArgumentException;
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                try {
                    XPathExpressionImpl.warning(new TransformerConfigurationException(XPATHMessages.createXPATHMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{documentBuilderFactory.getClass(), "http://javax.xml.XMLConstants/feature/secure-processing", true}), parserConfigurationException));
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException);
                }
            }
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    private static Object xObjectToObject(XObject xObject, QName qName) throws TransformerException {
        if (qName == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_RETURN_TYPE", null));
        }
        if (qName.equals(XPathConstants.STRING)) {
            return xObject.str();
        }
        if (qName.equals(XPathConstants.NUMBER)) {
            return new Double(xObject.num());
        }
        if (qName.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(xObject.bool());
        }
        if (qName.equals(XPathConstants.NODESET)) {
            return xObject.nodelist();
        }
        if (qName.equals(XPathConstants.NODE)) {
            return xObject.nodeset().nextNode();
        }
        throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_INVALID_XPATH_RETURN_TYPE", new Object[]{qName}));
    }

    public static void warning(TransformerException transformerException) throws TransformerException {
        m_errorL.warning(transformerException);
    }

    public static void error(TransformerException transformerException) throws TransformerException {
        m_errorL.error(transformerException);
    }

    public static void fatalError(TransformerException transformerException) throws TransformerException {
        m_errorL.fatalError(transformerException);
        throw transformerException;
    }
}

