/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class UnionChildIterator
extends ChildTestIterator {
    static final long serialVersionUID = 3500298482193003495L;
    private PredicatedNodeTest[] m_nodeTests = null;

    public UnionChildIterator() {
        super((DTMAxisTraverser)null);
    }

    public void addNodeTest(PredicatedNodeTest predicatedNodeTest) {
        if (null == this.m_nodeTests) {
            this.m_nodeTests = new PredicatedNodeTest[1];
            this.m_nodeTests[0] = predicatedNodeTest;
        } else {
            PredicatedNodeTest[] predicatedNodeTestArray = this.m_nodeTests;
            int n = this.m_nodeTests.length;
            this.m_nodeTests = new PredicatedNodeTest[n + 1];
            System.arraycopy(predicatedNodeTestArray, 0, this.m_nodeTests, 0, n);
            this.m_nodeTests[n] = predicatedNodeTest;
        }
        predicatedNodeTest.exprSetParent(this);
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (this.m_nodeTests != null) {
            for (int i = 0; i < this.m_nodeTests.length; ++i) {
                this.m_nodeTests[i].fixupVariables(vector, n);
            }
        }
    }

    @Override
    public short acceptNode(int n) {
        XPathContext xPathContext = this.getXPathContext();
        try {
            xPathContext.pushCurrentNode(n);
            for (int i = 0; i < this.m_nodeTests.length; ++i) {
                PredicatedNodeTest predicatedNodeTest = this.m_nodeTests[i];
                XObject xObject = predicatedNodeTest.execute(xPathContext, n);
                if (xObject == NodeTest.SCORE_NONE) continue;
                if (predicatedNodeTest.getPredicateCount() > 0) {
                    if (!predicatedNodeTest.executePredicates(n, xPathContext)) continue;
                    short s = 1;
                    return s;
                }
                short s = 1;
                return s;
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        finally {
            xPathContext.popCurrentNode();
        }
        return 3;
    }
}

