/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessorStylesheetElement
extends XSLTElementProcessor {
    static final long serialVersionUID = -877798927447840792L;

    @Override
    public void startElement(StylesheetHandler stylesheetHandler, String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(stylesheetHandler, string, string2, string3, attributes);
        try {
            Stylesheet stylesheet;
            int n = stylesheetHandler.getStylesheetType();
            if (n == 1) {
                try {
                    stylesheet = this.getStylesheetRoot(stylesheetHandler);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new TransformerException(transformerConfigurationException);
                }
            } else {
                Stylesheet stylesheet2 = stylesheetHandler.getStylesheet();
                if (n == 3) {
                    StylesheetComposed stylesheetComposed = new StylesheetComposed(stylesheet2);
                    stylesheet2.setImport(stylesheetComposed);
                    stylesheet = stylesheetComposed;
                } else {
                    stylesheet = new Stylesheet(stylesheet2);
                    stylesheet2.setInclude(stylesheet);
                }
            }
            stylesheet.setDOMBackPointer(stylesheetHandler.getOriginatingNode());
            stylesheet.setLocaterInfo(stylesheetHandler.getLocator());
            stylesheet.setPrefixes(stylesheetHandler.getNamespaceSupport());
            stylesheetHandler.pushStylesheet(stylesheet);
            this.setPropertiesFromAttributes(stylesheetHandler, string3, attributes, stylesheetHandler.getStylesheet());
            stylesheetHandler.pushElemTemplateElement(stylesheetHandler.getStylesheet());
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    protected Stylesheet getStylesheetRoot(StylesheetHandler stylesheetHandler) throws TransformerConfigurationException {
        StylesheetRoot stylesheetRoot = new StylesheetRoot(stylesheetHandler.getSchema(), stylesheetHandler.getStylesheetProcessor().getErrorListener());
        if (stylesheetHandler.getStylesheetProcessor().isSecureProcessing()) {
            stylesheetRoot.setSecureProcessing(true);
        }
        stylesheetRoot.setStylesheetProtocolValidator(stylesheetHandler.getStylesheetProcessor().getStylesheetProtocolValidator());
        stylesheetRoot.setAllowedDTDProtocols(stylesheetHandler.getStylesheetProcessor().getAllowedDTDProtocols());
        stylesheetRoot.setXMLLimitManager(stylesheetHandler.getStylesheetProcessor().getXMLLimitManager());
        return stylesheetRoot;
    }

    @Override
    public void endElement(StylesheetHandler stylesheetHandler, String string, String string2, String string3) throws SAXException {
        super.endElement(stylesheetHandler, string, string2, string3);
        stylesheetHandler.popElemTemplateElement();
        stylesheetHandler.popStylesheet();
    }
}

