/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import javax.xml.validation.SecuritySupport;

final class SchemaFactoryFinder {
    private static boolean debug;
    private static Properties jaxpProperties;
    private static long lastModified;

    private SchemaFactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2, String string3) {
        Object object;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = SchemaFactoryFinder.class.getClassLoader();
        }
        String string4 = string + ":" + string2;
        if (debug) {
            SchemaFactoryFinder.dPrint("find factoryId=" + string4);
        }
        try {
            String string5 = SecuritySupport.getSystemProperty(string4);
            if (string5 != null) {
                if (debug) {
                    SchemaFactoryFinder.dPrint("found system property, value=" + string5);
                }
                return SchemaFactoryFinder.newInstance(string5, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean bl = false;
        File file = null;
        try {
            object = SecuritySupport.getSystemProperty("java.home");
            String string6 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            file = new File(string6);
            bl = SecuritySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            jaxpProperties = null;
        }
        object = SchemaFactoryFinder.class;
        synchronized (SchemaFactoryFinder.class) {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = SecuritySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        jaxpProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = SecuritySupport.getLastModified(file);
                }
                if (bl2) {
                    jaxpProperties = new Properties();
                    fileInputStream = SecuritySupport.getFileInputStream(file);
                    jaxpProperties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            if (jaxpProperties != null && (object = jaxpProperties.getProperty(string4)) != null) {
                if (debug) {
                    SchemaFactoryFinder.dPrint("found in jaxp.properties, value=" + (String)object);
                }
                return SchemaFactoryFinder.newInstance((String)object, classLoader, true);
            }
            object = SchemaFactoryFinder.findServiceProvider(string2);
            if (object != null) {
                if (debug) {
                    SchemaFactoryFinder.dPrint("found service provider by ServiceLoader, value=" + object.getClass().getName());
                }
                return object;
            }
            if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
                if (debug) {
                    SchemaFactoryFinder.dPrint("using fallback, value=" + string3);
                }
                return SchemaFactoryFinder.newInstance(string3, classLoader, true);
            }
            throw new IllegalArgumentException("No SchemaFactory implementation for the schema language:" + string2 + " is available.");
        }
    }

    private static void dPrint(String string) {
        System.err.println("JAXP: " + string);
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        block12: {
            try {
                Class<?> clazz;
                Object object;
                int n;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                    object = string.substring(0, n);
                    securityManager.checkPackageAccess((String)object);
                }
                if (classLoader == null) {
                    clazz = Class.forName(string);
                } else {
                    clazz = classLoader.loadClass(string);
                }
                object = clazz.newInstance();
                if (debug) {
                    SchemaFactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
                }
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
                }
                if (debug) {
                    SchemaFactoryFinder.dPrint("Provider " + string + " not found");
                }
            }
            catch (Exception exception) {
                if (bl) {
                    throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
                }
                if (!debug) break block12;
                SchemaFactoryFinder.dPrint("Provider " + string + " could not be instantiated: " + exception);
            }
        }
        return null;
    }

    private static Object findServiceProvider(String string) throws ConfigurationError, SchemaFactoryConfigurationError {
        Class<SchemaFactory> clazz = SchemaFactory.class;
        ServiceLoader<SchemaFactory> serviceLoader = ServiceLoader.load(clazz, SecuritySupport.getContextClassLoader());
        Iterator<SchemaFactory> iterator = serviceLoader.iterator();
        try {
            while (iterator.hasNext()) {
                SchemaFactory schemaFactory = iterator.next();
                if (!schemaFactory.isSchemaLanguageSupported(string)) continue;
                return schemaFactory;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + runtimeException, runtimeException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new SchemaFactoryConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + serviceConfigurationError, serviceConfigurationError);
        }
        return null;
    }

    static {
        jaxpProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = 3546360626067682354L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

