/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.ExceptionConstants;
import com.ibm.xtq.bcel.classfile.Constant;
import com.ibm.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xtq.bcel.classfile.ConstantString;
import com.ibm.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xtq.bcel.generic.CPInstruction;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xtq.bcel.generic.PushInstruction;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.TypeConstants;
import com.ibm.xtq.bcel.generic.TypedInstruction;
import com.ibm.xtq.bcel.generic.Visitor;
import com.ibm.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower,
TypedInstruction {
    LDC() {
    }

    public LDC(int index) {
        super((short)19, index);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        if (this.length == 2) {
            out.writeByte(this.index);
        } else {
            out.writeShort(this.index);
        }
    }

    public final void setIndex(int index) {
        super.setIndex(index);
        this.setSize();
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)2;
        this.index = bytes.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen cpg) {
        Constant c = cpg.getConstantPool().getConstant(this.index);
        switch (c.getTag()) {
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = cpg.getConstantPool().getConstant(i);
                return ((ConstantUtf8)c).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)c).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)c).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Type getType(ConstantPoolGen cpg) {
        switch (cpg.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return TypeConstants.STRING;
            }
            case 4: {
                return TypeConstants.FLOAT;
            }
            case 3: {
                return TypeConstants.INT;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public void accept(Visitor v) {
        v.visitStackProducer(this);
        v.visitPushInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitLDC(this);
    }
}

