/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.jaxp.util.ExternalResourceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public final class URI {
    private String fScheme = "";
    private String fAuthority;
    private String fPath = "";
    private String fQuery;
    private String fFragment;
    private URI fBaseURI;
    private char[] fChars;
    private static final boolean WORKAROUND_JIT_BUG = true;
    private static final boolean JAXP15_SUPPORT = ExternalResourceHelper.isSupportAvailable();
    private static final byte[] fgSchemeCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] fgURICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 2, 0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final byte[] fgHexCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public boolean parse(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.parseURI(string, true);
    }

    public boolean parse(URI uRI, String string) {
        if (uRI == null || string == null) {
            return false;
        }
        if (!this.parseURI(string, false)) {
            return false;
        }
        if (this.fScheme.length() == 0) {
            this.resolveRelativeTo(uRI);
        }
        return true;
    }

    private boolean parseURI(String string, boolean bl) {
        int n;
        int n2 = 47;
        int n3 = string.length();
        int n4 = n;
        this.fScheme = "";
        this.fAuthority = null;
        this.fPath = "";
        this.fQuery = null;
        this.fFragment = null;
        for (n = 0; n < n3; ++n) {
            n2 = string.charAt(n);
            if (n2 != 58) {
                if (n2 != 47 && n2 != 63 && n2 != 35) {
                    continue;
                }
                n = n4;
                n2 = string.charAt(n);
                break;
            }
            if (n <= n4) break;
            this.fScheme = string.substring(n4, n);
            if (this.parseScheme()) {
                if (++n < n3) {
                    n4 = n;
                    n2 = string.charAt(n);
                    break;
                }
                this.fPath = "";
                return URI.checkComponent(this.fPath, false, true);
            }
            return false;
        }
        if (bl && this.fScheme.length() == 0) {
            return false;
        }
        if (n + 1 < n3 && n2 == 47 && string.charAt(n + 1) == '/') {
            n4 = n += 2;
            while (n < n3 && (n2 = (int)string.charAt(n)) != 47 && n2 != 63 && n2 != 35) {
                ++n;
            }
            this.fAuthority = string.substring(n4, n);
            if (!URI.checkComponent(this.fAuthority, true, true)) {
                return false;
            }
            n4 = n;
        }
        while (n < n3 && (n2 = (int)string.charAt(n)) != 63 && n2 != 35) {
            ++n;
        }
        this.fPath = string.substring(n4, n);
        if (!URI.checkComponent(this.fPath, false, true)) {
            return false;
        }
        if (n2 == 63) {
            n4 = ++n;
            while (n < n3 && (n2 = (int)string.charAt(n)) != 35) {
                ++n;
            }
            this.fQuery = string.substring(n4, n);
            if (!URI.checkComponent(this.fQuery, false, false)) {
                return false;
            }
        }
        if (n2 == 35) {
            n4 = ++n;
            while (n < n3 && (n2 = (int)string.charAt(n)) != 35) {
                ++n;
            }
            this.fFragment = string.substring(n4, n);
            if (!URI.checkComponent(this.fFragment, false, false)) {
                return false;
            }
        }
        return true;
    }

    private void resolveRelativeTo(URI uRI) {
        int n;
        char c;
        int n2;
        int n3;
        int n4;
        block16: {
            int n5;
            this.fScheme = uRI.fScheme;
            if (this.fAuthority != null) {
                return;
            }
            if (uRI.fAuthority != null) {
                this.fAuthority = uRI.fAuthority;
            }
            if ((n5 = this.fPath.length()) == 0 && this.fQuery == null) {
                this.fPath = uRI.fPath;
                uRI.fQuery = null;
                if (this.fFragment == null && uRI.fFragment != null) {
                    this.fFragment = uRI.fFragment;
                }
                return;
            }
            if (n5 > 0 && this.fPath.charAt(0) == '/') {
                return;
            }
            String string = uRI.fPath;
            n4 = string.length() + n5;
            if (this.fChars == null || n4 > this.fChars.length) {
                int n6;
                int n7 = n6 = this.fChars != null ? this.fChars.length << 1 : 32;
                while (n4 > n6) {
                    n6 <<= 1;
                }
                this.fChars = new char[n6];
            }
            string.getChars(0, n4, this.fChars, 0);
            for (n4 = string.length(); n4 > 0 && this.fChars[n4 - 1] != '/'; --n4) {
            }
            if (n4 == 0) {
                n4 = string.length();
            }
            this.fPath.getChars(0, n5, this.fChars, n4);
            n4 += n5;
            n3 = 0;
            n2 = 0;
            while (n3 < n4) {
                c = this.fChars[n3];
                if (c != '/' || ++n3 + 1 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '/') continue;
                n2 = n3;
                n3 += 2;
                while (n3 < n4) {
                    c = this.fChars[n3];
                    this.fChars[n2] = c;
                    ++n2;
                    if (c != '/' || ++n3 + 1 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '/') continue;
                    n3 += 2;
                }
                break block16;
            }
            n2 = n3;
        }
        if (n2 > 1 && this.fChars[n2 - 1] == '.' && this.fChars[n2 - 2] == '/') {
            --n2;
        }
        n4 = n2;
        n3 = 0;
        n2 = 0;
        while (n3 < n4) {
            c = this.fChars[n3];
            this.fChars[n2] = c;
            if (c != '/' || ++n2 == 1 || ++n3 + 2 >= n4 || this.fChars[n3] != '.' || this.fChars[n3 + 1] != '.' || this.fChars[n3 + 2] != '/' || (n = n2 - 4) >= 0 && this.fChars[n] == '/' && this.fChars[n + 1] == '.' && this.fChars[n + 2] == '.') continue;
            n3 += 2;
            while (--n2 > 0 && this.fChars[n2 - 1] != '/') {
            }
            if (n2 <= 0 || this.fChars[n2 - 1] != '/') continue;
            --n2;
        }
        n4 = n2;
        n = n2 - 3;
        if (n >= 0 && this.fChars[n] == '/' && this.fChars[n + 1] == '.' && this.fChars[n + 2] == '.' && ((n -= 3) < 0 || this.fChars[n] != '/' || this.fChars[n + 1] != '.' || this.fChars[n + 2] != '.')) {
            n2 -= 3;
            while (n2 > 0 && this.fChars[n2 - 1] != '/') {
                --n2;
            }
        }
        n4 = n2;
        this.fPath = new String(this.fChars, 0, n4);
    }

    private boolean parseScheme() {
        String string = this.fScheme;
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        if (n == 0) {
            return false;
        }
        char c = string.charAt(n2);
        if (c >= '\u0080' || fgSchemeCharMap[c] != 1) {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            bl = true;
        }
        while (++n2 < n) {
            c = string.charAt(n2);
            if (c >= '\u0080' || fgSchemeCharMap[c] == 0) {
                return false;
            }
            if (c < 'A' || c > 'Z') continue;
            bl = true;
        }
        if (bl) {
            this.fScheme = string.toLowerCase(Locale.ENGLISH);
        }
        return true;
    }

    private static boolean checkComponent(String string, boolean bl, boolean bl2) {
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                return false;
            }
            switch (fgURICharMap[c]) {
                case 1: {
                    continue block5;
                }
                case 2: {
                    if ((!bl || c != '/') && (!bl2 || c != '?')) continue block5;
                    return false;
                }
                case 3: {
                    if (i + 2 >= n) {
                        return false;
                    }
                    if ((c = string.charAt(++i)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return false;
                    }
                    if ((c = string.charAt(++i)) < '\u0080' && fgHexCharMap[c] != 0) continue block5;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fScheme.length() > 0) {
            stringBuffer.append(this.fScheme);
            stringBuffer.append(':');
        }
        if (this.fAuthority != null) {
            stringBuffer.append('/');
            stringBuffer.append('/');
            stringBuffer.append(this.fAuthority);
        }
        stringBuffer.append(this.fPath);
        if (this.fQuery != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.fQuery);
        }
        if (this.fFragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fFragment);
        }
        return stringBuffer.toString();
    }

    public String expand(String string, String string2) {
        Object object;
        if (JAXP15_SUPPORT && (object = URIHelper.expandURI(string, string2)) != null) {
            return object;
        }
        if (!this.parse(string)) {
            object = this.fBaseURI;
            if (object == null) {
                this.fBaseURI = new URI();
                object = this.fBaseURI;
            }
            if (((URI)object).parse(string2) && this.parse((URI)object, string)) {
                return this.toString();
            }
        }
        return string;
    }

    public static InputStream openStream(String string) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!JAXP15_SUPPORT) {
                throw malformedURLException;
            }
            if ((string = URIHelper.fixupURI(string)) == null) {
                throw malformedURLException;
            }
            uRL = new URL(string);
        }
        return uRL.openStream();
    }

    static final class URIHelper {
        private static Method fgXMLEntityManagerExpandSystemIdMethod = null;
        private static boolean fgXMLEntityManagerMethodsAvailable = false;

        private URIHelper() {
        }

        public static String expandURI(String string, String string2) {
            if (fgXMLEntityManagerMethodsAvailable) {
                try {
                    Object object = fgXMLEntityManagerExpandSystemIdMethod.invoke(null, string, string2, Boolean.FALSE);
                    if (object instanceof String) {
                        return (String)object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public static String fixupURI(String string) {
            if (fgXMLEntityManagerMethodsAvailable) {
                try {
                    Object object = fgXMLEntityManagerExpandSystemIdMethod.invoke(null, string, null, Boolean.FALSE);
                    if (object instanceof String) {
                        return (String)object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            try {
                Class<?> clazz = Class.forName("org.apache.xerces.impl.XMLEntityManager");
                fgXMLEntityManagerExpandSystemIdMethod = clazz.getMethod("expandSystemId", String.class, String.class, Boolean.TYPE);
                fgXMLEntityManagerMethodsAvailable = true;
            }
            catch (Exception exception) {
                fgXMLEntityManagerExpandSystemIdMethod = null;
                fgXMLEntityManagerMethodsAvailable = false;
            }
        }
    }
}

