/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ImmutableArrayList
extends AbstractList {
    private final Object[] fArray;
    private final int fLength;

    public ImmutableArrayList(Object[] objectArray, int n) {
        this.fArray = objectArray;
        this.fLength = n;
    }

    @Override
    public boolean contains(Object object) {
        return object == null ? this.containsNull() : this.containsObject(object);
    }

    @Override
    public Object get(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fArray[n];
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    @Override
    public Iterator iterator() {
        return new ImmutableArrayListIterator();
    }

    @Override
    public int size() {
        return this.fLength;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.fLength];
        if (this.fLength > 0) {
            System.arraycopy(this.fArray, 0, objectArray, 0, this.fLength);
        }
        return objectArray;
    }

    private boolean containsObject(Object object) {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (!object.equals(this.fArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean containsNull() {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (this.fArray[i] != null) continue;
            return true;
        }
        return false;
    }

    private final class ImmutableArrayListIterator
    implements Iterator {
        int index = 0;

        private ImmutableArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ImmutableArrayList.this.fLength;
        }

        public Object next() {
            if (this.index < ImmutableArrayList.this.fLength) {
                return ImmutableArrayList.this.fArray[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

