/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.util.Pool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

abstract class StAXWriter
extends Writer
implements Pool.Poolable {
    protected OutputStream fStream;
    protected int fNumBytes;
    protected final byte[] fBuffer = new byte[65536];
    protected Pool.PoolableHelper fPoolableHelper;
    protected char[] fCharBuffer = new char[128];

    public StAXWriter() {
        this.fPoolableHelper = new Pool.PoolableHelper(this);
    }

    @Override
    public Pool.PoolableHelper getPoolableHelper() {
        return this.fPoolableHelper;
    }

    public void reset(OutputStream outputStream) {
        this.fNumBytes = 0;
        this.fStream = outputStream;
    }

    @Override
    public void write(String string) throws IOException {
        int n = string.length();
        if (this.fCharBuffer.length < n) {
            this.fCharBuffer = new char[n * 2];
        }
        string.getChars(0, n, this.fCharBuffer, 0);
        this.write(this.fCharBuffer, 0, n);
    }

    protected void flushInternal() throws IOException {
        this.fStream.write(this.fBuffer, 0, this.fNumBytes);
        this.fNumBytes = 0;
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal();
        this.fStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.fStream = null;
        this.release();
    }

    protected void release() {
        this.fPoolableHelper.returnToPool();
    }
}

