/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.OpenedSessionList;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionQueue;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.PKCS11TokenInfo;
import java.util.Hashtable;
import java.util.Iterator;

public class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private PKCS11Slot tokenSlot;
    private SessionQueue opSessionQueue;
    private SessionQueue objSessionQueue;
    private int openSessionFlags;
    private int maxSessionCount;
    private int sessionCount;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static Debug debugKeyCleanup = Debug.getInstance((String)"keycleanup");
    private static Hashtable managerTable = new Hashtable(1);
    protected static Integer objectUsedForGetReleaseSynchronization = new Integer(0);
    protected static Integer objectUsedForOpenCloseSynchronization = new Integer(0);
    protected static final Object synchObj = new Object();
    protected static int totalOpenHardwareSessions = 0;
    protected static int totalOpenHardwareSessions2 = 0;
    protected static int totalOpenHardwareSessions3 = 0;
    protected static int totalOpenHardwareSessions4 = 0;
    protected static int totalOpenHardwareSessionsExperimental = 0;
    protected static OpenedSessionList openedSessionList = null;

    SessionManager(PKCS11Slot tokenSlot) throws PKCS11Exception {
        int maxCount;
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)");
        }
        openedSessionList = new OpenedSessionList();
        this.tokenSlot = tokenSlot;
        this.opSessionQueue = new SessionQueue();
        this.objSessionQueue = new SessionQueue();
        PKCS11TokenInfo token = tokenSlot.getTokenInfo();
        int flags = token.flags();
        if ((flags & 2) != 0) {
            maxCount = token.maxSessionCount();
            this.openSessionFlags = 4;
        } else {
            maxCount = token.maxRwSessionCount();
            this.openSessionFlags = 6;
        }
        if (maxCount == 0) {
            this.maxSessionCount = Integer.MAX_VALUE;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count is infinite");
            }
        } else if (maxCount < 0) {
            this.maxSessionCount = 32;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count is not available");
            }
        } else {
            this.maxSessionCount = maxCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count=" + maxCount);
            }
        }
        this.openOpSession();
        managerTable.put(tokenSlot, this);
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)");
        }
    }

    public static SessionManager getInstance(PKCS11Slot tokenSlot) {
        SessionManager temp = null;
        temp = (SessionManager)managerTable.get(tokenSlot);
        if (temp != null) {
            return temp;
        }
        return new SessionManager(tokenSlot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getOpSession() throws PKCS11Exception {
        Integer n = objectUsedForGetReleaseSynchronization;
        synchronized (n) {
            if (debug != null) {
                debug.entry(16384L, (Object)"SessionManager", "getOpSession()");
            }
            if (this.opSessionQueue.isEmpty()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getOpSession", "opSession queue is empty");
                }
                if (this.sessionCount < this.maxSessionCount) {
                    this.openOpSession();
                    Session sess = this.opSessionQueue.poll();
                    --this.sessionCount;
                    if (debug != null) {
                        debug.text(16384L, (Object)"SessionManager", "getOpSession()", "session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                        debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
                    }
                    if (debugSessionObjectCount != null) {
                        this.whoReceivedThisSession(sess);
                    }
                    sess.isThisSessionAssociatedWithAKey = false;
                    return sess;
                }
                Session sess = this.objSessionQueue.poll();
                if (sess != null) {
                    --this.sessionCount;
                    if (debug != null) {
                        debug.text(16384L, (Object)"SessionManager", "getOpSession()", "get ObjSession, session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                        debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
                    }
                    if (debugSessionObjectCount != null) {
                        this.whoReceivedThisSession(sess);
                    }
                    sess.isThisSessionAssociatedWithAKey = false;
                    return sess;
                }
                throw new PKCS11Exception("number of active sessions reached the max");
            }
            Session sess = this.opSessionQueue.poll();
            --this.sessionCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "getOpSession()", "session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
            }
            if (debugSessionObjectCount != null) {
                this.whoReceivedThisSession(sess);
            }
            sess.isThisSessionAssociatedWithAKey = false;
            return sess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getObjSession() throws PKCS11Exception {
        Integer n = objectUsedForGetReleaseSynchronization;
        synchronized (n) {
            if (debug != null) {
                debug.entry(16384L, (Object)"SessionManager", "getObjSession");
            }
            if (this.objSessionQueue.isEmpty()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getObjSession", "object session queue is empty");
                }
                if (this.sessionCount < this.maxSessionCount) {
                    this.openObjSession();
                    Session sess = this.objSessionQueue.poll();
                    --this.sessionCount;
                    if (debug != null) {
                        debug.text(16384L, (Object)"SessionManager", "getObjSession()", "obj session handle = " + sess.getID() + ", session count=" + this.sessionCount + ", session " + sess);
                        debug.exit(16384L, (Object)"SessionManager", "getObjSession()");
                    }
                    if (debugSessionObjectCount != null) {
                        this.whoReceivedThisSession(sess);
                    }
                    sess.isThisSessionAssociatedWithAKey = false;
                    return sess;
                }
                Session sess = this.opSessionQueue.poll();
                if (sess != null) {
                    --this.sessionCount;
                    if (debug != null) {
                        debug.text(16384L, (Object)"SessionManager", "getObjSession()", "get obj session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                        debug.exit(16384L, (Object)"SessionManager", "getObjSession");
                    }
                    if (debugSessionObjectCount != null) {
                        this.whoReceivedThisSession(sess);
                    }
                    sess.isThisSessionAssociatedWithAKey = false;
                    return sess;
                }
                throw new PKCS11Exception("number of active sessions reached the max");
            }
            Session sess = this.objSessionQueue.poll();
            --this.sessionCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "getObjSession()", "get obj session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                debug.exit(16384L, (Object)"SessionManager", "getObjSession");
            }
            if (debugSessionObjectCount != null) {
                this.whoReceivedThisSession(sess);
            }
            sess.isThisSessionAssociatedWithAKey = false;
            return sess;
        }
    }

    private void openOpSession() throws PKCS11Exception {
        this.openSession(false);
    }

    private void openObjSession() throws PKCS11Exception {
        this.openSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSession(boolean objSession) throws PKCS11Exception {
        Integer n = objectUsedForOpenCloseSynchronization;
        synchronized (n) {
            PKCS11Session pkcs11Session;
            block16: {
                if (this.sessionCount >= this.maxSessionCount) {
                    throw new PKCS11Exception("No more sessions available");
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "openSession", "object session ? " + objSession);
                }
                pkcs11Session = null;
                try {
                    pkcs11Session = this.tokenSlot.openSession(this.openSessionFlags, null, null);
                }
                catch (PKCS11Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)"SessionManager", "openOpSession", (Throwable)e);
                    }
                    if (e.getCode() != 226) break block16;
                    pkcs11Session = this.tokenSlot.openSession(4, null, null);
                }
            }
            if (pkcs11Session != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "openSession(boolean)", "open new session handle = " + pkcs11Session.getID());
                }
                ++this.sessionCount;
                Session newSession = null;
                if (objSession) {
                    newSession = new Session(this, pkcs11Session, objSession);
                    this.objSessionQueue.add(newSession);
                } else {
                    newSession = new Session(this, pkcs11Session, false);
                    this.opSessionQueue.add(newSession);
                }
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    ++totalOpenHardwareSessions;
                    ++totalOpenHardwareSessions2;
                    ++totalOpenHardwareSessions3;
                    ++totalOpenHardwareSessions4;
                    openedSessionList.add(newSession);
                    this.printSessionStats();
                }
            } else if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "openSession", "tokenSlot.openSession returns null");
            }
            if (debugSessionObjectCount != null) {
                System.out.println("====================================================================================================");
                System.out.println("SessionManager.java:  openSession():  A new session was just created.");
                this.printSessionStats();
                System.out.println("====================================================================================================");
            }
        }
    }

    public PKCS11TokenInfo getToken() {
        return this.tokenSlot.getTokenInfo();
    }

    public PKCS11Slot getTokenSlot() {
        return this.tokenSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSession(Session session) {
        Integer n = objectUsedForGetReleaseSynchronization;
        synchronized (n) {
            if (debug != null) {
                debug.entry(16384L, (Object)"SessionManager", "releaseSession");
                debug.text(16384L, (Object)"SessionManager", "releaseSession", "release session handle = " + session.getID() + ", session " + session);
            }
            if (debugSessionObjectCount != null) {
                this.whoReturnedThisSession(session);
            }
            if ((debugKeyCleanup != null || debugSessionObjectCount != null) && session.session == null) {
                System.out.println("SessionManager.java:  releaseSession():  Error:  Attempting to release a Session that contains a NULL hardware session.  EXITING.");
                this.whoReturnedThisSession(session);
            }
            long time = System.currentTimeMillis();
            session.setAccessTime(time);
            if (session.hasObjects()) {
                this.objSessionQueue.add(session);
                ++this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "releaseSession", "session has object, session count = " + this.sessionCount);
                }
            } else {
                this.opSessionQueue.add(session);
                session.setObjSession(false);
                ++this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "releaseSession", "session count = " + this.sessionCount);
                }
                if (this.opSessionQueue.size() > 5 && this.opSessionQueue.cleanup(time)) {
                    --this.sessionCount;
                    if (debug != null) {
                        debug.text(16384L, (Object)"SessionManager", "releaseSession", "session count = " + this.sessionCount);
                    }
                }
            }
            if (debug != null) {
                debug.exit(16384L, (Object)"SessionManager", "releaseSession");
            }
        }
    }

    public synchronized void releaseSessionAndObj(Session session) {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "releaseSessionAndObj");
            debug.text(16384L, (Object)"SessionManager", "releaseSessionAndObj", "release session handle = " + session.getID());
        }
        if ((debugKeyCleanup != null || debugSessionObjectCount != null) && session.session == null) {
            System.out.println("SessionManager.java:  releaseSessionAndObj():  Error:  Attempting to release a Session that contains a NULL hardware session.  EXITING.");
            this.whoReturnedThisSession(session);
        }
        long time = System.currentTimeMillis();
        session.setAccessTime(time);
        session.removeObject();
        if (!session.hasObjects()) {
            session.setObjSession(false);
            this.opSessionQueue.add(session);
            ++this.sessionCount;
            if (this.opSessionQueue.size() > 5 && this.opSessionQueue.cleanup(time)) {
                --this.sessionCount;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "releaseSessionAndObj");
        }
    }

    public synchronized void demoteObjSession(Session objSession) {
        boolean present;
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "demoteObjSession");
        }
        if ((debugKeyCleanup != null || debugSessionObjectCount != null) && objSession.session == null) {
            System.out.println("SessionManager.java:  demoteObjSession():  Error:  Attempting to demote an obj Session that contains a NULL hardware session.  EXITING.");
            this.whoReturnedThisSession(objSession);
        }
        if (!(present = this.objSessionQueue.remove(objSession))) {
            if (debugSessionObjectCount != null) {
                System.out.println("SessionManager.java:  demoteObjSession():  Session ID " + objSession.getID() + " was not present on the objSessionQueue.  Therefore, do nothing and return.");
            }
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "demoteObjSession", "session handle " + objSession.getID() + " not in queue");
                debug.exit(16384L, (Object)"SessionManager", "demoteObjSession");
            }
            return;
        }
        long time = System.currentTimeMillis();
        objSession.setAccessTime(time);
        objSession.setObjSession(false);
        if (debugSessionObjectCount != null) {
            System.out.println("SessionManager.java:  demoteObjSession():  Moving session ID " + objSession.getID() + " to the opSessionQueue");
        }
        this.opSessionQueue.add(objSession);
        if (this.opSessionQueue.size() > 5) {
            if (debugSessionObjectCount != null) {
                System.out.println("SessionManager.java:  demoteObjSession():  The size of the opSessionQueue is now GREATER THAN 5.  Is it time for cleanup ?");
            }
            if (this.opSessionQueue.cleanup(time)) {
                --this.sessionCount;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "demoteObjSession");
        }
    }

    public synchronized void closeSession(Session session) {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "closeSession");
            debug.text(16384L, (Object)"SessionManager", "closeSession", "close session handle = " + session.getID());
        }
        if (session != null) {
            session.close();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "closeSession");
        }
    }

    public synchronized void closeAllSessions() {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "closeAllSessions");
        }
        Iterator it = this.objSessionQueue.allSessions().iterator();
        while (it.hasNext()) {
            this.closeSession((Session)it.next());
        }
        this.objSessionQueue = new SessionQueue();
        it = this.opSessionQueue.allSessions().iterator();
        while (it.hasNext()) {
            this.closeSession((Session)it.next());
        }
        this.opSessionQueue = new SessionQueue();
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManger", "closeAllSessions");
        }
        if (debugSessionObjectCount != null) {
            System.out.println("====================================================================================================");
            System.out.println("SessionManager.java:  closeAllSessions():  The session queue sizes after provider cleanup are:");
            this.printSessionStats();
            System.out.println("====================================================================================================");
        }
    }

    protected void printSessionStats() {
        System.out.println("SessionManager.java:  printSessionStats():  number of sessions on opSessionQueue    = " + this.opSessionQueue.size());
        System.out.println("SessionManager.java:  printSessionStats():  number of sessions on objSessionQueue   = " + this.objSessionQueue.size());
    }

    protected void whoReceivedThisSession(Session session) throws PKCS11Exception {
        System.out.println("SessionManager.java:  whoReceivedThisSession():  Tell me who received session ID = " + session.getID());
        RuntimeException rtex = new RuntimeException();
        rtex.printStackTrace(System.out);
        int n = session.getObjectCount();
        if (n != 0) {
            System.out.println("SessionManager.java:  whoReceivedThisSession():  Error:  Session ID = " + session.getID() + " just handed out by SessionManager had a NON ZERO object count (" + n + ").");
        }
    }

    protected void whoReturnedThisSession(Session session) throws PKCS11Exception {
        System.out.println("SessionManager.java:  whoReturnedThisSession():  Tell me who returned session ID = " + session.getID());
        RuntimeException rtex = new RuntimeException();
        rtex.printStackTrace(System.out);
        int n = session.getObjectCount();
        if (n != 0) {
            System.out.println("SessionManager.java:  whoReturnedThisSession():  Error:  Session ID = " + session.getID() + " just returned to SessionManager had a NON ZERO object count (" + n + ").");
        }
    }
}

