/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.PKCS11TlsMasterSecretKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import com.ibm.pkcs11.CK_SSL3_RANDOM_DATA;
import com.ibm.pkcs11.CK_VERSION;
import com.ibm.pkcs11.PKCS11Object;
import ibm.security.internal.spec.TlsMasterSecretParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class PKCS11TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsMasterSecretGenerator";
    private SessionManager sessionManager = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder;
    private TlsMasterSecretParameterSpec spec;
    private GeneralKey generalKey;
    private Provider provider;
    private int version;
    private int mechanism;

    public PKCS11TlsMasterSecretGenerator(Provider provider, String algorithm, int mechanism) {
        IBMPKCS11Impl.verifyJceJar();
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException("TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec");
        }
        this.spec = (TlsMasterSecretParameterSpec)params;
        SecretKey secretKey = this.spec.getPremasterSecret();
        GeneralPKCS11KeyFactory factory = new GeneralPKCS11KeyFactory(this.provider, secretKey.getAlgorithm());
        SecretKey key = null;
        try {
            key = factory.engineTranslateKey(secretKey);
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineInit", "after translation, key from algorithm parameter spec is " + key);
            }
        }
        catch (InvalidKeyException ex) {
            if (debug == null) throw new InvalidAlgorithmParameterException(ex);
            debug.exception(16384L, (Object)className, "engineInit", (Throwable)ex);
            throw new InvalidAlgorithmParameterException(ex);
        }
        if (!(key instanceof GeneralKey)) {
            throw new InvalidAlgorithmParameterException("cannot covert to appropriate key from AlgorithmParameterSpec");
        }
        this.generalKey = (GeneralKey)key;
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        int major = this.spec.getMajorVersion();
        int minor = this.spec.getMinorVersion();
        if (major != 3) throw new InvalidAlgorithmParameterException("not a supported major version " + major);
        if (minor == 0) {
            if (this.mechanism == 881) return;
            throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
        }
        if (minor != 1) throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
        if (this.mechanism == 885) return;
        throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        CK_VERSION ckVersion = this.generalKey.getAlgorithm().equals("TlsRsaPremasterSecret") ? new CK_VERSION((byte)this.spec.getMajorVersion(), (byte)this.spec.getMinorVersion()) : null;
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        CK_SSL3_RANDOM_DATA random = new CK_SSL3_RANDOM_DATA(clientRandom, serverRandom);
        CK_SSL3_MASTER_KEY_DERIVE_PARAMS params = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS(random, ckVersion);
        HashMap<Integer, Object> attributes = new HashMap<Integer, Object>();
        if (this.config != null) {
            attributes.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.GENERIC_SECRET));
            attributes.put(353, 48);
        }
        attributes.put(0, PKCS11Object.SECRET_KEY);
        attributes.put(256, PKCS11Object.GENERIC_SECRET);
        attributes.put(353, 48);
        int[] secretKeyTypes = new int[attributes.size()];
        Object[] secretKeyValues = new Object[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            secretKeyTypes[i] = (Integer)entry.getKey();
            secretKeyValues[i] = entry.getValue();
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGenerateKey", "attrType=" + secretKeyTypes[i] + ", attrValue=" + secretKeyValues[i]);
            }
            ++i;
        }
        PKCS11Object generatedSecret = null;
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            generatedSecret = session.deriveKey(this.mechanism, params, this.generalKey.getObject(), secretKeyTypes, secretKeyValues);
            session.addObject();
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(ex);
        }
        int major = -1;
        int minor = -1;
        if (ckVersion != null) {
            major = params.version.getMajorVersion();
            minor = params.version.getMinorVersion();
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineGenerateKey", "major=" + major + ", minor=" + minor);
        }
        try {
            PKCS11TlsMasterSecretKey pKCS11TlsMasterSecretKey = new PKCS11TlsMasterSecretKey(session, generatedSecret, "TlsMasterSecret", major, minor);
            return pKCS11TlsMasterSecretKey;
        }
        catch (InvalidKeyException ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
            }
            SecretKey secretKey = null;
            return secretKey;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }
}

