/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PrivateKey
implements PKCS11PrivateKey,
DHPrivateKey,
Serializable {
    private static final long serialVersionUID = 3258417222417265719L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private int l = 0;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private PKCS11Object p11Object = null;
    private Boolean isToken = null;
    private Session session = null;
    private Object sessionID;
    private SessionManager sessionManager;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey";
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static Debug debugKeyCleanup = Debug.getInstance((String)"keycleanup");

    public DHPKCS11PrivateKey(BigInteger x, BigInteger p, BigInteger g, SessionManager sessionManager, Config config) throws InvalidKeyException {
        this.x = x;
        this.l = this.x.bitLength();
        this.p = p;
        this.g = g;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the private key");
        }
        this.sessionManager = sessionManager;
        this.importPrivateKeyIntoToken(sessionManager, config);
    }

    public DHPKCS11PrivateKey(PKCS11Object object, Session sess) throws InvalidKeyException {
        this.p11Object = object;
        try {
            byte[] keyvalue = null;
            keyvalue = (byte[])this.getAttrValue(sess, this.p11Object, 17);
            if (keyvalue != null) {
                this.x = new BigInteger(1, (byte[])this.getAttrValue(sess, this.p11Object, 17));
                this.l = this.x.bitLength();
                this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            }
            this.p = (BigInteger)this.getAttrValue(sess, this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(sess, this.p11Object, 306);
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
        this.sessionManager = sess.getSessionManager();
    }

    public DHPKCS11PrivateKey(byte[] encodedKey, SessionManager sessionManager, Config config) throws InvalidKeyException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedKey);
        try {
            DerValue val = new DerValue((InputStream)inStream);
            if (val.getTag() != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger parsedVersion = val.getData().getInteger();
            if (!parsedVersion.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + parsedVersion);
            }
            DerValue algid = val.getData().getDerValue();
            if (algid.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInStream = algid.toDerInputStream();
            ObjectIdentifier oid = derInStream.getOID();
            if (derInStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!oid.equals(ObjectIdentifier.newInternal((int[])this.DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue params = derInStream.getDerValue();
            if (params.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (params.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            params.getData().reset();
            this.p = params.getData().getInteger();
            this.g = params.getData().getInteger();
            if (params.getData().available() != 0) {
                this.l = params.getData().getInteger().intValue();
            }
            if (params.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = val.getData().getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])encodedKey.clone();
            this.importPrivateKeyIntoToken(sessionManager, config);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPrivateKeyIntoToken(SessionManager sessionManager, Config config) {
        HashMap<Integer, Object> attribs = new HashMap<Integer, Object>();
        attribs.put(0, PKCS11Object.PRIVATE_KEY);
        attribs.put(256, PKCS11Object.DH);
        attribs.put(268, Boolean.TRUE);
        attribs.put(304, this.p);
        attribs.put(306, this.g);
        attribs.put(17, this.x.toByteArray());
        attribs.put(352, this.l);
        if (config != null) {
            attribs.putAll(config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH));
        }
        int[] pubTypes = new int[attribs.size()];
        Object[] pubValues = new Object[attribs.size()];
        Iterator it = attribs.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pubTypes[i] = (Integer)entry.getKey();
            pubValues[i++] = entry.getValue();
        }
        Session session = null;
        try {
            session = sessionManager.getObjSession();
            this.p11Object = session.createObject(pubTypes, pubValues);
            if (!session.getBoolAttributeValue(this.p11Object, 1)) {
                session.addObject();
            }
        }
        finally {
            sessionManager.releaseSession(session);
        }
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream tmp = new DerOutputStream();
                tmp.putInteger(PKCS8_VERSION);
                DerOutputStream algid = new DerOutputStream();
                algid.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream params = new DerOutputStream();
                params.putInteger(this.p);
                params.putInteger(this.g);
                if (this.l != 0) {
                    params.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue paramSequence = new DerValue(48, params.toByteArray());
                algid.putDerValue(paramSequence);
                tmp.write((byte)48, algid);
                tmp.putOctetString(this.key);
                DerOutputStream derKey = new DerOutputStream();
                derKey.write((byte)48, tmp);
                this.encodedKey = derKey.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g, this.l);
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.x = in.getInteger();
            this.l = this.x.bitLength();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    @Override
    public byte[] getSubject() {
        return null;
    }

    @Override
    public Boolean getSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 259);
    }

    @Override
    public Boolean getSecondaryAuth() {
        return (Boolean)this.getAttrValue(this.p11Object, 512);
    }

    @Override
    public Integer getAuthPinFlags() {
        return (Integer)this.getAttrValue(this.p11Object, 513);
    }

    @Override
    public Boolean getDecrypt() {
        return (Boolean)this.getAttrValue(this.p11Object, 261);
    }

    @Override
    public Boolean getSign() {
        return (Boolean)this.getAttrValue(this.p11Object, 264);
    }

    @Override
    public Boolean getSignRecover() {
        return (Boolean)this.getAttrValue(this.p11Object, 265);
    }

    @Override
    public Boolean getUnwrap() {
        return (Boolean)this.getAttrValue(this.p11Object, 263);
    }

    @Override
    public Boolean getExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 354);
    }

    @Override
    public Boolean getAlwaysSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 357);
    }

    @Override
    public Boolean getNeverExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 356);
    }

    public PKCS11Session getSession() {
        return this.p11Object.getSession();
    }

    @Override
    public PKCS11Object getObject() {
        return this.p11Object;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken == null && this.p11Object != null) {
            this.isToken = (Boolean)this.getAttrValue(this.p11Object, 1);
        }
        if (debug != null) {
            System.out.println("DHPKCS11PrivateKey.java:  getToken( ):  Returning a value of:  " + this.isToken);
        }
        return this.isToken;
    }

    @Override
    public Boolean getPrivate() {
        return (Boolean)this.getAttrValue(this.p11Object, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Object object = SessionManager.synchObj;
        synchronized (object) {
            block18: {
                int sessionObjectCount;
                if (!(debugKeyCleanup == null && debugSessionObjectCount == null || (sessionObjectCount = this.session.getObjectCount()) >= 0 && sessionObjectCount <= 2)) {
                    System.out.println("DHPKCS11PrivateKey.java:  rm():  Error:  The session object count for session ID = " + this.sessionID + " is:  " + sessionObjectCount);
                }
                if (this.p11Object != null) {
                    try {
                        Session sess = this.sessionManager.getOpSession();
                        sess.destroyObject(this.getObject());
                        this.p11Object = null;
                        this.sessionManager.releaseSession(sess);
                    }
                    catch (Exception ex) {
                        if (debugKeyCleanup == null && debugSessionObjectCount == null) break block18;
                        System.out.println("DHPKCS11PrivateKey.java:  rm():  The following exception was thrown trying to destroy the hardware key object.");
                        ex.printStackTrace(System.out);
                    }
                }
            }
            if ((debugKeyCleanup != null || debugSessionObjectCount != null) && this.session == null) {
                System.out.println("DHPKCS11PrivateKey.java:  rm():  Error:  The Java Session within this key is unexpectedly NULL.  EXITING.");
            }
            if (this.session != null) {
                try {
                    int objectCountBefore = 0;
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("===================================================================================================");
                        System.out.println("DHPKCS11PrivateKey.java:  rm():  The object count in session ID = " + this.sessionID + " before decrementing it is:  " + this.session.getObjectCount());
                        objectCountBefore = this.session.getObjectCount();
                    }
                    this.session.removeObject();
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("DHPKCS11PrivateKey.java:  rm():  The object count in session ID = " + this.sessionID + " after  decrementing it is:  " + this.session.getObjectCount());
                        int objectCountAfter = this.session.getObjectCount();
                        if (objectCountBefore - objectCountAfter != 1) {
                            System.out.println("DHPKCS11PrivateKey.java:  rm():  Error:  The object count in session ID = " + this.sessionID + " did not decrement correctly.  EXITING.");
                        }
                        System.out.println("===================================================================================================");
                    }
                    if (this.session.getObjectCount() <= 0 && this.session.session != null) {
                        if (debugKeyCleanup != null || debug != null || debugSessionObjectCount != null) {
                            System.out.println("DHPKCS11PrivateKey.java:  rm( ):  CLOSING the hardware session for session ID = " + this.sessionID);
                        }
                        this.sessionManager.closeSession(this.session);
                        if ((debugKeyCleanup != null || debugSessionObjectCount != null) && this.session.session != null) {
                            System.out.println("DHPKCS11PrivateKey.java:  rm():  Error:  After sessionManager.closeSession(), the reference to the hardware session within the Java Session object is not null.  EXITING.");
                        }
                        this.session = null;
                    }
                }
                catch (Exception ex) {
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("DHPKCS11PrivateKey.java:  rm():  The following exception was thrown while trying to close the hardware session.");
                        ex.printStackTrace(System.out);
                    }
                    throw ex;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this DHPKCS11PrivateKey object since it is a session key.");
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this DHPKCS11PrivateKey object since it is a token.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public Boolean getModifiable() {
        return (Boolean)this.getAttrValue(this.p11Object, 368);
    }

    @Override
    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    @Override
    public byte[] getID() {
        return (byte[])this.getAttrValue(this.p11Object, 258);
    }

    @Override
    public Date getStartDate() {
        return null;
    }

    @Override
    public Date getEndDate() {
        return null;
    }

    @Override
    public Boolean getDerive() {
        return (Boolean)this.getAttrValue(this.p11Object, 268);
    }

    @Override
    public Boolean getLocal() {
        return (Boolean)this.getAttrValue(this.p11Object, 355);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        Session sess = null;
        try {
            sess = this.sessionManager.getOpSession();
            rtn = sess.getAttrValue(pkcs11obj, attr);
        }
        finally {
            if (sess != null) {
                this.sessionManager.releaseSession(sess);
            }
        }
        return rtn;
    }

    private Object getAttrValue(Session sess, PKCS11Object pkcs11obj, int attr) {
        return sess.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSession(Session sess) {
        this.session = sess;
        this.sessionID = sess.getID();
        sess.isThisSessionAssociatedWithAKey = true;
    }

    @Override
    public void setKeyAsToken(boolean token) {
        this.isToken = token;
    }
}

