/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

abstract class ProgramOption {
    static final HashMap Configuration = new HashMap();
    static final List AnonymousArgs = new LinkedList();
    static final HashMap options = new HashMap();
    static HashMap defaultOptions = null;

    ProgramOption() {
    }

    abstract String getDescription();

    abstract String getName();

    abstract Object getValue();

    static Object getValue(String optionName) {
        return ((ProgramOption)Configuration.get(optionName)).getValue();
    }

    String getUsage() {
        return this.getName();
    }

    abstract void setValue(String var1) throws IllegalArgumentException;

    void setAutomatic() {
        throw new IllegalArgumentException("Value must be specified for " + this.getName());
    }

    void setDefault() {
        throw new IllegalArgumentException("No default value available for " + this.getName());
    }

    boolean required() {
        return false;
    }

    static void addOption(Class option) {
        try {
            ProgramOption tmp = (ProgramOption)option.newInstance();
            options.put(tmp.getName(), option);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void addArgument(String arg) throws IllegalArgumentException {
        String key = arg;
        String value = null;
        if (arg.charAt(0) != '-') {
            AnonymousArgs.add(arg);
            return;
        }
        key = arg.substring(1);
        if (key.equals("help")) {
            throw new IllegalArgumentException(ProgramOption.help());
        }
        if (defaultOptions == null) {
            defaultOptions = (HashMap)options.clone();
        }
        if (key.indexOf(61) != -1) {
            key = key.substring(0, key.indexOf(61));
            value = arg.substring(arg.indexOf(61) + 1);
        }
        if (options.containsKey(key)) {
            Class type = (Class)options.get(key);
            try {
                ProgramOption option = (ProgramOption)type.newInstance();
                if (value != null) {
                    option.setValue(value);
                } else {
                    option.setAutomatic();
                }
                Configuration.put(option.getName(), option);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("Error while constructing parser for command line option \"" + key + "\"");
            }
            defaultOptions.remove(key);
            return;
        }
        throw new IllegalArgumentException("Usage error: unknown argument, \"" + arg + "\"" + System.getProperty("line.separator") + System.getProperty("line.separator") + ProgramOption.help());
    }

    static void applyDefaults() {
        if (defaultOptions == null) {
            defaultOptions = (HashMap)options.clone();
        }
        for (Class type : defaultOptions.values()) {
            try {
                ProgramOption option = (ProgramOption)type.newInstance();
                option.setDefault();
                Configuration.put(option.getName(), option);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("Error while constructing default values");
            }
        }
    }

    public static String help() {
        StringBuffer help = new StringBuffer("Usage: \n");
        StringBuffer synopsis = new StringBuffer("com.ibm.jvm.TraceFormat");
        StringBuffer sb = new StringBuffer("Option details:" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        for (Class type : options.values()) {
            try {
                ProgramOption option = (ProgramOption)type.newInstance();
                String name = option.getName();
                String usage = option.getUsage();
                if (option.required()) {
                    synopsis.append(" " + usage);
                } else {
                    synopsis.append(" [" + usage + "]");
                }
                sb.append(name + ": " + option.getDescription() + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            catch (Exception e) {
                System.err.println("Error while constructing default values");
            }
        }
        return help.append(synopsis).append(System.getProperty("line.separator") + System.getProperty("line.separator")).append(sb).toString();
    }
}

