/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.stacks;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.stacks.Messages;
import com.ibm.java.diagnostics.healthcenter.stacks.StackData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTraceDataPoint;
import com.ibm.java.diagnostics.healthcenter.stacks.ThreadState;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J9AuxTraceHandler
implements TracePointHandler {
    private static final Logger TRACE = LogFactory.getTrace(J9AuxTraceHandler.class);
    private static final String COMPILED_CODE = " (Compiled Code)";
    static final int JSTACKTRACE = 0;
    static final int JSTACKTRACE_ENTRY = 1;
    static final String DG_COMPONENT = "dg";
    static final int UT_TRC_PURGE_ID = 262;
    private final Map<TracedThread, ThreadState> threadStateMap = new HashMap<TracedThread, ThreadState>();
    private AxisPair axisPair = null;
    private XDataAxis xAxis = null;
    private StackData stackData;
    private static final DataFactory factory = DataFactory.getFactory();

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (tracedThread == null) {
            this.threadStateMap.clear();
        } else if (this.threadStateMap.containsKey(tracedThread)) {
            this.threadStateMap.remove(tracedThread);
        }
    }

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        this.xAxis = AxisUtil.prepareXAxis(outputProperties);
        YDataAxis yDataAxis = AxisUtil.prepareBinaryAxis(outputProperties);
        this.axisPair = factory.createAxisPair(this.xAxis, yDataAxis);
        this.stackData = StackData.createStackData(dataBuilder, this.axisPair);
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (tracePoint == null) {
            return;
        }
        String string = tracePoint.getComponent();
        if (string == null) {
            return;
        }
        if (string.equals("j9trc_aux")) {
            this.handleAuxTracePoint(tracePoint, dataBuilder, traceMetaData);
        } else if (string.equals(DG_COMPONENT)) {
            this.handleDgTracePoint(tracePoint);
        } else {
            this.handleNonAuxTracePoint(tracePoint);
        }
    }

    private void handleDgTracePoint(TracePoint tracePoint) {
        int n = tracePoint.getID();
        if (n == 262) {
            this.threadStateMap.remove(tracePoint.getThread());
        }
    }

    private ThreadState getThreadState(TracedThread tracedThread) {
        ThreadState threadState = this.threadStateMap.get(tracedThread);
        if (threadState == null) {
            threadState = new ThreadState();
            this.threadStateMap.put(tracedThread, threadState);
        }
        return threadState;
    }

    private void handleNonAuxTracePoint(TracePoint tracePoint) {
        ThreadState threadState = this.getThreadState(tracePoint.getThread());
        StackTraceDataPoint stackTraceDataPoint = threadState.getCurrentStackDataPoint();
        if (stackTraceDataPoint != null) {
            this.stackData.addStackDataPoint(stackTraceDataPoint);
        }
        threadState.setCurrentStackDataPoint(null);
        threadState.setCurrentTracepoint(tracePoint);
    }

    private void handleAuxTracePoint(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        int n = tracePoint.getID();
        TracedThread tracedThread = tracePoint.getThread();
        ThreadState threadState = this.getThreadState(tracedThread);
        if (n == 1) {
            this.handleJStackTraceEntry(threadState, tracePoint, dataBuilder, traceMetaData);
        }
    }

    public void handleJStackTraceEntry(ThreadState threadState, TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray = this.getTracepointParameters(tracePoint, 2);
        if (objectArray == null) {
            return;
        }
        TracePoint tracePoint2 = threadState.getCurrentTracepoint();
        if (tracePoint2 == null) {
            return;
        }
        StackTraceDataPoint stackTraceDataPoint = threadState.getCurrentStackDataPoint();
        if (stackTraceDataPoint == null) {
            stackTraceDataPoint = new StackTraceDataPoint(this.axisPair, tracePoint2, traceMetaData);
            threadState.setCurrentStackDataPoint(stackTraceDataPoint);
        }
        int n = ((Long)objectArray[0]).intValue();
        String string = (String)objectArray[1];
        if (string.endsWith(COMPILED_CODE)) {
            string = string.substring(0, string.lastIndexOf(COMPILED_CODE));
        }
        stackTraceDataPoint.addStackEntry(n, this.stackData.addStackEntry(string));
    }

    private Object[] getTracepointParameters(TracePoint tracePoint, int n) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return null;
        }
        int n2 = objectArray.length;
        if (n2 != n) {
            TRACE.log(Level.WARNING, Messages.getString("J9AuxTracehandler.check.parameters"), new Object[]{tracePoint.getID(), tracePoint.getComponent(), n2, n});
            return null;
        }
        return objectArray;
    }
}

