/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ProfilingInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ProfilingInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ProfilingEventHandler
extends Thread {
    List<ProfilingInternalEvent> listeners = new ArrayList<ProfilingInternalEvent>();
    Queue<ProfilingInternalObject> events = new ConcurrentLinkedQueue<ProfilingInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public ProfilingEventHandler() {
        super("Profiling Event Handler");
        this.setDaemon(true);
    }

    public void addProfilingEventListener(ProfilingInternalEvent profilingInternalEvent) {
        this.listeners.add(profilingInternalEvent);
    }

    private void triggerProfiling(ProfilingInternalObject profilingInternalObject) {
        for (ProfilingInternalEvent profilingInternalEvent : this.listeners) {
            profilingInternalEvent.profilingEvent(profilingInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ProfilingInternalObject profilingInternalObject) {
        Queue<ProfilingInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(profilingInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerProfiling(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerProfiling(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<ProfilingInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

