/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GCEventHandler
extends Thread {
    List<GCInternalEvent> listeners = new ArrayList<GCInternalEvent>();
    Queue<GCInternalObject> events = new ConcurrentLinkedQueue<GCInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public GCEventHandler() {
        super("Garbage Collection Event Handler");
        this.setDaemon(true);
    }

    public void addGCEventListener(GCInternalEvent gCInternalEvent) {
        this.listeners.add(gCInternalEvent);
    }

    private void triggerGC(GCInternalObject gCInternalObject) {
        for (GCInternalEvent gCInternalEvent : this.listeners) {
            gCInternalEvent.gcEvent(gCInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(GCInternalObject gCInternalObject) {
        Queue<GCInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(gCInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerGC(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerGC(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<GCInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

