/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.locking.data;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisPairImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.locking.LockingLabels;
import com.ibm.java.diagnostics.healthcenter.locking.data.Messages;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorMetrics;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class MonitorData
extends DataImpl {
    private static final Logger TRACE = LogFactory.getTrace(MonitorData.class);
    private static final String MONITOR_NAME_LABEL = LockingLabels.MONITOR_NAME_LABEL;
    private static final String[] columnTitles = new String[]{LockingLabels.PERCENT_MISS_LABEL, LockingLabels.GETS_LABEL, LockingLabels.NONRECURSIVE_LABEL, LockingLabels.SLOW_LABEL, LockingLabels.RECURSIVE_LABEL, LockingLabels.TIER2_LABEL, LockingLabels.TIER3_LABEL, LockingLabels.PERCENT_UTIL_LABEL, LockingLabels.AVERAGE_HOLD_TIME_LABEL, MONITOR_NAME_LABEL};
    private final XDataAxis xAxis;
    private YDataAxis countAxis;
    private final YDataAxis cyclesAxis;
    private final OutputProperties props;

    public MonitorData(String string, OutputProperties outputProperties, XDataAxis xDataAxis, YDataAxis yDataAxis, YDataAxis yDataAxis2) {
        super(string);
        this.xAxis = xDataAxis;
        this.countAxis = yDataAxis;
        this.cyclesAxis = yDataAxis2;
        this.props = outputProperties;
    }

    @Override
    public DataBuilder getData(String string) {
        DataBuilder dataBuilder = super.getData(this.constructId(string));
        if (dataBuilder == null) {
            return super.getData(string);
        }
        return dataBuilder;
    }

    @Override
    protected void evaluateDataForDeletion(double d, String string) {
        if (this.isEmpty()) {
            this.getParent().removeData(this.id);
        }
    }

    protected void evaluateDataForTruncation(double d) {
        if (this.isEmpty()) {
            this.getParent().removeData(this.id);
        }
    }

    @Override
    public DataBuilder getTopLevelData(String string) {
        DataBuilder dataBuilder = super.getTopLevelData(this.constructId(string));
        if (dataBuilder == null) {
            return super.getTopLevelData(string);
        }
        return dataBuilder;
    }

    @Override
    public boolean isEmpty() {
        DataBuilder[] dataBuilderArray = this.getChildren();
        if (dataBuilderArray == null || dataBuilderArray.length == 0) {
            return true;
        }
        for (DataBuilder dataBuilder : dataBuilderArray) {
            if (dataBuilder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static String[] getColumnTitles() {
        String[] stringArray = new String[columnTitles.length];
        System.arraycopy(columnTitles, 0, stringArray, 0, columnTitles.length);
        return stringArray;
    }

    public Object[] toArray() {
        if (this.isEmpty()) {
            return null;
        }
        int n = columnTitles.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.toObject(i);
        }
        return objectArray;
    }

    public void addMonitorMetrics(MonitorMetrics monitorMetrics, int n) {
        double d = monitorMetrics.getTimeMillis();
        double d2 = monitorMetrics.getIntervalTime();
        double d3 = monitorMetrics.getGets();
        double d4 = monitorMetrics.getNonRecursive();
        double d5 = monitorMetrics.getSlow();
        double d6 = monitorMetrics.getRecursive();
        double d7 = monitorMetrics.getTier2();
        double d8 = monitorMetrics.getTier3();
        double d9 = (double)monitorMetrics.getAverageHoldTime() * d4;
        this.addMonitorMetric(LockingLabels.INTERVAL_TIME_LABEL, n, d, d2 - this.getTotalY(LockingLabels.INTERVAL_TIME_LABEL));
        this.addMonitorMetric(LockingLabels.GETS_LABEL, n, d, d3 - this.getTotalY(LockingLabels.GETS_LABEL));
        this.addMonitorMetric(LockingLabels.NONRECURSIVE_LABEL, n, d, d4 - this.getTotalY(LockingLabels.NONRECURSIVE_LABEL));
        this.addMonitorMetric(LockingLabels.SLOW_LABEL, n, d, d5 - this.getTotalY(LockingLabels.SLOW_LABEL));
        this.addMonitorMetric(LockingLabels.RECURSIVE_LABEL, n, d, d6 - this.getTotalY(LockingLabels.RECURSIVE_LABEL));
        this.addMonitorMetric(LockingLabels.TIER2_LABEL, n, d, d7 - this.getTotalY(LockingLabels.TIER2_LABEL));
        this.addMonitorMetric(LockingLabels.TIER3_LABEL, n, d, d8 - this.getTotalY(LockingLabels.TIER3_LABEL));
        this.addMonitorMetric(LockingLabels.HOLD_TIME_LABEL, n, d, d9 - this.getTotalY(LockingLabels.HOLD_TIME_LABEL));
    }

    public Object toObject(int n) {
        switch (n) {
            case 0: {
                double d = this.getTotalsRatio(LockingLabels.SLOW_LABEL, LockingLabels.NONRECURSIVE_LABEL) * 100.0;
                return d;
            }
            case 1: {
                double d = this.getTotalY(LockingLabels.GETS_LABEL);
                return d;
            }
            case 2: {
                double d = this.getTotalY(LockingLabels.NONRECURSIVE_LABEL);
                return d;
            }
            case 3: {
                double d = this.getTotalY(LockingLabels.SLOW_LABEL);
                return d;
            }
            case 4: {
                double d = this.getTotalY(LockingLabels.RECURSIVE_LABEL);
                return d;
            }
            case 5: {
                double d = this.getTotalY(LockingLabels.TIER2_LABEL);
                return d;
            }
            case 6: {
                double d = this.getTotalY(LockingLabels.TIER3_LABEL);
                return d;
            }
            case 7: {
                double d = this.getTotalsRatio(LockingLabels.HOLD_TIME_LABEL, LockingLabels.INTERVAL_TIME_LABEL) * 100.0;
                return d;
            }
            case 8: {
                double d = this.getTotalsRatio(LockingLabels.HOLD_TIME_LABEL, LockingLabels.NONRECURSIVE_LABEL);
                return d;
            }
            case 9: {
                return this.getLabel();
            }
        }
        throw new IndexOutOfBoundsException(Messages.getString("MonitorData.invalid.index"));
    }

    private void addMonitorMetric(String string, int n, double d, double d2) {
        String string2;
        Object object;
        if (d2 == 0.0) {
            return;
        }
        TwoDimensionalData twoDimensionalData = this.getTwoDimensionalData(string);
        if (twoDimensionalData == null) {
            object = Messages.getString("MonitorData.could.not.find.monitoring.data");
            string2 = MessageFormat.format((String)object, string);
            TRACE.warning(string2);
        }
        if (twoDimensionalData instanceof TwoDimensionalDataBuilder) {
            object = (TwoDimensionalDataBuilder)twoDimensionalData;
            object.addDataPoint(n, d, d2);
        } else if (twoDimensionalData != null) {
            object = Messages.getString("MonitorData.non.two.dimensional.data");
            string2 = MessageFormat.format((String)object, string, twoDimensionalData.getClass());
            TRACE.warning(string2);
        }
    }

    private Data findOrCreateData(String string) {
        DataBuilder dataBuilder = this.getTopLevelData(this.constructId(string));
        if (dataBuilder != null) {
            return dataBuilder;
        }
        if (LockingLabels.INTERVAL_TIME_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.INTERVAL_TIME_LABEL), LockingLabels.INTERVAL_TIME_LABEL, this.xAxis, this.cyclesAxis, this.props);
        }
        if (LockingLabels.GETS_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.GETS_LABEL), LockingLabels.GETS_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.NONRECURSIVE_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.NONRECURSIVE_LABEL), LockingLabels.NONRECURSIVE_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.SLOW_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.SLOW_LABEL), LockingLabels.SLOW_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.RECURSIVE_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.RECURSIVE_LABEL), LockingLabels.RECURSIVE_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.TIER2_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.TIER2_LABEL), LockingLabels.TIER2_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.TIER3_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.TIER3_LABEL), LockingLabels.TIER3_LABEL, this.xAxis, this.countAxis, this.props);
        }
        if (LockingLabels.HOLD_TIME_LABEL.equals(string)) {
            return this.addTwoDimensionalData(this.constructId(LockingLabels.HOLD_TIME_LABEL), LockingLabels.HOLD_TIME_LABEL, this.xAxis, this.cyclesAxis, this.props);
        }
        return null;
    }

    private TwoDimensionalDataBuilder addTwoDimensionalData(String string, String string2, XDataAxis xDataAxis, YDataAxis yDataAxis, OutputProperties outputProperties) {
        TwoDimensionalDataImpl twoDimensionalDataImpl = new TwoDimensionalDataImpl(string, string2, new AxisPairImpl(xDataAxis, yDataAxis));
        this.addData(twoDimensionalDataImpl);
        return twoDimensionalDataImpl;
    }

    private String constructId(String string) {
        return string + this.getLabel();
    }

    private TwoDimensionalData getTwoDimensionalData(String string) {
        Data data = this.findOrCreateData(string);
        if (data == null) {
            String string2 = Messages.getString("MonitorData.could.not.find.two.dimensional.data");
            String string3 = MessageFormat.format(string2, string);
            TRACE.warning(string3);
            return null;
        }
        if (data instanceof TwoDimensionalData) {
            TwoDimensionalData twoDimensionalData = (TwoDimensionalData)data;
            return twoDimensionalData;
        }
        String string4 = Messages.getString("MonitorData.not.two.dimensional.data");
        String string5 = MessageFormat.format(string4, string);
        TRACE.warning(string5);
        return null;
    }

    private double getTotalY(String string) {
        DataBuilder dataBuilder = this.getTopLevelData(this.constructId(string));
        if (dataBuilder instanceof TwoDimensionalData && dataBuilder != null) {
            TwoDimensionalData twoDimensionalData = (TwoDimensionalData)((Object)dataBuilder);
            return twoDimensionalData.getTotalY();
        }
        return 0.0;
    }

    private double getTotalsRatio(String string, String string2) {
        double d = this.getTotalY(string2);
        double d2 = 0.0;
        if (d > 0.0) {
            double d3 = this.getTotalY(string);
            d2 = d3 / d;
        }
        return d2;
    }
}

