/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace.impl;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Logger;

public class EBCDICToASCIIDetectingParser
implements ByteParser {
    private static final int ASCII_SUB_CHARACTER = 26;
    private static final int MANGLED_ASCII_LETTER = 26;
    private static final Logger TRACE = LogFactory.getTrace(EBCDICToASCIIDetectingParser.class);
    private static final byte[] Z_ENDIAN_SIGNATURE = new byte[]{18, 26, 26, 26};
    private static final int ENDIAN_SIGNATURE_POSITION = 20;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, byte[] byArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        ProgressIndicator progressIndicator;
        TRACE.entering(this.getClass().getName(), "parse");
        if (byArray.length < 20 + Z_ENDIAN_SIGNATURE.length) {
            return new ProgressIndicatorImpl(0, 20 + Z_ENDIAN_SIGNATURE.length);
        }
        if (byArray[0] == 26 && byArray[1] == 26 && byArray[2] == 26 && byArray[3] == 26) {
            boolean bl = true;
            for (int i = 0; i < Z_ENDIAN_SIGNATURE.length; ++i) {
                if (byArray[20 + i] == Z_ENDIAN_SIGNATURE[i]) continue;
                bl = false;
            }
            if (bl) {
                String string = Messages.getString("EBCDICToASCIIDetectingParser.corrupted.ebcdic.trace.file");
                DataBuilder dataBuilder2 = dataBuilder.getData(JVMLabels.CONNECTION);
                if (dataBuilder2 instanceof StringDataBuilder) {
                    StringDataBuilder stringDataBuilder = (StringDataBuilder)dataBuilder2;
                    stringDataBuilder.addValue(string);
                    stringDataBuilder.setStatus(Status.PROBLEM);
                }
                progressIndicator = ProgressIndicatorImpl.COMPLETE_PROGRESS;
            } else {
                progressIndicator = ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
            }
        } else {
            progressIndicator = ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        TRACE.exiting(this.getClass().getName(), "parse");
        return progressIndicator;
    }
}

