/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.slicer;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.Parser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Slicer;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Logger;

public abstract class SlicerImpl
implements Slicer {
    private static final int REPARSE_COUNT = 10;
    private static Logger TRACE = LogFactory.getTrace(SlicerImpl.class);
    private static final int MAX_RETRIES = 6;
    protected final Parser parser;
    protected final Source source;
    protected int sliceSize;
    private boolean enabled = true;
    private int tries = 0;
    protected static final String TO_STRING_TEMPLATE = Messages.getString("SlicerImpl.to.string.template");
    protected int lastPosition = 0;
    protected static final String NULL_DATA_WARNING = Messages.getString("FileSlicerImpl.null.data.warning");
    protected final Marshaller marshaller;

    public SlicerImpl(Source source, Parser parser, Marshaller marshaller) throws JavaDiagnosticsException {
        this.source = source;
        this.parser = parser;
        this.marshaller = marshaller;
        this.sliceSize = this.getDefaultSliceSize();
    }

    protected abstract int getDefaultSliceSize();

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getSliceSize() {
        return this.sliceSize;
    }

    @Override
    public void setSliceSize(int n) {
        this.sliceSize = n;
    }

    @Override
    public String getSourceName() {
        return this.source.getName();
    }

    public final Parser getParser() {
        return this.parser;
    }

    public String toString() {
        return MessageFormat.format(TO_STRING_TEMPLATE, this.getClass().getSimpleName(), this.parser.getClass().getSimpleName());
    }

    @Override
    public ProgressIndicator triggerParse(DataBuilder dataBuilder, OutputProperties outputProperties) {
        ProgressIndicator progressIndicator = null;
        int n = 0;
        long l = 0L;
        boolean bl = true;
        int n2 = 0;
        if (bl && this.enabled) {
            do {
                ++n2;
                int n3 = 0;
                long l2 = 0L;
                try {
                    progressIndicator = this.internalTriggerParse(dataBuilder, outputProperties);
                    if (progressIndicator == null) continue;
                    n3 = progressIndicator.getProgress();
                    l2 = progressIndicator.getProgressInBytes();
                    if (n3 == 0 || n3 == -1 || n3 == -2) {
                        if (this.tries > 6 || n3 == -1 || n3 == -2) {
                            this.disable();
                            continue;
                        }
                        ++this.tries;
                        int n4 = progressIndicator.getMinimumSliceSize();
                        if (n4 > 0 && n4 > this.sliceSize) {
                            this.setSliceSize(progressIndicator.getMinimumSliceSize());
                            continue;
                        }
                        this.setSliceSize(4 * this.sliceSize);
                        continue;
                    }
                    this.tries = 0;
                    n += n3;
                    l += l2;
                }
                catch (Throwable throwable) {
                    TRACE.warning(MessageFormat.format(Messages.getString("SlicerImpl.caught.exception"), throwable, this.parser));
                    this.enabled = false;
                    throwable.printStackTrace();
                }
            } while (bl && this.enabled && this.isAnySourceAvailable() && n2 < 10);
        }
        if (this.isAnySourceAvailable() && this.enabled && n > 0) {
            this.marshaller.addToQueue(this);
        }
        return new ProgressIndicatorImpl(n, l, this.getSliceSize());
    }

    protected void disable() {
        TRACE.fine(MessageFormat.format("Disabling {0}", this));
        this.getSource().removeSourceListener(this);
        this.enabled = false;
        this.clearBufferCaches();
    }

    @Override
    public abstract boolean isAnySourceAvailable();

    protected abstract void clearBufferCaches();

    protected abstract ProgressIndicator internalTriggerParse(DataBuilder var1, OutputProperties var2) throws JavaDiagnosticsException, IOException;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setLastPosition(int n) {
        this.lastPosition = n;
    }

    protected int getLastPosition() {
        return this.lastPosition;
    }
}

