/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import java.util.logging.Logger;

public abstract class HealthCenterThread
extends Thread {
    private static final int UNSET = -1;
    private static final Logger TRACE = LogFactory.getTrace(HealthCenterThread.class);
    protected volatile int timingIntervalOverride = -1;
    protected volatile boolean run = true;
    protected Marshaller marshaller;

    public HealthCenterThread(String string, Marshaller marshaller) {
        super(string);
        this.marshaller = marshaller;
    }

    protected abstract void queueWork();

    @Override
    public void run() {
        while (this.run) {
            try {
                this.queueWork();
                if (HealthCenterThread.interrupted()) continue;
                Thread.sleep(this.queryTimingInterval());
            }
            catch (InterruptedException interruptedException) {
                if (!this.run) continue;
                TRACE.warning(interruptedException.toString());
            }
        }
    }

    protected int queryTimingInterval() {
        if (this.timingIntervalOverride >= 0) {
            return this.timingIntervalOverride;
        }
        return this.getDefaultTimingInterval();
    }

    protected abstract int getDefaultTimingInterval();

    public void overrideFrequency(int n) {
        int n2 = this.timingIntervalOverride;
        this.timingIntervalOverride = n;
        if (n2 > this.timingIntervalOverride) {
            this.queueWork();
        }
    }

    public void clearFrequencyOverride() {
        this.timingIntervalOverride = -1;
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
        this.marshaller = null;
    }
}

