/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.gc.data.objectallocations.ObjectAllocationTableData;
import com.ibm.java.diagnostics.healthcenter.gc.data.objectallocations.ObjectAllocationTableRow;
import com.ibm.java.diagnostics.healthcenter.gc.data.sampling.GCSampleTableData;
import com.ibm.java.diagnostics.healthcenter.gc.data.sampling.GCSampleTableRow;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.AllocationThresholdDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.OutOfLineAllocationDataPoint;

public class GCSampleDataPostProcessor
implements PostProcessor {
    private static final String EMPTY_STRING = "";

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (dataBuilder2 != null) {
            this.processSampleData(dataBuilder, dataBuilder2);
            this.processObjectAllocationData(dataBuilder, dataBuilder2);
        }
    }

    private void processSampleData(DataBuilder dataBuilder, DataBuilder dataBuilder2) {
        dataBuilder2.removeData(GCLabels.GC_SAMPLE_DATA);
        GCSampleTableData gCSampleTableData = new GCSampleTableData(GCLabels.GC_SAMPLE_DATA);
        dataBuilder2.addData(gCSampleTableData);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder2.getData(GCLabels.OUT_OF_LINE_OBJECT_ALLOCATION);
        if (twoDimensionalDataBuilder == null) {
            return;
        }
        DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
        int n = dataPointBuilderArray.length;
        for (int i = 0; i < dataPointBuilderArray.length; ++i) {
            OutOfLineAllocationDataPoint outOfLineAllocationDataPoint = (OutOfLineAllocationDataPoint)dataPointBuilderArray[i];
            String string = outOfLineAllocationDataPoint.getClassName();
            if (string.equals(EMPTY_STRING) || gCSampleTableData.contains(string)) continue;
            TwoDimensionalData twoDimensionalData = (TwoDimensionalData)twoDimensionalDataBuilder.getTopLevelData(string);
            double d = 0.0;
            double d2 = 0.0;
            if (twoDimensionalData != null) {
                d = twoDimensionalData.getDataPoints().length;
                d2 = twoDimensionalData.getRawTotalY() / 1024.0;
            }
            double d3 = d / (double)n * 100.0;
            gCSampleTableData.addRow(new GCSampleTableRow(string, (int)d, d3, d2));
        }
    }

    private void processObjectAllocationData(DataBuilder dataBuilder, DataBuilder dataBuilder2) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder2.getData(GCLabels.OBJECT_ALLOCATION_THRESHOLD);
        if (twoDimensionalDataBuilder == null) {
            return;
        }
        twoDimensionalDataBuilder.removeData(GCLabels.ALLOCATION_SIZES_BY_SITE);
        ObjectAllocationTableData objectAllocationTableData = new ObjectAllocationTableData(GCLabels.ALLOCATION_SIZES_BY_SITE);
        twoDimensionalDataBuilder.addData(objectAllocationTableData);
        DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
        for (int i = 0; i < dataPointBuilderArray.length; ++i) {
            AllocationThresholdDataPointImpl allocationThresholdDataPointImpl = (AllocationThresholdDataPointImpl)dataPointBuilderArray[i];
            String string = allocationThresholdDataPointImpl.getStackTop();
            if (string.equals(EMPTY_STRING)) continue;
            ObjectAllocationTableRow objectAllocationTableRow = (ObjectAllocationTableRow)objectAllocationTableData.get(string);
            double d = 0.0;
            double d2 = 0.0;
            if (objectAllocationTableRow != null) {
                d = objectAllocationTableRow.getTotalSize();
                d2 = objectAllocationTableRow.getCount();
            }
            double d3 = (d2 += 1.0) / (double)dataPointBuilderArray.length * 100.0;
            objectAllocationTableData.addRow(new ObjectAllocationTableRow(string, (int)d2, d3, d += allocationThresholdDataPointImpl.getRawY() / 1024.0));
        }
    }
}

