/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.data;

import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.SubsystemDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.data.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.util.List;

public class EnvironmentDataImpl
extends SubsystemDataImpl
implements EnvironmentData {
    public static final String PERSPECTIVE_ID = "com.ibm.java.diagnostics.healthcenter.environment.perspective";
    private List<String> commandLineOptions;
    private VMLevelChecker checker;
    private List<String> dumpOptions;
    private String realtime = null;

    public EnvironmentDataImpl() {
        super(EnvironmentLabels.ENVIRONMENT_LABEL, PERSPECTIVE_ID);
    }

    @Override
    public int getPid() {
        int n = 0;
        StringData stringData = (StringData)((Object)this.getData(EnvironmentLabels.PID));
        if (stringData != null) {
            n = Integer.valueOf(stringData.getValue());
        }
        return n;
    }

    public void setCommandLineOptions(List<String> list) {
        this.commandLineOptions = list;
    }

    @Override
    public List<String> getCommandLineOptions() {
        return this.commandLineOptions;
    }

    public void setDumpOptions(List<String> list) {
        this.dumpOptions = list;
    }

    public List<String> getDumpOptions() {
        return this.dumpOptions;
    }

    @Override
    public String getAgentVersion() {
        StringData stringData = (StringData)((Object)this.getData(EnvironmentLabels.AGENT_JAR_VERSION));
        if (stringData != null) {
            return stringData.getValue();
        }
        return Messages.getString("EnvironmentDataImpl.unknown.agent.version");
    }

    @Override
    public TableData getSystemProperties() {
        return (TableData)((Object)this.getData(EnvironmentLabels.SYSTEM_PROPERTIES));
    }

    @Override
    public boolean isVMOlderThan(int n) {
        if (this.getVMLevelChecker() != null) {
            return this.checker.isVMOlderThan(n);
        }
        return true;
    }

    @Override
    public VMLevelChecker getVMLevelChecker() {
        String string = this.getSystemProperty("java.fullversion");
        if (!(string == null || this.checker != null && this.checker.getFullVersion().equals(string))) {
            this.checker = new VMLevelChecker(string);
        }
        return this.checker;
    }

    private String getSystemProperty(String string) {
        TableDataRow tableDataRow;
        TableData tableData = this.getSystemProperties();
        String string2 = null;
        if (tableData != null && (tableDataRow = tableData.get(string)) != null && tableDataRow.getRowData().length == 2) {
            string2 = (String)tableDataRow.getRowData()[1];
        }
        return string2;
    }

    public String getJavaParameter(String string) {
        String string2 = null;
        List<String> list = this.getCommandLineOptions();
        if (list == null) {
            return null;
        }
        Object[] objectArray = list.toArray();
        for (int i = 0; i < list.size(); ++i) {
            String string3 = objectArray[i].toString();
            if (!string3.contains(string)) continue;
            return string3;
        }
        return string2;
    }

    private boolean isVMRealtime() {
        this.realtime = this.getSystemProperty("com.ibm.jvm.realtime");
        return this.realtime != null;
    }

    @Override
    public boolean isVMSoftRealtime() {
        return this.isVMRealtime() && this.realtime != null && this.realtime.equals("soft");
    }

    @Override
    public boolean isVMHardRealtime() {
        return this.isVMRealtime() && this.realtime != null && this.realtime.equals("hard");
    }
}

